/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import codechicken.lib.vec.Vector3;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import mekanism.api.gas.GasNetwork;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class PartPressurizedTube
extends PartTransmitter<GasNetwork> {
    public static TransmitterIcons tubeIcons = new TransmitterIcons(1, 1);
    public float currentScale;
    public GasStack cacheGas;
    public GasStack lastWrite;

    @Override
    public void update() {
        if (!this.world().field_72995_K) {
            if (this.cacheGas != null) {
                if (((GasNetwork)this.getTransmitterNetwork()).gasStored == null) {
                    ((GasNetwork)this.getTransmitterNetwork()).gasStored = this.cacheGas;
                } else {
                    ((GasNetwork)this.getTransmitterNetwork()).gasStored.amount += this.cacheGas.amount;
                }
                this.cacheGas = null;
            }
            if (this.getTransmitterNetwork(false) != null && ((GasNetwork)this.getTransmitterNetwork(false)).getSize() > 0) {
                int last;
                int n = last = this.lastWrite != null ? this.lastWrite.amount : 0;
                if (last != this.getSaveShare()) {
                    MekanismUtils.saveChunk((TileEntity)this.tile());
                }
            }
        } else {
            float targetScale = ((GasNetwork)this.getTransmitterNetwork()).gasScale;
            if ((double)Math.abs(this.currentScale - targetScale) > 0.01) {
                this.currentScale = (9.0f * this.currentScale + targetScale) / 10.0f;
            }
        }
        super.update();
    }

    private int getSaveShare() {
        if (((GasNetwork)this.getTransmitterNetwork()).gasStored != null) {
            int remain = ((GasNetwork)this.getTransmitterNetwork()).gasStored.amount % ((GasNetwork)this.getTransmitterNetwork()).transmitters.size();
            int toSave = ((GasNetwork)this.getTransmitterNetwork()).gasStored.amount / ((GasNetwork)this.getTransmitterNetwork()).transmitters.size();
            if (((GasNetwork)this.getTransmitterNetwork()).isFirst((IGridTransmitter)this.tile())) {
                toSave += remain;
            }
            return toSave;
        }
        return 0;
    }

    @Override
    public TransmitterType getTransmitter() {
        return TransmitterType.PRESSURIZED_TUBE;
    }

    @Override
    public void preSingleMerge(GasNetwork network) {
        if (this.cacheGas != null) {
            if (network.gasStored == null) {
                network.gasStored = this.cacheGas;
            } else {
                network.gasStored.amount += this.cacheGas.amount;
            }
            this.cacheGas = null;
        }
    }

    @Override
    public void onChunkUnload() {
        if (!this.world().field_72995_K && this.lastWrite != null && ((GasNetwork)this.getTransmitterNetwork()).gasStored != null) {
            ((GasNetwork)this.getTransmitterNetwork()).gasStored.amount -= this.lastWrite.amount;
            if (((GasNetwork)this.getTransmitterNetwork()).gasStored.amount <= 0) {
                ((GasNetwork)this.getTransmitterNetwork()).gasStored = null;
            }
        }
        super.onChunkUnload();
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        if (nbtTags.func_74764_b("cacheGas")) {
            this.cacheGas = GasStack.readFromNBT(nbtTags.func_74775_l("cacheGas"));
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        super.save(nbtTags);
        if (((GasNetwork)this.getTransmitterNetwork()).gasStored != null) {
            int remain = ((GasNetwork)this.getTransmitterNetwork()).gasStored.amount % ((GasNetwork)this.getTransmitterNetwork()).transmitters.size();
            int toSave = ((GasNetwork)this.getTransmitterNetwork()).gasStored.amount / ((GasNetwork)this.getTransmitterNetwork()).transmitters.size();
            if (((GasNetwork)this.getTransmitterNetwork()).isFirst((IGridTransmitter)this.tile())) {
                toSave += remain;
            }
            if (toSave > 0) {
                GasStack stack;
                this.lastWrite = stack = new GasStack(((GasNetwork)this.getTransmitterNetwork()).gasStored.getGas(), toSave);
                nbtTags.func_74766_a("cacheGas", stack.write(new NBTTagCompound()));
            }
        }
    }

    public String getType() {
        return "mekanism:pressurized_tube";
    }

    public static void registerIcons(IconRegister register) {
        tubeIcons.registerCenterIcons(register, new String[]{"PressurizedTube"});
        tubeIcons.registerSideIcons(register, new String[]{"TransmitterSideSmall"});
    }

    @Override
    public Icon getCenterIcon() {
        return tubeIcons.getCenterIcon(0);
    }

    @Override
    public Icon getSideIcon() {
        return tubeIcons.getSideIcon(0);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public boolean isValidAcceptor(TileEntity tile, ForgeDirection side) {
        return GasTransmission.canConnect(tile, side);
    }

    @Override
    public GasNetwork createNetworkFromSingleTransmitter(IGridTransmitter<GasNetwork> transmitter) {
        return new GasNetwork(transmitter);
    }

    @Override
    public GasNetwork createNetworkByMergingSet(Set<GasNetwork> networks) {
        return new GasNetwork(networks);
    }

    @Override
    public int getTransmitterNetworkSize() {
        return ((GasNetwork)this.getTransmitterNetwork()).getSize();
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return ((GasNetwork)this.getTransmitterNetwork()).getAcceptorSize();
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return ((GasNetwork)this.getTransmitterNetwork()).getNeeded();
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return ((GasNetwork)this.getTransmitterNetwork()).getFlow();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float f, int pass) {
        if (pass == 1) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    @Override
    public int getCapacity() {
        return 256;
    }
}

