/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.multipart;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import codechicken.lib.vec.Vector3;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.MekanismClient;
import mekanism.client.render.RenderPartTransmitter;
import mekanism.common.EnergyNetwork;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.multipart.PartSidedPipe;
import mekanism.common.multipart.PartTransmitter;
import mekanism.common.multipart.TransmitterIcons;
import mekanism.common.multipart.TransmitterType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class PartUniversalCable
extends PartTransmitter<EnergyNetwork>
implements IStrictEnergyAcceptor,
IEnergySink,
IEnergyHandler,
IPowerReceptor {
    public Tier.CableTier tier;
    public PowerHandler powerHandler;
    public static TransmitterIcons cableIcons = new TransmitterIcons(4, 1);
    public double currentPower = 0.0;
    public double cacheEnergy = 0.0;
    public double lastWrite = 0.0;

    public PartUniversalCable(Tier.CableTier cableTier) {
        this.tier = cableTier;
        this.powerHandler = new PowerHandler(this, PowerHandler.Type.STORAGE);
        this.powerHandler.configurePowerPerdition(0, 0);
        this.powerHandler.configure(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void update() {
        if (this.world().field_72995_K) {
            double targetPower = ((EnergyNetwork)this.getTransmitterNetwork()).clientEnergyScale;
            if (Math.abs(this.currentPower - targetPower) > 0.01) {
                this.currentPower = (9.0 * this.currentPower + targetPower) / 10.0;
            }
        } else {
            double last;
            if (this.getTransmitterNetwork(false) != null && ((EnergyNetwork)this.getTransmitterNetwork(false)).getSize() > 0 && (last = this.lastWrite) != this.getSaveShare()) {
                MekanismUtils.saveChunk((TileEntity)this.tile());
            }
            if (this.cacheEnergy > 0.0) {
                ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored += this.cacheEnergy;
                this.cacheEnergy = 0.0;
            }
        }
        super.update();
    }

    private double getSaveShare() {
        return EnergyNetwork.round(((EnergyNetwork)this.getTransmitterNetwork()).electricityStored * (double)(1.0f / (float)((EnergyNetwork)this.getTransmitterNetwork()).transmitters.size()));
    }

    @Override
    public void refreshTransmitterNetwork() {
        super.refreshTransmitterNetwork();
        this.reconfigure();
    }

    @Override
    public TransmitterType getTransmitter() {
        return this.tier.type;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        super.load(nbtTags);
        this.cacheEnergy = nbtTags.func_74769_h("cacheEnergy");
        this.tier = Tier.CableTier.values()[nbtTags.func_74762_e("tier")];
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        double toSave;
        super.save(nbtTags);
        this.lastWrite = toSave = this.getSaveShare();
        nbtTags.func_74780_a("cacheEnergy", toSave);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
    }

    public String getType() {
        return "mekanism:universal_cable_" + this.tier.name().toLowerCase();
    }

    public static void registerIcons(IconRegister register) {
        cableIcons.registerCenterIcons(register, new String[]{"UniversalCableBasic", "UniversalCableAdvanced", "UniversalCableElite", "UniversalCableUltimate"});
        cableIcons.registerSideIcons(register, new String[]{"TransmitterSideSmall"});
    }

    @Override
    public void preSingleMerge(EnergyNetwork network) {
        network.electricityStored += this.cacheEnergy;
        this.cacheEnergy = 0.0;
    }

    @Override
    public Icon getCenterIcon() {
        return cableIcons.getCenterIcon(this.tier.ordinal());
    }

    @Override
    public Icon getSideIcon() {
        return cableIcons.getSideIcon(0);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.ENERGY;
    }

    @Override
    public EnergyNetwork createNetworkFromSingleTransmitter(IGridTransmitter<EnergyNetwork> transmitter) {
        return new EnergyNetwork(transmitter);
    }

    @Override
    public EnergyNetwork createNetworkByMergingSet(Set<EnergyNetwork> networks) {
        return new EnergyNetwork(networks);
    }

    @Override
    public boolean isValidAcceptor(TileEntity acceptor, ForgeDirection side) {
        return CableUtils.getConnections((TileEntity)this.tile())[side.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 1 && MekanismClient.fancyUniversalCableRender) {
            RenderPartTransmitter.getInstance().renderContents(this, pos);
        }
    }

    public void register() {
        if (!this.world().field_72995_K && !Mekanism.ic2Registered.contains(Coord4D.get((TileEntity)this.tile()))) {
            Mekanism.ic2Registered.add(Coord4D.get((TileEntity)this.tile()));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this.tile()));
        }
    }

    @Override
    public void chunkLoad() {
        this.register();
    }

    @Override
    public void preRemove() {
        if (!this.world().field_72995_K) {
            Mekanism.ic2Registered.remove(Coord4D.get((TileEntity)this.tile()));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.tile()));
        }
        super.preRemove();
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.register();
    }

    @Override
    public void onChunkUnload() {
        if (!this.world().field_72995_K) {
            Mekanism.ic2Registered.remove(Coord4D.get((TileEntity)this.tile()));
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this.tile()));
            ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored -= this.lastWrite;
        }
        super.onChunkUnload();
    }

    @Override
    public int getTransmitterNetworkSize() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getSize();
    }

    @Override
    public int getTransmitterNetworkAcceptorSize() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getAcceptorSize();
    }

    @Override
    public String getTransmitterNetworkNeeded() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getNeeded();
    }

    @Override
    public String getTransmitterNetworkFlow() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getFlow();
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded() * Mekanism.TO_IC2;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection direction, double i) {
        return ((EnergyNetwork)this.getTransmitterNetwork()).emit(i * Mekanism.FROM_IC2) * Mekanism.TO_IC2;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!simulate) {
            return maxReceive - (int)Math.round(((EnergyNetwork)this.getTransmitterNetwork()).emit((double)maxReceive * Mekanism.FROM_TE) * Mekanism.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)Math.round(((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded() * Mekanism.TO_TE);
    }

    @Override
    public int getCapacity() {
        return this.tier.cableCapacity;
    }

    @Override
    public double transferEnergyToAcceptor(ForgeDirection side, double amount) {
        if (!this.canReceiveEnergy(side)) {
            return 0.0;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return toUse;
    }

    @Override
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getConnectionType(side) == PartSidedPipe.ConnectionType.NORMAL || this.getConnectionType(side) == PartSidedPipe.ConnectionType.PULL;
    }

    @Override
    public double getMaxEnergy() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).getCapacity();
    }

    @Override
    public double getEnergy() {
        return ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        ((EnergyNetwork)this.getTransmitterNetwork()).electricityStored = energy;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded() == 0.0) {
            return null;
        }
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public World getWorld() {
        return this.world();
    }

    private void reconfigure() {
        if (MekanismUtils.useBuildCraft()) {
            float needed = (float)(((EnergyNetwork)this.getTransmitterNetwork()).getEnergyNeeded() * Mekanism.TO_BC);
            this.powerHandler.configure(1.0f, needed, 0.0f, needed);
        }
    }

    @Override
    public void doWork(PowerHandler workProvider) {
        if (MekanismUtils.useBuildCraft()) {
            if (this.powerHandler.getEnergyStored() > 0.0f) {
                ((EnergyNetwork)this.getTransmitterNetwork()).emit((double)this.powerHandler.getEnergyStored() * Mekanism.FROM_BC);
            }
            this.powerHandler.setEnergy(0.0f);
            this.reconfigure();
        }
    }
}

