/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.DataOutputStream;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.miner.MinerFilter;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.transporter.TransporterFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketEditFilter
implements IMekanismPacket {
    public Coord4D object3D;
    public TransporterFilter tFilter;
    public TransporterFilter tEdited;
    public MinerFilter mFilter;
    public MinerFilter mEdited;
    public byte type = (byte)-1;
    public boolean delete;

    @Override
    public String getName() {
        return "EditFilter";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.object3D = (Coord4D)data[0];
        this.delete = (Boolean)data[1];
        if (data[2] instanceof TransporterFilter) {
            this.tFilter = (TransporterFilter)data[2];
            if (!this.delete) {
                this.tEdited = (TransporterFilter)data[3];
            }
            this.type = 0;
        } else if (data[2] instanceof MinerFilter) {
            this.mFilter = (MinerFilter)data[2];
            if (!this.delete) {
                this.mEdited = (MinerFilter)data[3];
            }
            this.type = 1;
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        block11: {
            WorldServer worldServer;
            block12: {
                this.object3D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                this.type = dataStream.readByte();
                this.delete = dataStream.readBoolean();
                if (this.type == 0) {
                    this.tFilter = TransporterFilter.readFromPacket(dataStream);
                    if (!this.delete) {
                        this.tEdited = TransporterFilter.readFromPacket(dataStream);
                    }
                } else if (this.type == 1) {
                    this.mFilter = MinerFilter.readFromPacket(dataStream);
                    if (!this.delete) {
                        this.mEdited = MinerFilter.readFromPacket(dataStream);
                    }
                }
                if ((worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.object3D.dimensionId)) == null) break block11;
                if (this.type != 0 || !(this.object3D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityLogisticalSorter)) break block12;
                TileEntityLogisticalSorter sorter = (TileEntityLogisticalSorter)this.object3D.getTileEntity((IBlockAccess)worldServer);
                if (!sorter.filters.contains(this.tFilter)) {
                    return;
                }
                int index = sorter.filters.indexOf(this.tFilter);
                sorter.filters.remove(index);
                if (!this.delete) {
                    sorter.filters.add(index, this.tEdited);
                }
                for (EntityPlayer iterPlayer : sorter.playersUsing) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(sorter), sorter.getFilterPacket(new ArrayList())), iterPlayer);
                }
                break block11;
            }
            if (this.type != 1 || !(this.object3D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityDigitalMiner)) break block11;
            TileEntityDigitalMiner miner = (TileEntityDigitalMiner)this.object3D.getTileEntity((IBlockAccess)worldServer);
            if (!miner.filters.contains(this.mFilter)) {
                return;
            }
            int index = miner.filters.indexOf(this.mFilter);
            miner.filters.remove(index);
            if (!this.delete) {
                miner.filters.add(index, this.mEdited);
            }
            for (EntityPlayer iterPlayer : miner.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(miner), miner.getFilterPacket(new ArrayList())), iterPlayer);
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeInt(this.object3D.dimensionId);
        dataStream.writeByte(this.type);
        dataStream.writeBoolean(this.delete);
        ArrayList data = new ArrayList();
        if (this.type == 0) {
            this.tFilter.write(data);
            if (!this.delete) {
                this.tEdited.write(data);
            }
        } else if (this.type == 1) {
            this.mFilter.write(data);
            if (!this.delete) {
                this.mEdited.write(data);
            }
        }
        PacketHandler.encode(data.toArray(), dataStream);
    }
}

