/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataOutputStream;
import mekanism.api.Coord4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.IElectricChest;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.InventoryElectricChest;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityElectricChest;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PacketElectricChest
implements IMekanismPacket {
    public ElectricChestPacketType activeType;
    public boolean isBlock;
    public boolean locked;
    public String password;
    public int guiType;
    public int windowId;
    public boolean useEnergy;
    public Coord4D obj;

    @Override
    public String getName() {
        return "ElectricChest";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.activeType = (ElectricChestPacketType)((Object)data[0]);
        switch (this.activeType) {
            case LOCK: {
                this.locked = (Boolean)data[1];
                this.isBlock = (Boolean)data[2];
                if (!this.isBlock) break;
                this.obj = (Coord4D)data[3];
                break;
            }
            case PASSWORD: {
                this.password = (String)data[1];
                this.isBlock = (Boolean)data[2];
                if (!this.isBlock) break;
                this.obj = (Coord4D)data[3];
                break;
            }
            case CLIENT_OPEN: {
                this.guiType = (Integer)data[1];
                this.windowId = (Integer)data[2];
                this.isBlock = (Boolean)data[3];
                if (!this.isBlock) break;
                this.obj = (Coord4D)data[4];
                break;
            }
            case SERVER_OPEN: {
                this.useEnergy = (Boolean)data[1];
                this.isBlock = (Boolean)data[2];
                if (!this.isBlock) break;
                this.obj = (Coord4D)data[3];
            }
        }
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        ElectricChestPacketType packetType = ElectricChestPacketType.values()[dataStream.readInt()];
        if (packetType == ElectricChestPacketType.SERVER_OPEN) {
            try {
                boolean energy = dataStream.readBoolean();
                boolean block = dataStream.readBoolean();
                if (block) {
                    int x = dataStream.readInt();
                    int y = dataStream.readInt();
                    int z = dataStream.readInt();
                    TileEntityElectricChest tileEntity = (TileEntityElectricChest)world.func_72796_p(x, y, z);
                    if (energy) {
                        tileEntity.setEnergy(tileEntity.getEnergy() - 100.0);
                    }
                    MekanismUtils.openElectricChestGui((EntityPlayerMP)player, tileEntity, null, true);
                } else {
                    ItemStack stack = player.func_71045_bC();
                    if (stack != null && stack.func_77973_b() instanceof IElectricChest && BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
                        if (energy) {
                            ((IEnergizedItem)stack.func_77973_b()).setEnergy(stack, ((IEnergizedItem)stack.func_77973_b()).getEnergy(stack) - 100.0);
                        }
                        InventoryElectricChest inventory = new InventoryElectricChest(player);
                        MekanismUtils.openElectricChestGui((EntityPlayerMP)player, null, (IInventory)inventory, false);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[Mekanism] Error while handling electric chest open packet.");
                e.printStackTrace();
            }
        } else if (packetType == ElectricChestPacketType.CLIENT_OPEN) {
            try {
                int type = dataStream.readInt();
                int id = dataStream.readInt();
                boolean block = dataStream.readBoolean();
                int x = 0;
                int y = 0;
                int z = 0;
                if (block) {
                    x = dataStream.readInt();
                    y = dataStream.readInt();
                    z = dataStream.readInt();
                }
                Mekanism.proxy.openElectricChest(player, type, id, block, x, y, z);
            }
            catch (Exception e) {
                System.err.println("[Mekanism] Error while handling electric chest open packet.");
                e.printStackTrace();
            }
        } else if (packetType == ElectricChestPacketType.PASSWORD) {
            try {
                String pass = dataStream.readUTF();
                boolean block = dataStream.readBoolean();
                if (block) {
                    int x = dataStream.readInt();
                    int y = dataStream.readInt();
                    int z = dataStream.readInt();
                    TileEntityElectricChest tileEntity = (TileEntityElectricChest)world.func_72796_p(x, y, z);
                    tileEntity.password = pass;
                    tileEntity.authenticated = true;
                } else {
                    ItemStack stack = player.func_71045_bC();
                    if (stack != null && stack.func_77973_b() instanceof IElectricChest && BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
                        ((IElectricChest)stack.func_77973_b()).setPassword(stack, pass);
                        ((IElectricChest)stack.func_77973_b()).setAuthenticated(stack, true);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[Mekanism] Error while handling electric chest password packet.");
                e.printStackTrace();
            }
        } else if (packetType == ElectricChestPacketType.LOCK) {
            try {
                boolean lock = dataStream.readBoolean();
                boolean block = dataStream.readBoolean();
                if (block) {
                    int x = dataStream.readInt();
                    int y = dataStream.readInt();
                    int z = dataStream.readInt();
                    TileEntityElectricChest tileEntity = (TileEntityElectricChest)world.func_72796_p(x, y, z);
                    tileEntity.locked = lock;
                } else {
                    ItemStack stack = player.func_71045_bC();
                    if (stack != null && stack.func_77973_b() instanceof IElectricChest && BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELECTRIC_CHEST) {
                        ((IElectricChest)stack.func_77973_b()).setLocked(stack, lock);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("[Mekanism] Error while handling electric chest password packet.");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.activeType.ordinal());
        switch (this.activeType) {
            case LOCK: {
                dataStream.writeBoolean(this.locked);
                dataStream.writeBoolean(this.isBlock);
                if (!this.isBlock) break;
                dataStream.writeInt(this.obj.xCoord);
                dataStream.writeInt(this.obj.yCoord);
                dataStream.writeInt(this.obj.zCoord);
                break;
            }
            case PASSWORD: {
                dataStream.writeUTF(this.password);
                dataStream.writeBoolean(this.isBlock);
                if (!this.isBlock) break;
                dataStream.writeInt(this.obj.xCoord);
                dataStream.writeInt(this.obj.yCoord);
                dataStream.writeInt(this.obj.zCoord);
                break;
            }
            case CLIENT_OPEN: {
                dataStream.writeInt(this.guiType);
                dataStream.writeInt(this.windowId);
                dataStream.writeBoolean(this.isBlock);
                if (!this.isBlock) break;
                dataStream.writeInt(this.obj.xCoord);
                dataStream.writeInt(this.obj.yCoord);
                dataStream.writeInt(this.obj.zCoord);
                break;
            }
            case SERVER_OPEN: {
                dataStream.writeBoolean(this.useEnergy);
                dataStream.writeBoolean(this.isBlock);
                if (!this.isBlock) break;
                dataStream.writeInt(this.obj.xCoord);
                dataStream.writeInt(this.obj.yCoord);
                dataStream.writeInt(this.obj.zCoord);
            }
        }
    }

    public static enum ElectricChestPacketType {
        LOCK,
        PASSWORD,
        CLIENT_OPEN,
        SERVER_OPEN;

    }
}

