/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataOutputStream;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.tile.TileEntityBasicBlock;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ICrafting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class PacketSimpleGui
implements IMekanismPacket {
    public Coord4D object3D;
    public int guiId;

    @Override
    public String getName() {
        return "SimpleGui";
    }

    @Override
    public IMekanismPacket setParams(Object ... data) {
        this.object3D = (Coord4D)data[0];
        this.guiId = (Integer)data[1];
        return this;
    }

    @Override
    public void read(ByteArrayDataInput dataStream, EntityPlayer player, World world) throws Exception {
        this.object3D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
        this.guiId = dataStream.readInt();
        if (!world.field_72995_K) {
            WorldServer worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.object3D.dimensionId);
            if (worldServer != null && this.object3D.getTileEntity((IBlockAccess)worldServer) instanceof TileEntityBasicBlock) {
                if (this.guiId == -1) {
                    return;
                }
                PacketSimpleGui.openServerGui(this.guiId, (EntityPlayerMP)player, world, this.object3D);
            }
        } else {
            FMLCommonHandler.instance().showGuiScreen((Object)this.getGui(this.guiId, player, world, this.object3D));
        }
    }

    public static void openServerGui(int id, EntityPlayerMP playerMP, World world, Coord4D obj) {
        playerMP.func_71128_l();
        playerMP.func_71117_bO();
        int window = playerMP.field_71139_cq;
        PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketSimpleGui().setParams(obj, id), playerMP);
        playerMP.field_71070_bA = Mekanism.proxy.getServerGui(id, (EntityPlayer)playerMP, world, obj.xCoord, obj.yCoord, obj.zCoord);
        playerMP.field_71070_bA.field_75152_c = window;
        playerMP.field_71070_bA.func_75132_a((ICrafting)playerMP);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(int id, EntityPlayer player, World world, Coord4D obj) {
        return (GuiScreen)Mekanism.proxy.getClientGui(id, player, world, obj.xCoord, obj.yCoord, obj.zCoord);
    }

    @Override
    public void write(DataOutputStream dataStream) throws Exception {
        dataStream.writeInt(this.object3D.xCoord);
        dataStream.writeInt(this.object3D.yCoord);
        dataStream.writeInt(this.object3D.zCoord);
        dataStream.writeInt(this.object3D.dimensionId);
        dataStream.writeInt(this.guiId);
    }
}

