/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import ic2.api.tile.IWrenchable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.common.ITileComponent;
import mekanism.common.ITileNetwork;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityBasicBlock
extends TileEntity
implements IWrenchable,
ITileNetwork {
    public int facing;
    public int clientFacing;
    public Set<EntityPlayer> openedThisTick = new HashSet<EntityPlayer>();
    public Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int ticker;
    public boolean redstone = false;
    public boolean doAutoSync = true;
    public List<ITileComponent> components = new ArrayList<ITileComponent>();

    public void func_70316_g() {
        for (ITileComponent component : this.components) {
            component.tick();
        }
        this.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            this.openedThisTick.clear();
            if (this.doAutoSync && this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), player);
                }
            }
        }
        ++this.ticker;
    }

    public void open(EntityPlayer player) {
        this.playersUsing.add(player);
    }

    public void close(EntityPlayer player) {
        this.playersUsing.remove(player);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        this.facing = dataStream.readInt();
        this.redstone = dataStream.readBoolean();
        if (this.clientFacing != this.facing) {
            MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            this.clientFacing = this.facing;
        }
        for (ITileComponent component : this.components) {
            component.read(dataStream);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.facing);
        data.add(this.redstone);
        for (ITileComponent component : this.components) {
            component.write(data);
        }
        return data;
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDataRequest().setParams(Coord4D.get(this)), new Object[0]);
        }
    }

    public abstract void onUpdate();

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.facing = nbtTags.func_74762_e("facing");
        this.redstone = nbtTags.func_74767_n("redstone");
        for (ITileComponent component : this.components) {
            component.read(nbtTags);
        }
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("facing", this.facing);
        nbtTags.func_74757_a("redstone", this.redstone);
        for (ITileComponent component : this.components) {
            component.write(nbtTags);
        }
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return true;
    }

    @Override
    public short getFacing() {
        return (short)this.facing;
    }

    @Override
    public void setFacing(short direction) {
        if (this.canSetFacing(direction)) {
            this.facing = direction;
        }
        if (this.facing != this.clientFacing) {
            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_DIM, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), this.field_70331_k.field_73011_w.field_76574_g);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            this.clientFacing = this.facing;
        }
    }

    public boolean canSetFacing(int facing) {
        return true;
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return this.func_70311_o().getPickBlock(null, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isPowered() {
        return this.redstone;
    }

    public void onNeighborChange(int id) {
        boolean power;
        if (!this.field_70331_k.field_72995_K && this.redstone != (power = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n))) {
            this.redstone = power;
            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_DIM, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), this.field_70331_k.field_73011_w.field_76574_g);
        }
    }
}

