/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.IActiveState;
import mekanism.common.IConfigurable;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemBlockBasic;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileEntityBin
extends TileEntityBasicBlock
implements ISidedInventory,
IActiveState,
IDeepStorageUnit,
IConfigurable {
    public boolean isActive;
    public boolean clientActive;
    public final int MAX_DELAY = 10;
    public int addTicks = 0;
    public int delayTicks;
    public int cacheCount;
    public final int MAX_STORAGE = 4096;
    public ItemStack itemType;
    public ItemStack topStack;
    public ItemStack bottomStack;
    public int prevCount;
    public int clientAmount;

    public void sortStacks() {
        if (this.getItemCount() == 0 || this.itemType == null) {
            this.itemType = null;
            this.topStack = null;
            this.bottomStack = null;
            this.cacheCount = 0;
            return;
        }
        int count = this.getItemCount();
        int remain = 4096 - count;
        if (remain >= this.itemType.func_77976_d()) {
            this.topStack = null;
        } else {
            this.topStack = this.itemType.func_77946_l();
            this.topStack.field_77994_a = this.itemType.func_77976_d() - remain;
        }
        this.bottomStack = this.itemType.func_77946_l();
        this.bottomStack.field_77994_a = Math.min(this.itemType.func_77976_d(), count -= StackUtils.getSize(this.topStack));
        this.cacheCount = count -= StackUtils.getSize(this.bottomStack);
    }

    public boolean isValid(ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return false;
        }
        if (stack.func_77984_f() && stack.func_77951_h()) {
            return false;
        }
        if (stack.func_77973_b() instanceof ItemBlockBasic && stack.func_77960_j() == 6) {
            return false;
        }
        if (this.itemType == null) {
            return true;
        }
        return stack.func_77969_a(this.itemType) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.itemType);
    }

    public ItemStack add(ItemStack stack) {
        if (this.isValid(stack) && this.getItemCount() != 4096) {
            if (this.itemType == null) {
                this.setItemType(stack);
            }
            if (this.getItemCount() + stack.field_77994_a <= 4096) {
                this.setItemCount(this.getItemCount() + stack.field_77994_a);
                return null;
            }
            ItemStack rejects = this.itemType.func_77946_l();
            rejects.field_77994_a = this.getItemCount() + stack.field_77994_a - 4096;
            this.setItemCount(4096);
            return rejects;
        }
        return stack;
    }

    public ItemStack removeStack() {
        if (this.getItemCount() == 0) {
            return null;
        }
        return this.remove(this.bottomStack.field_77994_a);
    }

    public ItemStack remove(int amount) {
        if (this.getItemCount() == 0) {
            return null;
        }
        ItemStack ret = this.itemType.func_77946_l();
        ret.field_77994_a = Math.min(Math.min(amount, this.itemType.func_77976_d()), this.getItemCount());
        this.setItemCount(this.getItemCount() - ret.field_77994_a);
        return ret;
    }

    public int getItemCount() {
        return StackUtils.getSize(this.bottomStack) + this.cacheCount + StackUtils.getSize(this.topStack);
    }

    @Override
    public void onUpdate() {
        if (!this.field_70331_k.field_72995_K) {
            this.addTicks = Math.max(0, this.addTicks - 1);
            this.delayTicks = Math.max(0, this.delayTicks - 1);
            this.sortStacks();
            if (this.getItemCount() != this.prevCount) {
                this.func_70296_d();
                MekanismUtils.saveChunk(this);
            }
            if (this.delayTicks == 0) {
                if (this.bottomStack != null && this.isActive) {
                    TileEntity tile = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)0)).getTileEntity((IBlockAccess)this.field_70331_k);
                    if (tile instanceof ILogisticalTransporter) {
                        ILogisticalTransporter transporter = (ILogisticalTransporter)tile;
                        ItemStack rejects = TransporterUtils.insert(this, transporter, this.bottomStack, null, true, 0);
                        if (TransporterManager.didEmit(this.bottomStack, rejects)) {
                            this.func_70299_a(0, rejects);
                        }
                    } else if (tile instanceof IInventory) {
                        this.func_70299_a(0, InventoryUtils.putStackInInventory((IInventory)tile, this.bottomStack, 0, false));
                    }
                    this.delayTicks = 10;
                }
            } else {
                --this.delayTicks;
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("itemCount", this.cacheCount);
        if (this.bottomStack != null) {
            nbtTags.func_74766_a("bottomStack", this.bottomStack.func_77955_b(new NBTTagCompound()));
        }
        if (this.topStack != null) {
            nbtTags.func_74766_a("topStack", this.topStack.func_77955_b(new NBTTagCompound()));
        }
        if (this.getItemCount() > 0) {
            nbtTags.func_74766_a("itemType", this.itemType.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.cacheCount = nbtTags.func_74762_e("itemCount");
        this.bottomStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("bottomStack"));
        this.topStack = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("topStack"));
        if (this.getItemCount() > 0) {
            this.itemType = ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("itemType"));
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.getItemCount());
        if (this.getItemCount() > 0) {
            data.add(this.itemType.field_77993_c);
            data.add(this.itemType.func_77960_j());
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.clientAmount = dataStream.readInt();
        this.itemType = this.clientAmount > 0 ? new ItemStack(dataStream.readInt(), 1, dataStream.readInt()) : null;
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public ItemStack func_70301_a(int slotID) {
        if (slotID == 1) {
            return this.topStack;
        }
        return this.bottomStack;
    }

    public ItemStack func_70298_a(int slotID, int amount) {
        int toRemove;
        if (slotID == 1) {
            return null;
        }
        if (slotID == 0 && (toRemove = Math.min(this.getItemCount(), amount)) > 0) {
            ItemStack ret = this.itemType.func_77946_l();
            ret.field_77994_a = toRemove;
            this.setItemCount(this.getItemCount() - toRemove);
            return ret;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotID) {
        return this.func_70301_a(slotID);
    }

    public int func_70302_i_() {
        return 2;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            if (this.getItemCount() == 0) {
                return;
            }
            if (itemstack == null) {
                this.setItemCount(this.getItemCount() - this.bottomStack.field_77994_a);
            } else {
                this.setItemCount(this.getItemCount() - (this.bottomStack.field_77994_a - itemstack.field_77994_a));
            }
        } else if (i == 1 && this.isValid(itemstack)) {
            this.add(itemstack);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_70331_k.field_72995_K) {
            MekanismUtils.saveChunk(this);
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.prevCount = this.getItemCount();
            this.sortStacks();
        }
    }

    public void setItemType(ItemStack stack) {
        if (stack == null) {
            this.itemType = null;
            this.cacheCount = 0;
            this.topStack = null;
            this.bottomStack = null;
            return;
        }
        ItemStack ret = stack.func_77946_l();
        ret.field_77994_a = 1;
        this.itemType = ret;
    }

    public void setItemCount(int count) {
        this.cacheCount = Math.max(0, count);
        this.topStack = null;
        this.bottomStack = null;
        if (count == 0) {
            this.setItemType(null);
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return MekanismUtils.localize("tile.BasicBlock.Bin.name");
    }

    public boolean func_94042_c() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 1 ? this.isValid(itemstack) : false;
    }

    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{1};
        }
        if (side == 0) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 0 ? this.isValid(itemstack) : false;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public ItemStack getStoredItemType() {
        if (this.itemType == null) {
            return null;
        }
        return MekanismUtils.size(this.itemType, this.getItemCount());
    }

    @Override
    public void setStoredItemCount(int amount) {
        if (amount == 0) {
            this.setStoredItemType(null, 0);
        }
        this.setItemCount(amount);
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        this.itemType = type;
        this.cacheCount = amount;
        this.topStack = null;
        this.bottomStack = null;
        this.func_70296_d();
    }

    @Override
    public int getMaxStoredCount() {
        return 4096;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        this.setActive(!this.getActive());
        this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "random.click", 0.3f, 1.0f);
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }
}

