/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.common.ITileNetwork;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityBoundingBlock
extends TileEntity
implements ITileNetwork {
    public int mainX;
    public int mainY;
    public int mainZ;
    public boolean prevPower;

    public void setMainLocation(int x, int y, int z) {
        if (!this.field_70331_k.field_72995_K) {
            this.mainX = x;
            this.mainY = y;
            this.mainZ = z;
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
        }
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacket(PacketHandler.Transmission.SERVER, new PacketDataRequest().setParams(Coord4D.get(this)), new Object[0]);
        }
    }

    public boolean canUpdate() {
        return false;
    }

    public void onNeighborChange(int id) {
        TileEntity tile = this.field_70331_k.func_72796_p(this.mainX, this.mainY, this.mainZ);
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)tile;
            boolean power = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (this.prevPower != power) {
                if (power) {
                    this.onPower();
                } else {
                    this.onNoPower();
                }
                this.prevPower = power;
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_DIM, new PacketTileEntity().setParams(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), tileEntity.field_70331_k.field_73011_w.field_76574_g);
            }
        }
    }

    public void onPower() {
    }

    public void onNoPower() {
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        this.mainX = dataStream.readInt();
        this.mainY = dataStream.readInt();
        this.mainZ = dataStream.readInt();
        this.prevPower = dataStream.readBoolean();
    }

    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.mainX = nbtTags.func_74762_e("mainX");
        this.mainY = nbtTags.func_74762_e("mainY");
        this.mainZ = nbtTags.func_74762_e("mainZ");
        this.prevPower = nbtTags.func_74767_n("prevPower");
    }

    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("mainX", this.mainX);
        nbtTags.func_74768_a("mainY", this.mainY);
        nbtTags.func_74768_a("mainZ", this.mainZ);
        nbtTags.func_74757_a("prevPower", this.prevPower);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        data.add(this.mainX);
        data.add(this.mainY);
        data.add(this.mainZ);
        data.add(this.prevPower);
        return data;
    }
}

