/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.ILuaContext;
import java.util.Map;
import mekanism.api.ChanceOutput;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TileEntityChanceMachine
extends TileEntityBasicMachine {
    public TileEntityChanceMachine(String soundPath, String name, ResourceLocation location, double perTick, int ticksRequired, double maxEnergy) {
        super(soundPath, name, location, perTick, ticksRequired, maxEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, InventoryUtils.EMPTY));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, new int[]{0}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, new int[]{1}));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, new int[]{2, 4}));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, new int[]{3}));
        this.sideConfig = new byte[]{2, 1, 0, 0, 4, 3};
        this.inventory = new ItemStack[5];
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.ejectorComponent = new TileComponentEjector(this, (SideData)this.sideOutputs.get(3));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            ChargeUtils.discharge(1, this);
            if (this.canOperate() && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK)) {
                this.setActive(true);
                if (this.operatingTicks + 1 < MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED)) {
                    ++this.operatingTicks;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK);
                } else if (this.operatingTicks + 1 >= MekanismUtils.getTicks(this.getSpeedMultiplier(new Object[0]), this.TICKS_REQUIRED)) {
                    this.operate();
                    this.operatingTicks = 0;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this.getSpeedMultiplier(new Object[0]), this.getEnergyMultiplier(new Object[0]), this.ENERGY_PER_TICK);
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate()) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 3) {
            return itemstack.field_77993_c == Mekanism.SpeedUpgrade.field_77779_bT || itemstack.field_77993_c == Mekanism.EnergyUpgrade.field_77779_bT;
        }
        if (slotID == 0) {
            return RecipeHandler.isInRecipe(itemstack, this.getRecipes());
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public void operate() {
        ChanceOutput output = RecipeHandler.getChanceOutput(this.inventory[0], true, this.getRecipes());
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (output.hasPrimary()) {
            if (this.inventory[2] == null) {
                this.inventory[2] = output.primaryOutput;
            } else {
                this.inventory[2].field_77994_a += output.primaryOutput.field_77994_a;
            }
        }
        if (output.hasSecondary() && output.checkSecondary()) {
            if (this.inventory[4] == null) {
                this.inventory[4] = output.secondaryOutput;
            } else {
                this.inventory[4].field_77994_a += output.secondaryOutput.field_77994_a;
            }
        }
        this.func_70296_d();
        this.ejectorComponent.onOutput();
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ChanceOutput output = RecipeHandler.getChanceOutput(this.inventory[0], false, this.getRecipes());
        if (output == null) {
            return false;
        }
        if (output.hasPrimary() && this.inventory[2] != null) {
            if (!this.inventory[2].func_77969_a(output.primaryOutput)) {
                return false;
            }
            if (this.inventory[2].field_77994_a + output.primaryOutput.field_77994_a > this.inventory[2].func_77976_d()) {
                return false;
            }
        }
        if (output.hasSecondary() && this.inventory[4] != null) {
            if (!this.inventory[4].func_77969_a(output.secondaryOutput)) {
                return false;
            }
            if (this.inventory[4].field_77994_a + output.secondaryOutput.field_77994_a > this.inventory[4].func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2 || slotID == 4;
    }

    @Override
    public Map getRecipes() {
        return null;
    }

    @Override
    public String[] getMethodNames() {
        return null;
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        return null;
    }
}

