/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityChemicalDissolutionChamber
extends TileEntityElectricBlock
implements IActiveState,
ITubeConnection,
IRedstoneControl,
IHasSound,
IGasHandler {
    public GasTank injectTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public static final int INJECT_USAGE = 1;
    public int updateDelay;
    public int gasOutput = 16;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public int operatingTicks = 0;
    public int TICKS_REQUIRED = 100;
    public final double ENERGY_USAGE = Mekanism.chemicalDissolutionChamberUsage;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalDissolutionChamber() {
        super("ChemicalDissolutionChamber", BlockMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.baseEnergy);
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && (this.injectTank.getGas() == null || this.injectTank.getStored() < this.injectTank.getMaxGas())) {
                this.injectTank.receive(GasTransmission.removeGas(this.inventory[0], GasRegistry.getGas("sulfuricAcid"), this.injectTank.getNeeded()), true);
            }
            if (this.inventory[2] != null && this.outputTank.getGas() != null) {
                this.outputTank.draw(GasTransmission.addGas(this.inventory[2], this.outputTank.getGas()), true);
            }
            boolean changed = false;
            if (this.canOperate() && this.getEnergy() >= this.ENERGY_USAGE && this.injectTank.getStored() >= 1 && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
                if (this.operatingTicks < this.TICKS_REQUIRED) {
                    ++this.operatingTicks;
                    this.injectTank.draw(1, true);
                } else {
                    GasStack stack = RecipeHandler.getItemToGasOutput(this.inventory[1], true, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get());
                    this.outputTank.receive(stack, true);
                    this.injectTank.draw(1, true);
                    this.operatingTicks = 0;
                    if (this.inventory[1].field_77994_a <= 0) {
                        this.inventory[1] = null;
                    }
                    this.func_70296_d();
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                changed = true;
                this.setActive(false);
            }
            if (changed && !this.canOperate()) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.outputTank.getGas() != null) {
                GasStack toSend = new GasStack(this.outputTank.getGas().getGas(), Math.min(this.outputTank.getStored(), this.gasOutput));
                this.outputTank.draw(GasTransmission.emitGasToNetwork(toSend, this, MekanismUtils.getRight(this.facing)), true);
                TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getRight(this.facing).getOpposite(), this.outputTank.getGas().getGas())) {
                    this.outputTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getRight(this.facing).getOpposite(), toSend), true);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return RecipeHandler.getItemToGasOutput(itemstack, false, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get()) != null;
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal() || side == 1) {
            return new int[]{1};
        }
        if (side == 0) {
            return new int[]{0};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{2};
        }
        return InventoryUtils.EMPTY;
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / this.TICKS_REQUIRED;
    }

    public boolean canOperate() {
        if (this.inventory[1] == null) {
            return false;
        }
        GasStack stack = RecipeHandler.getItemToGasOutput(this.inventory[1], false, RecipeHandler.Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get());
        return stack != null && (this.outputTank.getGas() == null || this.outputTank.getGas().getGas() == stack.getGas() && this.outputTank.getNeeded() >= stack.amount);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        this.operatingTicks = dataStream.readInt();
        if (dataStream.readBoolean()) {
            this.injectTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.injectTank.setGas(null);
        }
        if (dataStream.readBoolean()) {
            this.outputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.outputTank.setGas(null);
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.operatingTicks);
        if (this.injectTank.getGas() != null) {
            data.add(true);
            data.add(this.injectTank.getGas().getGas().getID());
            data.add(this.injectTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputTank.getGas() != null) {
            data.add(true);
            data.add(this.outputTank.getGas().getGas().getID());
            data.add(this.outputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.injectTank.read(nbtTags.func_74775_l("injectTank"));
        this.outputTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74766_a("injectTank", this.injectTank.write(new NBTTagCompound()));
        nbtTags.func_74766_a("gasTank", this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public int getScaledInjectGasLevel(int i) {
        return this.injectTank.getGas() != null ? this.injectTank.getStored() * i / 10000 : 0;
    }

    public int getScaledOutputGasLevel(int i) {
        return this.outputTank.getGas() != null ? this.outputTank.getStored() * i / 10000 : 0;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public String getSoundPath() {
        return "ChemicalDissolutionChamber.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.injectTank.receive(stack, true);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return side == MekanismUtils.getLeft(this.facing) && type == GasRegistry.getGas("sulfuricAcid");
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }
}

