/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityAdvancedElectricMachine;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityChemicalInjectionChamber
extends TileEntityAdvancedElectricMachine
implements IGasHandler,
ITubeConnection {
    public TileEntityChemicalInjectionChamber() {
        super("ChemicalInjectionChamber.ogg", "ChemicalInjectionChamber", new ResourceLocation("mekanism", "gui/GuiChemicalInjectionChamber.png"), Mekanism.chemicalInjectionChamberUsage, 1, 200, BlockMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.baseEnergy);
    }

    @Override
    public Map getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get();
    }

    @Override
    public GasStack getItemGas(ItemStack itemstack) {
        if (MekanismUtils.getOreDictName(itemstack).contains("dustSulfur")) {
            return new GasStack(GasRegistry.getGas("sulfuricAcid"), 2);
        }
        if (itemstack.field_77993_c == Mekanism.GasTank.field_71990_ca && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && this.isValidGas(((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas())) {
            return new GasStack(GasRegistry.getGas("sulfuricAcid"), 1);
        }
        return null;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (this.isValidGas(stack.getGas())) {
            return this.gasTank.receive(stack, true);
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.isValidGas(type);
    }

    @Override
    public void handleSecondaryFuel() {
        if (this.inventory[1] != null && this.gasTank.getNeeded() > 0 && this.inventory[1].func_77973_b() instanceof IGasItem) {
            GasStack gas = ((IGasItem)this.inventory[1].func_77973_b()).getGas(this.inventory[1]);
            if (gas != null && this.isValidGas(gas.getGas())) {
                GasStack removed = GasTransmission.removeGas(this.inventory[1], this.gasTank.getGas() != null ? this.gasTank.getGas().getGas() : null, this.gasTank.getNeeded());
                this.gasTank.receive(removed, true);
            }
            return;
        }
        super.handleSecondaryFuel();
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isValidGas(Gas gas) {
        return gas == GasRegistry.getGas("sulfuricAcid") || gas == GasRegistry.getGas("water") || gas == GasRegistry.getGas("hydrogenChloride");
    }
}

