/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityChemicalWasher
extends TileEntityElectricBlock
implements IActiveState,
IGasHandler,
ITubeConnection,
IRedstoneControl,
IHasSound,
IFluidHandler {
    public FluidTank fluidTank = new FluidTank(10000);
    public GasTank inputTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public static final int MAX_FLUID = 10000;
    public static int WATER_USAGE = 5;
    public int updateDelay;
    public int gasOutput = 16;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double ENERGY_USAGE = Mekanism.chemicalWasherUsage;
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalWasher() {
        super("ChemicalWasher", BlockMachine.MachineType.CHEMICAL_WASHER.baseEnergy);
        this.inventory = new ItemStack[4];
    }

    @Override
    public void onUpdate() {
        if (this.field_70331_k.field_72995_K) {
            Mekanism.proxy.registerSound(this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                }
            }
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
                }
            }
            ChargeUtils.discharge(3, this);
            this.manageBuckets();
            if (this.inventory[2] != null && this.outputTank.getGas() != null) {
                this.outputTank.draw(GasTransmission.addGas(this.inventory[2], this.outputTank.getGas()), true);
            }
            if (this.canOperate() && this.getEnergy() >= this.ENERGY_USAGE && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                GasStack stack = RecipeHandler.getChemicalWasherOutput(this.inputTank, true);
                this.outputTank.receive(stack, true);
                this.fluidTank.drain(WATER_USAGE, true);
                this.setEnergy(this.getEnergy() - this.ENERGY_USAGE);
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.outputTank.getGas() != null) {
                GasStack toSend = new GasStack(this.outputTank.getGas().getGas(), Math.min(this.outputTank.getStored(), this.gasOutput));
                this.outputTank.draw(GasTransmission.emitGasToNetwork(toSend, this, MekanismUtils.getRight(this.facing)), true);
                TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getRight(this.facing).getOpposite(), this.outputTank.getGas().getGas())) {
                    this.outputTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getRight(this.facing).getOpposite(), toSend), true);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public boolean canOperate() {
        if (this.fluidTank.getFluidAmount() < WATER_USAGE || this.inputTank.getGas() == null || this.outputTank.getNeeded() == 0) {
            return false;
        }
        GasStack out = RecipeHandler.getChemicalWasherOutput(this.inputTank, false);
        if (out == null || this.outputTank.getGas() != null && this.outputTank.getGas().getGas() != out.getGas()) {
            return false;
        }
        return this.outputTank.getNeeded() >= out.amount;
    }

    private void manageBuckets() {
        if (FluidContainerRegistry.isFilledContainer((ItemStack)this.inventory[0])) {
            FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0]);
            if (this.fluidTank.getFluid() == null && itemFluid.amount <= 10000 || this.fluidTank.getFluid().amount + itemFluid.amount <= 10000) {
                if (itemFluid.getFluid() != FluidRegistry.WATER || this.fluidTank.getFluid() != null && !this.fluidTank.getFluid().isFluidEqual(itemFluid)) {
                    return;
                }
                ItemStack containerItem = this.inventory[0].func_77973_b().getContainerItemStack(this.inventory[0]);
                boolean filled = false;
                if (containerItem != null) {
                    if (this.inventory[1] == null || this.inventory[1].func_77969_a(containerItem) && this.inventory[1].field_77994_a + 1 <= containerItem.func_77976_d()) {
                        this.inventory[0] = null;
                        if (this.inventory[1] == null) {
                            this.inventory[1] = containerItem;
                        } else {
                            ++this.inventory[1].field_77994_a;
                        }
                        filled = true;
                    }
                } else {
                    --this.inventory[0].field_77994_a;
                    if (this.inventory[0].field_77994_a == 0) {
                        this.inventory[0] = null;
                    }
                    filled = true;
                }
                if (filled) {
                    this.fluidTank.fill(itemFluid, true);
                }
            }
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.inputTank.setGas(null);
            }
            for (EntityPlayer player : this.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.isActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (dataStream.readBoolean()) {
            this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
        } else {
            this.fluidTank.setFluid(null);
        }
        if (dataStream.readBoolean()) {
            this.inputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.inputTank.setGas(null);
        }
        if (dataStream.readBoolean()) {
            this.outputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.outputTank.setGas(null);
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.fluidTank.getFluid() != null) {
            data.add(true);
            data.add(this.fluidTank.getFluid().getFluid().getID());
            data.add(this.fluidTank.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.inputTank.getGas() != null) {
            data.add(true);
            data.add(this.inputTank.getGas().getGas().getID());
            data.add(this.inputTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputTank.getGas() != null) {
            data.add(true);
            data.add(this.outputTank.getGas().getGas().getID());
            data.add(this.outputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.fluidTank.readFromNBT(nbtTags.func_74775_l("leftTank"));
        this.inputTank.read(nbtTags.func_74775_l("rightTank"));
        this.outputTank.read(nbtTags.func_74775_l("centerTank"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74766_a("leftTank", this.fluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74766_a("rightTank", this.inputTank.write(new NBTTagCompound()));
        nbtTags.func_74766_a("centerTank", this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public GasTank getTank(ForgeDirection side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.inputTank;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.outputTank;
        }
        return null;
    }

    public int getScaledFluidLevel(int i) {
        return this.fluidTank != null ? this.fluidTank.getFluidAmount() * i / 10000 : 0;
    }

    public int getScaledInputGasLevel(int i) {
        return this.inputTank != null ? this.inputTank.getStored() * i / 10000 : 0;
    }

    public int getScaledOutputGasLevel(int i) {
        return this.outputTank != null ? this.outputTank.getStored() * i / 10000 : 0;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) != this.outputTank ? this.getTank(side).canReceive(type) : false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.getTank(side).receive(stack, true);
        }
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        if (this.canDrawGas(side, null)) {
            return this.getTank(side).draw(amount, true);
        }
        return null;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.getTank(side) == this.outputTank ? this.getTank(side).canDraw(type) : false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack) != null && FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack).getFluid() == FluidRegistry.WATER;
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal()) {
            return new int[]{0};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{1};
        }
        if (side == 0 || side == 1) {
            return new int[2];
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public String getSoundPath() {
        return "ChemicalWasher.ogg";
    }

    @Override
    public float getVolumeMultiplier() {
        return 1.0f;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.fluidTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && fluid == FluidRegistry.WATER;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (from == ForgeDirection.UP) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }
}

