/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.IConfigurable;
import mekanism.common.ISustainedTank;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityElectricPump
extends TileEntityElectricBlock
implements IFluidHandler,
ISustainedTank,
IConfigurable {
    public FluidTank fluidTank;
    public Set<Coord4D> recurringNodes = new HashSet<Coord4D>();
    public Set<Coord4D> cleaningNodes = new HashSet<Coord4D>();

    public TileEntityElectricPump() {
        super("ElectricPump", 10000.0);
        this.fluidTank = new FluidTank(10000);
        this.inventory = new ItemStack[3];
    }

    @Override
    public void onUpdate() {
        ItemStack tempStack;
        ChargeUtils.discharge(2, this);
        if (this.inventory[0] != null && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().amount >= 1000 && FluidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[0]) && (tempStack = FluidContainerRegistry.fillFluidContainer((FluidStack)this.fluidTank.getFluid(), (ItemStack)this.inventory[0])) != null) {
            if (this.inventory[1] == null) {
                this.fluidTank.drain(1000, true);
                this.inventory[1] = tempStack;
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                this.func_70296_d();
            } else if (tempStack.func_77969_a(this.inventory[1]) && tempStack.func_77976_d() > this.inventory[1].field_77994_a) {
                this.fluidTank.drain(1000, true);
                ++this.inventory[1].field_77994_a;
                --this.inventory[0].field_77994_a;
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                this.func_70296_d();
            }
        }
        if (!this.field_70331_k.field_72995_K && this.field_70331_k.func_72820_D() % 20L == 0L && this.getEnergy() >= 100.0 && (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount + 1000 <= 10000)) {
            if (this.suck(true)) {
                PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), Coord4D.get(this), 50.0);
            }
            this.clean(true);
        }
        super.onUpdate();
        if (this.fluidTank.getFluid() != null) {
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = Coord4D.get(this).getFromSide(orientation).getTileEntity((IBlockAccess)this.field_70331_k);
                if (!(tileEntity instanceof IFluidHandler)) continue;
                FluidStack toDrain = new FluidStack(this.fluidTank.getFluid(), Math.min(100, this.fluidTank.getFluidAmount()));
                this.fluidTank.drain(((IFluidHandler)tileEntity).fill(orientation.getOpposite(), toDrain, true), true);
                if (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().amount <= 0) break;
            }
        }
    }

    public boolean suck(boolean take) {
        List<Coord4D> tempPumpList = Arrays.asList(this.recurringNodes.toArray(new Coord4D[this.recurringNodes.size()]));
        Collections.shuffle(tempPumpList);
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            Coord4D wrapper = Coord4D.get(this).getFromSide(orientation);
            if (!MekanismUtils.isFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.fluidTank.getFluid() != null && !MekanismUtils.getFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord).isFluidEqual(this.fluidTank.getFluid())) continue;
            if (take) {
                this.setEnergy(this.getEnergy() - 100.0);
                this.recurringNodes.add(wrapper.clone());
                this.fluidTank.fill(MekanismUtils.getFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord), true);
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            return true;
        }
        for (Coord4D wrapper : this.cleaningNodes) {
            if (!MekanismUtils.isFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.fluidTank.getFluid() == null || !MekanismUtils.getFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord).isFluidEqual(this.fluidTank.getFluid())) continue;
            if (take) {
                this.setEnergy(this.getEnergy() - 100.0);
                this.fluidTank.fill(MekanismUtils.getFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord), true);
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            return true;
        }
        for (Coord4D wrapper : tempPumpList) {
            if (MekanismUtils.isFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) && (this.fluidTank.getFluid() == null || MekanismUtils.getFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord).isFluidEqual(this.fluidTank.getFluid()))) {
                if (take) {
                    this.setEnergy(this.electricityStored - 100.0);
                    this.fluidTank.fill(MekanismUtils.getFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord), true);
                    this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
                }
                return true;
            }
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D side = wrapper.getFromSide(orientation);
                if (Coord4D.get(this).distanceTo(side) > 80 || !MekanismUtils.isFluid(this.field_70331_k, side.xCoord, side.yCoord, side.zCoord) || this.fluidTank.getFluid() != null && !MekanismUtils.getFluid(this.field_70331_k, side.xCoord, side.yCoord, side.zCoord).isFluidEqual(this.fluidTank.getFluid())) continue;
                if (take) {
                    this.setEnergy(this.electricityStored - 100.0);
                    this.recurringNodes.add(side);
                    this.fluidTank.fill(MekanismUtils.getFluid(this.field_70331_k, side.xCoord, side.yCoord, side.zCoord), true);
                    this.field_70331_k.func_94571_i(side.xCoord, side.yCoord, side.zCoord);
                }
                return true;
            }
            this.cleaningNodes.add(wrapper);
            this.recurringNodes.remove(wrapper);
        }
        return false;
    }

    public boolean clean(boolean take) {
        boolean took = false;
        if (!this.field_70331_k.field_72995_K) {
            for (Coord4D wrapper : this.cleaningNodes) {
                if (!MekanismUtils.isDeadFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.fluidTank.getFluid() == null || MekanismUtils.getFluidId(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) != this.fluidTank.getFluid().fluidID) continue;
                took = true;
                if (!take) continue;
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            for (Coord4D wrapper : this.recurringNodes) {
                if (!MekanismUtils.isDeadFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.fluidTank.getFluid() == null || MekanismUtils.getFluidId(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) != this.fluidTank.getFluid().fluidID) continue;
                took = true;
                if (!take) continue;
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
            for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
                Coord4D wrapper = Coord4D.get(this).getFromSide(orientation);
                if (!MekanismUtils.isDeadFluid(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) || this.fluidTank.getFluid() == null || MekanismUtils.getFluidId(this.field_70331_k, wrapper.xCoord, wrapper.yCoord, wrapper.zCoord) != this.fluidTank.getFluid().fluidID) continue;
                took = true;
                if (!take) continue;
                this.field_70331_k.func_94571_i(wrapper.xCoord, wrapper.yCoord, wrapper.zCoord);
            }
        }
        return took;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        if (dataStream.readInt() == 1) {
            this.fluidTank.setFluid(new FluidStack(dataStream.readInt(), dataStream.readInt()));
        } else {
            this.fluidTank.setFluid(null);
        }
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.fluidTank.getFluid() != null) {
            data.add(1);
            data.add(this.fluidTank.getFluid().fluidID);
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    public int getScaledFluidLevel(int i) {
        return this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount * i / 10000 : 0;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        NBTTagList recurringList = new NBTTagList();
        for (Coord4D wrapper : this.recurringNodes) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            wrapper.write(tagCompound);
            recurringList.func_74742_a((NBTBase)tagCompound);
        }
        if (recurringList.func_74745_c() != 0) {
            nbtTags.func_74782_a("recurringNodes", (NBTBase)recurringList);
        }
        NBTTagList cleaningList = new NBTTagList();
        for (Coord4D obj : this.cleaningNodes) {
            cleaningList.func_74742_a((NBTBase)obj.write(new NBTTagCompound()));
        }
        if (cleaningList.func_74745_c() != 0) {
            nbtTags.func_74782_a("cleaningNodes", (NBTBase)cleaningList);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        int i;
        NBTTagList tagList;
        super.func_70307_a(nbtTags);
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        if (nbtTags.func_74764_b("recurringNodes")) {
            tagList = nbtTags.func_74761_m("recurringNodes");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.recurringNodes.add(Coord4D.read((NBTTagCompound)tagList.func_74743_b(i)));
            }
        }
        if (nbtTags.func_74764_b("cleaningNodes")) {
            tagList = nbtTags.func_74761_m("cleaningNodes");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                this.cleaningNodes.add(Coord4D.read((NBTTagCompound)tagList.func_74743_b(i)));
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return false;
        }
        if (slotID == 0) {
            return FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack);
        }
        if (slotID == 2) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 1;
    }

    @Override
    protected EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing).getOpposite());
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 1) {
            return new int[]{0};
        }
        if (side == 0) {
            return new int[]{1};
        }
        return new int[]{2};
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        if (direction == ForgeDirection.getOrientation((int)1)) {
            return new FluidTankInfo[]{this.fluidTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == resource.getFluid() && from == ForgeDirection.getOrientation((int)1)) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.getOrientation((int)1)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.getOrientation((int)1);
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        this.recurringNodes.clear();
        this.cleaningNodes.clear();
        player.func_70006_a(ChatMessageComponent.func_111066_d((String)((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + MekanismUtils.localize("tooltip.configurator.pumpReset"))));
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }
}

