/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.IRedstoneControl;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasHandler,
ITubeConnection,
IRedstoneControl {
    public GasTank gasTank = new GasTank(96000);
    public static final int MAX_GAS = 96000;
    public int output = 16;
    public boolean dumping;
    public IRedstoneControl.RedstoneControl controlType;

    public TileEntityGasTank() {
        super("GasTank");
        this.inventory = new ItemStack[2];
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    @Override
    public void onUpdate() {
        if (this.inventory[0] != null && this.gasTank.getGas() != null) {
            this.gasTank.draw(GasTransmission.addGas(this.inventory[0], this.gasTank.getGas()), true);
        }
        if (this.inventory[1] != null && (this.gasTank.getGas() == null || this.gasTank.getGas().amount < this.gasTank.getMaxGas())) {
            this.gasTank.receive(GasTransmission.removeGas(this.inventory[1], this.gasTank.getGas() != null ? this.gasTank.getGas().getGas() : null, this.gasTank.getNeeded()), true);
        }
        if (!this.field_70331_k.field_72995_K && this.gasTank.getGas() != null && MekanismUtils.canFunction(this)) {
            GasStack toSend = new GasStack(this.gasTank.getGas().getGas(), Math.min(this.gasTank.getStored(), this.output));
            this.gasTank.draw(GasTransmission.emitGasToNetwork(toSend, this, ForgeDirection.getOrientation((int)this.facing)), true);
            TileEntity tileEntity = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
            if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.gasTank.getGas().getGas())) {
                this.gasTank.draw(((IGasHandler)tileEntity).receiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), toSend), true);
            }
        }
        if (!this.field_70331_k.field_72995_K && this.dumping) {
            this.gasTank.draw(8, true);
        }
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((ItemStack)itemstack).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, this.gasTank.getGas().getGas()));
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (this.gasTank.getGas() == null || ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, this.gasTank.getGas().getGas()));
        }
        return true;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.gasTank.receive(stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.gasTank.canDraw(type);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        if (side != ForgeDirection.getOrientation((int)this.facing)) {
            return this.gasTank.canReceive(type);
        }
        return false;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                this.dumping = !this.dumping;
            }
            for (EntityPlayer player : this.playersUsing) {
                PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), player);
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (dataStream.readBoolean()) {
            this.gasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
        } else {
            this.gasTank.setGas(null);
        }
        this.dumping = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.gasTank.read(nbtTags.func_74775_l("gasTank"));
        this.dumping = nbtTags.func_74767_n("dumping");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74766_a("gasTank", this.gasTank.write(new NBTTagCompound()));
        nbtTags.func_74757_a("dumping", this.dumping);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.gasTank.getGas() != null) {
            data.add(true);
            data.add(this.gasTank.getGas().getGas().getID());
            data.add(this.gasTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.dumping);
        data.add(this.controlType.ordinal());
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }
}

