/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.HashList;
import mekanism.common.IActiveState;
import mekanism.common.ILogisticalTransporter;
import mekanism.common.IRedstoneControl;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.transporter.Finder;
import mekanism.common.transporter.InvStack;
import mekanism.common.transporter.TItemStackFilter;
import mekanism.common.transporter.TransporterFilter;
import mekanism.common.transporter.TransporterManager;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityLogisticalSorter
extends TileEntityElectricBlock
implements IRedstoneControl,
IActiveState {
    public HashList<TransporterFilter> filters = new HashList();
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    public EnumColor color;
    public boolean autoEject;
    public boolean roundRobin;
    public int rrIndex = 0;
    public final int MAX_DELAY = 10;
    public int delayTicks;
    public boolean isActive;
    public boolean clientActive;
    public final double ENERGY_PER_ITEM = 5.0;

    public TileEntityLogisticalSorter() {
        super("LogisticalSorter", BlockMachine.MachineType.LOGISTICAL_SORTER.baseEnergy);
        this.inventory = new ItemStack[1];
        this.doAutoSync = false;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_70331_k.field_72995_K) {
            this.delayTicks = Math.max(0, this.delayTicks - 1);
            if (this.delayTicks == 6) {
                this.setActive(false);
            }
            if (MekanismUtils.canFunction(this) && this.delayTicks == 0) {
                TileEntity back = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_70331_k);
                TileEntity front = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_70331_k);
                if (back instanceof IInventory && (front instanceof ILogisticalTransporter || front instanceof IInventory)) {
                    IInventory inventory = (IInventory)back;
                    InvStack inInventory = null;
                    boolean hasFilter = false;
                    EnumColor filterColor = this.color;
                    int min = 0;
                    for (TransporterFilter filter : this.filters) {
                        InvStack invStack = filter.getStackFromInventory(inventory, ForgeDirection.getOrientation((int)this.facing).getOpposite());
                        if (invStack == null || invStack.getStack() == null || !filter.canFilter(invStack.getStack())) continue;
                        filterColor = filter.color;
                        hasFilter = true;
                        inInventory = invStack;
                        if (!(filter instanceof TItemStackFilter)) break;
                        TItemStackFilter itemFilter = (TItemStackFilter)filter;
                        if (!itemFilter.sizeMode) break;
                        min = itemFilter.min;
                        break;
                    }
                    if (!hasFilter && this.autoEject) {
                        inInventory = InventoryUtils.takeTopStack(inventory, ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), new Finder.FirstFinder());
                    }
                    if (inInventory != null && inInventory.getStack() != null) {
                        ItemStack used = null;
                        if (front instanceof ILogisticalTransporter) {
                            ItemStack rejects;
                            ILogisticalTransporter transporter = (ILogisticalTransporter)front;
                            if (!this.roundRobin) {
                                rejects = TransporterUtils.insert(this, transporter, inInventory.getStack(), filterColor, true, min);
                                if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                                    used = TransporterManager.getToUse(inInventory.getStack(), rejects);
                                }
                            } else {
                                rejects = TransporterUtils.insertRR(this, transporter, inInventory.getStack(), filterColor, true, min);
                                if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                                    used = TransporterManager.getToUse(inInventory.getStack(), rejects);
                                }
                            }
                        } else if (front instanceof IInventory) {
                            ItemStack rejects = InventoryUtils.putStackInInventory((IInventory)front, inInventory.getStack(), this.facing, false);
                            if (TransporterManager.didEmit(inInventory.getStack(), rejects)) {
                                used = TransporterManager.getToUse(inInventory.getStack(), rejects);
                            }
                        }
                        if (used != null) {
                            inInventory.use(used.field_77994_a);
                            inventory.func_70296_d();
                            this.setActive(true);
                        }
                    }
                    this.delayTicks = 10;
                }
            }
            if (this.playersUsing.size() > 0) {
                for (EntityPlayer player : this.playersUsing) {
                    PacketHandler.sendPacket(PacketHandler.Transmission.SINGLE_CLIENT, new PacketTileEntity().setParams(Coord4D.get(this), this.getGenericPacket(new ArrayList())), player);
                }
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbtTags) {
        super.func_70310_b(nbtTags);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        if (this.color != null) {
            nbtTags.func_74768_a("color", TransporterUtils.colors.indexOf((Object)this.color));
        }
        nbtTags.func_74757_a("autoEject", this.autoEject);
        nbtTags.func_74757_a("roundRobin", this.roundRobin);
        nbtTags.func_74768_a("rrIndex", this.rrIndex);
        NBTTagList filterTags = new NBTTagList();
        for (TransporterFilter filter : this.filters) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.write(tagCompound);
            filterTags.func_74742_a((NBTBase)tagCompound);
        }
        if (filterTags.func_74745_c() != 0) {
            nbtTags.func_74782_a("filters", (NBTBase)filterTags);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbtTags) {
        super.func_70307_a(nbtTags);
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        if (nbtTags.func_74764_b("color")) {
            this.color = TransporterUtils.colors.get(nbtTags.func_74762_e("color"));
        }
        this.autoEject = nbtTags.func_74767_n("autoEject");
        this.roundRobin = nbtTags.func_74767_n("roundRobin");
        this.rrIndex = nbtTags.func_74762_e("rrIndex");
        if (nbtTags.func_74764_b("filters")) {
            NBTTagList tagList = nbtTags.func_74761_m("filters");
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.filters.add(TransporterFilter.readFromNBT((NBTTagCompound)tagList.func_74743_b(i)));
            }
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.field_70331_k.field_72995_K) {
            int type = dataStream.readInt();
            if (type == 0) {
                int clickType = dataStream.readInt();
                if (clickType == 0) {
                    this.color = TransporterUtils.increment(this.color);
                } else if (clickType == 1) {
                    this.color = TransporterUtils.decrement(this.color);
                } else if (clickType == 2) {
                    this.color = null;
                }
            } else if (type == 1) {
                this.autoEject = !this.autoEject;
            } else if (type == 2) {
                this.roundRobin = !this.roundRobin;
                this.rrIndex = 0;
            }
            return;
        }
        super.handlePacketData(dataStream);
        int type = dataStream.readInt();
        if (type == 0) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            int c = dataStream.readInt();
            this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
            this.autoEject = dataStream.readBoolean();
            this.roundRobin = dataStream.readBoolean();
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(TransporterFilter.readFromPacket(dataStream));
            }
            MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (type == 1) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            int c = dataStream.readInt();
            this.color = c != -1 ? TransporterUtils.colors.get(c) : null;
            this.autoEject = dataStream.readBoolean();
            this.roundRobin = dataStream.readBoolean();
            MekanismUtils.updateBlock(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (type == 2) {
            this.filters.clear();
            int amount = dataStream.readInt();
            for (int i = 0; i < amount; ++i) {
                this.filters.add(TransporterFilter.readFromPacket(dataStream));
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(0);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public ArrayList getGenericPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(1);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        if (this.color != null) {
            data.add(TransporterUtils.colors.indexOf((Object)this.color));
        } else {
            data.add(-1);
        }
        data.add(this.autoEject);
        data.add(this.roundRobin);
        return data;
    }

    public ArrayList getFilterPacket(ArrayList data) {
        super.getNetworkedData(data);
        data.add(2);
        data.add(this.filters.size());
        for (TransporterFilter filter : this.filters) {
            filter.write(data);
        }
        return data;
    }

    public boolean canSendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_70331_k);
        if (back instanceof IInventory) {
            return InventoryUtils.canInsert(back, null, stack, ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), true);
        }
        return false;
    }

    public boolean hasInventory() {
        return Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_70331_k) instanceof IInventory;
    }

    public ItemStack sendHome(ItemStack stack) {
        TileEntity back = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing).getOpposite()).getTileEntity((IBlockAccess)this.field_70331_k);
        if (back instanceof IInventory) {
            return InventoryUtils.putStackInInventory((IInventory)back, stack, ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal(), true);
        }
        return stack;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.getOrientation((int)this.facing).ordinal() || side == ForgeDirection.getOrientation((int)this.facing).getOpposite().ordinal()) {
            return new int[]{0};
        }
        return null;
    }

    @Override
    public void func_70295_k_() {
        if (!this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacket(PacketHandler.Transmission.CLIENTS_RANGE, new PacketTileEntity().setParams(Coord4D.get(this), this.getFilterPacket(new ArrayList())), Coord4D.get(this), 50.0);
        }
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active) {
            PacketHandler.sendPacket(PacketHandler.Transmission.ALL_CLIENTS, new PacketTileEntity().setParams(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Object[0]);
            if (active) {
                this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "mekanism:etc.Click", 0.3f, 1.0f);
            }
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return false;
    }

    @Override
    protected EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public boolean canSetFacing(int facing) {
        return true;
    }
}

