/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import buildcraft.api.power.IPowerEmitter;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public final class CableUtils {
    private static Set<ForgeDirection> allSides = EnumSet.allOf(ForgeDirection.class);

    public static TileEntity[] getConnectedEnergyAcceptors(TileEntity tileEntity) {
        TileEntity[] acceptors = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity acceptor = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!CableUtils.isEnergyAcceptor(acceptor)) continue;
            acceptors[orientation.ordinal()] = acceptor;
        }
        return acceptors;
    }

    public static boolean isEnergyAcceptor(TileEntity tileEntity) {
        return tileEntity instanceof IStrictEnergyAcceptor || tileEntity instanceof IEnergySink || tileEntity instanceof IPowerReceptor && !(tileEntity instanceof IGridTransmitter) && MekanismUtils.useBuildCraft() || tileEntity instanceof IEnergyHandler;
    }

    public static TileEntity[] getConnectedCables(TileEntity tileEntity) {
        TileEntity[] cables = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity cable = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!CableUtils.isCable(cable)) continue;
            cables[orientation.ordinal()] = cable;
        }
        return cables;
    }

    public static boolean isCable(TileEntity tileEntity) {
        return TransmissionType.checkTransmissionType(tileEntity, TransmissionType.ENERGY);
    }

    public static boolean[] getConnections(TileEntity tileEntity) {
        return CableUtils.getConnections(tileEntity, allSides);
    }

    public static boolean[] getConnections(TileEntity tileEntity, Set<ForgeDirection> sides) {
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        Coord4D coord = Coord4D.get(tileEntity);
        for (ForgeDirection side : sides) {
            TileEntity tile = coord.getFromSide(side).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            int n = side.ordinal();
            connectable[n] = connectable[n] | (CableUtils.isEnergyAcceptor(tile) && CableUtils.isConnectable(tileEntity, tile, side));
            int n2 = side.ordinal();
            connectable[n2] = connectable[n2] | CableUtils.isCable(tile);
            int n3 = side.ordinal();
            connectable[n3] = connectable[n3] | CableUtils.isOutputter(tile, side);
        }
        return connectable;
    }

    public static TileEntity[] getConnectedOutputters(TileEntity tileEntity) {
        TileEntity[] outputters = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity outputter = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.field_70331_k);
            if (!CableUtils.isOutputter(tileEntity, orientation)) continue;
            outputters[orientation.ordinal()] = outputter;
        }
        return outputters;
    }

    public static boolean isOutputter(TileEntity tileEntity, ForgeDirection side) {
        return tileEntity instanceof ICableOutputter && ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite()) || tileEntity instanceof IEnergySource && ((IEnergySource)tileEntity).emitsEnergyTo(tileEntity, side.getOpposite()) || tileEntity instanceof IEnergyHandler && ((IEnergyHandler)tileEntity).canInterface(side.getOpposite()) || tileEntity instanceof IPowerEmitter && ((IPowerEmitter)tileEntity).canEmitPowerFrom(side.getOpposite());
    }

    public static boolean canConnectToAcceptor(ForgeDirection side, TileEntity tile) {
        if (tile == null) {
            return false;
        }
        TileEntity tileEntity = Coord4D.get(tile).getFromSide(side).getTileEntity((IBlockAccess)tile.field_70331_k);
        return CableUtils.isConnectable(tile, tileEntity, side);
    }

    public static boolean isConnectable(TileEntity orig, TileEntity tileEntity, ForgeDirection side) {
        if (tileEntity instanceof IGridTransmitter) {
            return false;
        }
        return tileEntity instanceof IStrictEnergyAcceptor ? ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(side.getOpposite()) : (tileEntity instanceof IEnergyAcceptor ? ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(orig, side.getOpposite()) : (tileEntity instanceof ICableOutputter ? ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite()) : (tileEntity instanceof IEnergyHandler ? ((IEnergyHandler)tileEntity).canInterface(side.getOpposite()) : tileEntity instanceof IPowerReceptor && MekanismUtils.useBuildCraft() && ((IPowerReceptor)tileEntity).getPowerReceiver(side.getOpposite()) != null)));
    }

    public static void emit(TileEntityElectricBlock emitter) {
        double sendingEnergy;
        if (!emitter.field_70331_k.field_72995_K && MekanismUtils.canFunction(emitter) && (sendingEnergy = Math.min(emitter.getEnergy(), emitter.getMaxOutput())) > 0.0) {
            ArrayList<ForgeDirection> outputtingSides = new ArrayList<ForgeDirection>();
            boolean[] connectable = CableUtils.getConnections(emitter, emitter.getOutputtingSides());
            for (ForgeDirection side : emitter.getOutputtingSides()) {
                if (!connectable[side.ordinal()]) continue;
                outputtingSides.add(side);
            }
            if (outputtingSides.size() > 0) {
                double sent = 0.0;
                boolean cont = false;
                do {
                    cont = false;
                    double prev = sent;
                    if (!(sendingEnergy - (sent += CableUtils.emit_do(emitter, outputtingSides, sendingEnergy - sent)) > 0.0) || !(sent - prev > 0.0)) continue;
                    cont = true;
                } while (cont);
                emitter.setEnergy(emitter.getEnergy() - sent);
            }
        }
    }

    private static double emit_do(TileEntityElectricBlock emitter, List<ForgeDirection> outputtingSides, double totalToSend) {
        double remains = totalToSend % (double)outputtingSides.size();
        double splitSend = (totalToSend - remains) / (double)outputtingSides.size();
        double sent = 0.0;
        ArrayList<ForgeDirection> toRemove = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : outputtingSides) {
            TileEntity tileEntity = Coord4D.get(emitter).getFromSide(side).getTileEntity((IBlockAccess)emitter.field_70331_k);
            double toSend = splitSend + remains;
            remains = 0.0;
            double prev = sent;
            if ((sent += CableUtils.emit_do_do(emitter, tileEntity, side, toSend)) - prev != 0.0) continue;
            toRemove.add(side);
        }
        for (ForgeDirection side : toRemove) {
            outputtingSides.remove(side);
        }
        return sent;
    }

    private static double emit_do_do(TileEntityElectricBlock from, TileEntity tileEntity, ForgeDirection side, double sendingEnergy) {
        PowerHandler.PowerReceiver receiver;
        double sent = 0.0;
        if (tileEntity instanceof IStrictEnergyAcceptor) {
            IStrictEnergyAcceptor acceptor = (IStrictEnergyAcceptor)tileEntity;
            if (acceptor.canReceiveEnergy(side.getOpposite())) {
                double prev = sent;
                sent += acceptor.transferEnergyToAcceptor(side.getOpposite(), sendingEnergy);
            }
        } else if (tileEntity instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)tileEntity;
            if (handler.canInterface(side.getOpposite())) {
                int used = handler.receiveEnergy(side.getOpposite(), (int)Math.round(sendingEnergy * Mekanism.TO_TE), false);
                sent += (double)used * Mekanism.FROM_TE;
            }
        } else if (tileEntity instanceof IEnergySink) {
            if (((IEnergySink)tileEntity).acceptsEnergyFrom(from, side.getOpposite())) {
                double toSend = Math.min(sendingEnergy, Math.min((double)((IEnergySink)tileEntity).getMaxSafeInput(), ((IEnergySink)tileEntity).demandedEnergyUnits()) * Mekanism.FROM_IC2);
                double rejects = ((IEnergySink)tileEntity).injectEnergyUnits(side.getOpposite(), toSend * Mekanism.TO_IC2) * Mekanism.FROM_IC2;
                sent += toSend - rejects;
            }
        } else if (tileEntity instanceof IPowerReceptor && MekanismUtils.useBuildCraft() && (receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(side.getOpposite())) != null) {
            double transferEnergy = Math.min(sendingEnergy, (double)receiver.powerRequest() * Mekanism.FROM_BC);
            float used = receiver.receiveEnergy(PowerHandler.Type.STORAGE, (float)(transferEnergy * Mekanism.TO_BC), side.getOpposite());
            sent += (double)used * Mekanism.FROM_BC;
        }
        return sent;
    }

    static {
        allSides.remove(ForgeDirection.UNKNOWN);
    }
}

