/*
 * Decompiled with CFR 0.152.
 */
package dan200.quantum.shared;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import dan200.QCraft;
import dan200.quantum.shared.BlockQBlock;
import dan200.quantum.shared.BlockQuantumComputer;
import dan200.quantum.shared.BlockQuantumLogic;
import dan200.quantum.shared.BlockQuantumOre;
import dan200.quantum.shared.BlockQuantumPortal;
import dan200.quantum.shared.ConnectionHandler;
import dan200.quantum.shared.ContainerQuantumComputer;
import dan200.quantum.shared.CreativeTabQuantumCraft;
import dan200.quantum.shared.EncryptionRegistry;
import dan200.quantum.shared.EntangledQBlockRecipe;
import dan200.quantum.shared.EntangledQuantumComputerRecipe;
import dan200.quantum.shared.IQCraftProxy;
import dan200.quantum.shared.ItemEOS;
import dan200.quantum.shared.ItemQBlock;
import dan200.quantum.shared.ItemQuantumComputer;
import dan200.quantum.shared.ItemQuantumDust;
import dan200.quantum.shared.ItemQuantumGoggles;
import dan200.quantum.shared.ItemQuantumLogic;
import dan200.quantum.shared.PortalRegistry;
import dan200.quantum.shared.QBlockRecipe;
import dan200.quantum.shared.QuantumOreGenerator;
import dan200.quantum.shared.TileEntityQBlock;
import dan200.quantum.shared.TileEntityQuantumComputer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;

public abstract class QCraftProxyCommon
implements IQCraftProxy {
    @Override
    public void preLoad() {
        this.registerItems();
    }

    @Override
    public void load() {
        QCraft.log("Loading qCraft v1.1 (rev 253)");
        this.registerTileEntities();
        this.registerForgeHandlers();
    }

    @Override
    public abstract boolean isClient();

    @Override
    public abstract Object getQuantumComputerGUI(ud var1, TileEntityQuantumComputer var2);

    @Override
    public abstract void showItemTransferGUI(uf var1, TileEntityQuantumComputer var2);

    @Override
    public boolean isPlayerWearingGoggles(uf player) {
        ye headGear = player.bn.f(3);
        return headGear != null && headGear.b() == QCraft.Items.quantumGoggles;
    }

    @Override
    public boolean isPlayerWearingQuantumGoggles(uf player) {
        ye headGear = player.bn.f(3);
        return headGear != null && headGear.b() == QCraft.Items.quantumGoggles && headGear.k() == 0;
    }

    @Override
    public abstract boolean isLocalPlayerWearingGoggles();

    @Override
    public abstract boolean isLocalPlayerWearingQuantumGoggles();

    @Override
    public abstract void renderQuantumGogglesOverlay(float var1, float var2);

    @Override
    public abstract void renderAOGogglesOverlay(float var1, float var2);

    @Override
    public abstract void spawnQuantumDustFX(abw var1, double var2, double var4, double var6);

    private void registerItems() {
        QCraft.creativeTab = new CreativeTabQuantumCraft(ww.getNextID(), "qCraft");
        if (QCraft.enableQuantumDust) {
            QCraft.Blocks.quantumOre = new BlockQuantumOre(QCraft.quantumOreBlockID, false);
            GameRegistry.registerBlock((aqz)QCraft.Blocks.quantumOre, (String)"quantumore");
            LanguageRegistry.instance().addNameForObject((Object)QCraft.Blocks.quantumOre, "en_US", "Quantum Ore");
            QCraft.Blocks.quantumOreGlowing = new BlockQuantumOre(QCraft.quantumOreGlowingBlockID, true);
            GameRegistry.registerBlock((aqz)QCraft.Blocks.quantumOreGlowing, (String)"quantumoreglowing");
            LanguageRegistry.instance().addNameForObject((Object)QCraft.Blocks.quantumOreGlowing, "en_US", "Quantum Ore");
        }
        if (QCraft.enableQuantumGates) {
            QCraft.Blocks.quantumLogic = new BlockQuantumLogic(QCraft.quantumLogicBlockID);
            GameRegistry.registerBlock((aqz)QCraft.Blocks.quantumLogic, ItemQuantumLogic.class, (String)"quantumlogic");
        }
        if (QCraft.enableQBlock) {
            QCraft.Blocks.qBlock = new BlockQBlock(QCraft.qBlockBlockID);
            GameRegistry.registerBlock((aqz)QCraft.Blocks.qBlock, ItemQBlock.class, (String)"qblock");
        }
        if (QCraft.enableQuantumComputer) {
            QCraft.Blocks.quantumComputer = new BlockQuantumComputer(QCraft.quantumComputerBlockID);
            GameRegistry.registerBlock((aqz)QCraft.Blocks.quantumComputer, ItemQuantumComputer.class, (String)"quantumcomputer");
            QCraft.Blocks.quantumPortal = new BlockQuantumPortal(QCraft.quantumPortalBlockID);
            GameRegistry.registerBlock((aqz)QCraft.Blocks.quantumPortal, (String)"quantumportal");
        }
        if (QCraft.enableQuantumDust) {
            QCraft.Items.quantumDust = new ItemQuantumDust(QCraft.quantumDustItemID);
            LanguageRegistry.instance().addNameForObject((Object)QCraft.Items.quantumDust, "en_US", "Quantum Dust");
            GameRegistry.registerItem((yc)QCraft.Items.quantumDust, (String)"quantumDust");
        }
        if (QCraft.enableQBlock) {
            QCraft.Items.eos = new ItemEOS(QCraft.eosItemID);
            GameRegistry.registerItem((yc)QCraft.Items.eos, (String)"eos");
        }
        if (QCraft.enableQuantumGoggles) {
            QCraft.Items.quantumGoggles = new ItemQuantumGoggles(QCraft.quantumGogglesItemID);
            GameRegistry.registerItem((yc)QCraft.Items.quantumGoggles, (String)"quantumGoggles");
        }
        if (QCraft.enableQuantumGates) {
            ye observer = new ye((aqz)QCraft.Blocks.quantumLogic, 1, 0);
            GameRegistry.addRecipe((ye)observer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), aqz.y, Character.valueOf('Y'), new ye((yc)QCraft.Items.eos, 1, 1), Character.valueOf('Z'), yc.aE});
            LanguageRegistry.instance().addNameForObject((Object)observer, "en_US", "Automatic Observer");
        }
        if (QCraft.enableQBlock) {
            ye eos = new ye((yc)QCraft.Items.eos, 1, 0);
            GameRegistry.addRecipe((ye)eos, (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), QCraft.Items.quantumDust});
            LanguageRegistry.instance().addNameForObject((Object)eos, "en_US", "Essence of Superposition");
            ye eoo = new ye((yc)QCraft.Items.eos, 1, 1);
            GameRegistry.addRecipe((ye)eoo, (Object[])new Object[]{" X ", "X X", " X ", Character.valueOf('X'), QCraft.Items.quantumDust});
            LanguageRegistry.instance().addNameForObject((Object)eoo, "en_US", "Essence of Observation");
            ye eoe = new ye((yc)QCraft.Items.eos, 1, 2);
            GameRegistry.addRecipe((ye)eoe, (Object[])new Object[]{"X X", " Y ", "X X", Character.valueOf('X'), QCraft.Items.quantumDust, Character.valueOf('Y'), eos});
            LanguageRegistry.instance().addNameForObject((Object)eoe, "en_US", "Essence of Entanglement");
            GameRegistry.addRecipe((aah)new QBlockRecipe());
            LanguageRegistry.instance().addNameForObject((Object)ItemQBlock.create(0, new int[6], -1, 1), "en_US", "Observer Dependent Block");
            LanguageRegistry.instance().addNameForObject((Object)ItemQBlock.create(1, new int[6], -1, 1), "en_US", "Quantum Block");
            GameRegistry.addRecipe((aah)new EntangledQBlockRecipe());
            LanguageRegistry.instance().addNameForObject((Object)ItemQBlock.create(0, new int[6], 0, 1), "en_US", "Entangled Block");
            LanguageRegistry.instance().addNameForObject((Object)ItemQBlock.create(1, new int[6], 0, 1), "en_US", "Entangled Quantum Block");
        }
        if (QCraft.enableQuantumComputer) {
            ye regularQuantumComputer = ItemQuantumComputer.create(-1, 1);
            GameRegistry.addRecipe((ye)regularQuantumComputer, (Object[])new Object[]{"XXX", "XYX", "XZX", Character.valueOf('X'), yc.q, Character.valueOf('Y'), QCraft.Items.quantumDust, Character.valueOf('Z'), aqz.bv});
            LanguageRegistry.instance().addNameForObject((Object)regularQuantumComputer, "en_US", "Quantum Computer");
            ye entangledQuantumComputer = ItemQuantumComputer.create(0, 1);
            GameRegistry.addRecipe((aah)new EntangledQuantumComputerRecipe());
            LanguageRegistry.instance().addNameForObject((Object)entangledQuantumComputer, "en_US", "Entangled Quantum Computer");
        }
        if (QCraft.enableQuantumGoggles) {
            ye quantumGoggles = new ye((yc)QCraft.Items.quantumGoggles, 1, 0);
            GameRegistry.addRecipe((ye)quantumGoggles, (Object[])new Object[]{"XYX", Character.valueOf('X'), aqz.bv, Character.valueOf('Y'), QCraft.Items.quantumDust});
            LanguageRegistry.instance().addNameForObject((Object)quantumGoggles, "en_US", "Quantum Goggles");
            ye aoGoggles = new ye((yc)QCraft.Items.quantumGoggles, 1, 1);
            GameRegistry.addRecipe((ye)aoGoggles, (Object[])new Object[]{"XYX", Character.valueOf('X'), aqz.bv, Character.valueOf('Y'), new ye((yc)QCraft.Items.eos, 1, 1)});
            LanguageRegistry.instance().addNameForObject((Object)aoGoggles, "en_US", "Anti-Observation Goggles");
        }
        if (QCraft.enableWorldGenReplacementRecipes) {
            GameRegistry.addRecipe((ye)new ye((yc)QCraft.Items.quantumDust, 2), (Object[])new Object[]{"XY", Character.valueOf('X'), yc.aE, Character.valueOf('Y'), new ye(yc.aY, 1, 10)});
        }
    }

    private void registerTileEntities() {
        if (QCraft.enableQBlock) {
            GameRegistry.registerTileEntity(TileEntityQBlock.class, (String)"qblock");
        }
        if (QCraft.enableQuantumComputer) {
            GameRegistry.registerTileEntity(TileEntityQuantumComputer.class, (String)"qcomputer");
        }
    }

    private void registerForgeHandlers() {
        ForgeHandlers handlers = new ForgeHandlers();
        MinecraftForge.EVENT_BUS.register((Object)handlers);
        if (QCraft.enableWorldGen) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new QuantumOreGenerator());
        }
        NetworkRegistry.instance().registerGuiHandler((Object)QCraft.instance, (IGuiHandler)handlers);
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new ConnectionHandler());
        GameRegistry.registerPlayerTracker((IPlayerTracker)handlers);
    }

    private File getWorldSaveLocation(abw world, String subPath) {
        File rootDir = FMLCommonHandler.instance().getMinecraftServerInstance().d(".");
        File saveDir = null;
        saveDir = QCraft.isServer() ? new File(rootDir, world.M().g()) : new File(rootDir, "saves/" + world.M().g());
        return new File(saveDir, subPath);
    }

    private File getEntanglementSaveLocation(abw world) {
        return this.getWorldSaveLocation(world, "quantum/entanglements.bin");
    }

    private File getEncryptionSaveLocation(abw world) {
        return this.getWorldSaveLocation(world, "quantum/encryption.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static by loadNBTFromPath(File file) {
        block5: {
            by by2;
            if (file == null || !file.exists()) break block5;
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
            try {
                by2 = ci.a((InputStream)input);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)input).close();
                    throw throwable;
                }
                catch (IOException e) {
                    QCraft.log("Warning: failed to load QCraft entanglement info");
                }
            }
            ((InputStream)input).close();
            return by2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveNBTToPath(File file, by nbt) {
        block5: {
            try {
                if (file == null) break block5;
                file.getParentFile().mkdirs();
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                try {
                    ci.a((by)nbt, (OutputStream)output);
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
            catch (IOException e) {
                QCraft.log("Warning: failed to save QCraft entanglement info");
            }
        }
    }

    public class ForgeHandlers
    implements IGuiHandler,
    IPlayerTracker {
        private ForgeHandlers() {
        }

        public Object getServerGuiElement(int id, uf player, abw world, int x, int y, int z) {
            asp tile = world.r(x, y, z);
            switch (id) {
                case 105: {
                    if (tile == null || !(tile instanceof TileEntityQuantumComputer)) break;
                    TileEntityQuantumComputer computer = (TileEntityQuantumComputer)tile;
                    return new ContainerQuantumComputer(player.bn, computer);
                }
            }
            return null;
        }

        public Object getClientGuiElement(int id, uf player, abw world, int x, int y, int z) {
            asp tile = world.r(x, y, z);
            switch (id) {
                case 105: {
                    if (tile == null || !(tile instanceof TileEntityQuantumComputer)) break;
                    TileEntityQuantumComputer drive = (TileEntityQuantumComputer)tile;
                    return QCraftProxyCommon.this.getQuantumComputerGUI(player.bn, drive);
                }
            }
            return null;
        }

        @ForgeSubscribe
        public void onWorldLoad(WorldEvent.Load event) {
            if (!event.world.I) {
                TileEntityQBlock.QBlockRegistry.reset();
                TileEntityQuantumComputer.ComputerRegistry.reset();
                PortalRegistry.PortalRegistry.reset();
                EncryptionRegistry.Instance.reset();
                by rootnbt = QCraftProxyCommon.loadNBTFromPath(QCraftProxyCommon.this.getEntanglementSaveLocation(event.world));
                by encryptionnbt = QCraftProxyCommon.loadNBTFromPath(QCraftProxyCommon.this.getEncryptionSaveLocation(event.world));
                if (rootnbt != null) {
                    if (rootnbt.b("qblocks")) {
                        by qblocks = rootnbt.l("qblocks");
                        TileEntityQBlock.QBlockRegistry.readFromNBT(qblocks);
                    }
                    if (rootnbt.b("qcomputers")) {
                        by qcomputers = rootnbt.l("qcomputers");
                        TileEntityQuantumComputer.ComputerRegistry.readFromNBT(qcomputers);
                    }
                    if (rootnbt.b("portals")) {
                        by portals = rootnbt.l("portals");
                        PortalRegistry.PortalRegistry.readFromNBT(portals);
                    }
                }
                if (encryptionnbt != null && encryptionnbt.b("encryption")) {
                    by encyption = encryptionnbt.l("encryption");
                    EncryptionRegistry.Instance.readFromNBT(encyption);
                }
            }
        }

        @ForgeSubscribe
        public void onWorldUnload(WorldEvent.Unload event) {
            if (!event.world.I) {
                TileEntityQBlock.QBlockRegistry.reset();
                TileEntityQuantumComputer.ComputerRegistry.reset();
                PortalRegistry.PortalRegistry.reset();
                EncryptionRegistry.Instance.reset();
            }
        }

        @ForgeSubscribe
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.world.I) {
                by rootnbt = new by();
                by encryptionnbt = new by();
                by qblocks = new by();
                TileEntityQBlock.QBlockRegistry.writeToNBT(qblocks);
                rootnbt.a("qblocks", qblocks);
                by qcomputers = new by();
                TileEntityQuantumComputer.ComputerRegistry.writeToNBT(qcomputers);
                rootnbt.a("qcomputers", qcomputers);
                by portals = new by();
                PortalRegistry.PortalRegistry.writeToNBT(portals);
                rootnbt.a("portals", portals);
                by encrpytion = new by();
                EncryptionRegistry.Instance.writeToNBT(encrpytion);
                encryptionnbt.a("encryption", encrpytion);
                QCraftProxyCommon.saveNBTToPath(QCraftProxyCommon.this.getEntanglementSaveLocation(event.world), rootnbt);
                QCraftProxyCommon.saveNBTToPath(QCraftProxyCommon.this.getEncryptionSaveLocation(event.world), encryptionnbt);
            }
        }

        public void onPlayerLogin(uf player) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                QCraft.clearUnverifiedLuggage(player);
                QCraft.requestLuggage(player);
            }
        }

        public void onPlayerLogout(uf player) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                QCraft.clearUnverifiedLuggage(player);
            }
        }

        public void onPlayerChangedDimension(uf player) {
        }

        public void onPlayerRespawn(uf player) {
        }
    }
}

