/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.entity;

import java.util.ArrayList;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.IShearable;

public class EntityMammoth
extends EntityTameable
implements IShearable {
    private static final int SIZE_MULTIFER = 5;
    private static final int EATING_TIMES_TO_GROW_FUR = 5;
    private static final float CHILD_SIZE_Y = 1.3f;
    private static final float CHILD_SIZE_X = 0.9f;
    private static final float ADULT_SIZE_Y = 6.5f;
    private static final float ADULT_SIZE_X = 4.5f;
    private static final Potion BIOME_SICK = Potion.field_76437_t;
    private static final PotionEffect BIOME_EFFECT = new PotionEffect(Potion.field_76437_t.field_76415_H, 60, 1);
    private static final BiomeGenBase[] COLD_BIOMES = new BiomeGenBase[]{BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_76775_o, BiomeGenBase.field_76774_n, BiomeGenBase.field_76768_g, BiomeGenBase.field_76784_u};
    private static final BiomeGenBase[] HOT_BIOMES = new BiomeGenBase[]{BiomeGenBase.field_76769_d, BiomeGenBase.field_76780_h, BiomeGenBase.field_76782_w, BiomeGenBase.field_76792_x, BiomeGenBase.field_76778_j, BiomeGenBase.field_76786_s};
    private EntityAIEatGrass aiEatGrass = new EntityAIEatGrass((EntityLiving)this);
    private int eatGrassTimes = 0;
    private int swingTick;

    public EntityMammoth(World par1World) {
        super(par1World);
        this.func_70105_a(0.9f, 1.3f);
        float var2 = 0.23f;
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 0.25, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)0.38f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, (double)var2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 0.25, Item.field_77685_T.field_77779_bT, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 0.25));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.aiEatGrass);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander((EntityCreature)this, (double)var2));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
    }

    public String func_70023_ak() {
        return StatCollector.func_74838_a((String)"entity.mammoth.name");
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70652_k(Entity par1Entity) {
        this.swingTick = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean var2 = par1Entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.func_70631_g_() ? 2.0f : 7.0f);
        if (var2) {
            par1Entity.field_70181_x += (double)0.4f;
        }
        this.field_70170_p.func_72956_a((Entity)this, "mob.irongolem.throw", 1.0f, 1.0f);
        return var2;
    }

    public int func_70627_aG() {
        return 360;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.updateSize();
        if (this.swingTick > 0) {
            --this.swingTick;
        }
        if (!this.func_70644_a(BIOME_SICK) && this.checkBiomeAndWeakness()) {
            this.func_70690_d(BIOME_EFFECT);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("Sheared", this.getSheared());
        par1NBTTagCompound.func_74774_a("Color", (byte)this.getFleeceColor());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.setSheared(par1NBTTagCompound.func_74767_n("Sheared"));
        this.setFleeceColor(par1NBTTagCompound.func_74771_c("Color"));
    }

    protected String func_70639_aQ() {
        return "fossilsarch:Mammoth_living";
    }

    protected String func_70621_aR() {
        return "fossilsarch:Mammoth_hurt";
    }

    protected String func_70673_aS() {
        return "fossilsarch:Mammoth_death";
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected int func_70633_aT() {
        return Item.field_77770_aF.field_77779_bT;
    }

    protected void func_70628_a(boolean par1, int par2) {
        int var4;
        int var3 = this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(1 + par2);
        for (var4 = 0; var4 < var3; ++var4) {
            this.func_70025_b(Item.field_77770_aF.field_77779_bT, 1);
        }
        var3 = this.field_70146_Z.nextInt(3) + 1 + this.field_70146_Z.nextInt(1 + par2);
        for (var4 = 0; var4 < var3; ++var4) {
            if (this.func_70027_ad()) {
                this.func_70025_b(Item.field_77734_bj.field_77779_bT, 1);
                continue;
            }
            this.func_70025_b(Item.field_77741_bi.field_77779_bT, 1);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(18, (Object)new Byte(3));
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        ItemStack var2 = par1EntityPlayer.field_71071_by.func_70448_g();
        if (var2 != null && var2.func_77973_b().equals(mod_Fossil.ChickenEss)) {
            this.func_70873_a(this.func_70874_b() + 2000);
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    public EntityAgeable func_90011_a(EntityAgeable par1EntityAnimal) {
        EntityMammoth baby = new EntityMammoth(this.field_70170_p);
        if (this.func_70909_n()) {
            baby.func_70910_a(this.func_70905_p());
            baby.func_70903_f(true);
        }
        return baby;
    }

    public boolean isShearable(ItemStack item, World world, int x, int y, int z) {
        this.eatGrassTimes = 0;
        return !this.getSheared() && !this.func_70631_g_();
    }

    public void setSheared(boolean par1) {
        byte var2 = this.field_70180_af.func_75683_a(18);
        if (par1) {
            this.field_70180_af.func_75692_b(18, (Object)((byte)(var2 | 0x10)));
        } else {
            this.field_70180_af.func_75692_b(18, (Object)((byte)(var2 & 0xFFFFFFEF)));
        }
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, World world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int i = 1 + this.field_70146_Z.nextInt(20);
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Block.field_72101_ab.field_71990_ca, 1, 12));
        }
        this.setSheared(true);
        return ret;
    }

    public int getFleeceColor() {
        return this.field_70180_af.func_75683_a(18) & 0xF;
    }

    public void setFleeceColor(int par1) {
        byte var2 = this.field_70180_af.func_75683_a(18);
        this.field_70180_af.func_75692_b(18, (Object)((byte)(var2 & 0xF0 | par1 & 0xF)));
    }

    public boolean getSheared() {
        return (this.field_70180_af.func_75683_a(18) & 0x10) != 0;
    }

    public void updateSize() {
        block5: {
            block4: {
                if (this.func_70631_g_()) {
                    return;
                }
                if (this.field_70130_N != 4.5f) break block4;
                if (this.field_70131_O == 6.5f) break block5;
            }
            this.func_70105_a(4.5f, 6.5f);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_70615_aA() {
        if (this.getSheared()) {
            ++this.eatGrassTimes;
            if (this.eatGrassTimes >= 5) {
                this.setSheared(false);
                this.eatGrassTimes = 0;
            }
        }
        if (this.func_70631_g_()) {
            int var1 = this.func_70874_b() + 1200;
            if (var1 > 0) {
                var1 = 0;
            }
            this.func_70873_a(var1);
        }
    }

    private boolean checkBiomeAndWeakness() {
        if (this.func_70631_g_()) {
            return false;
        }
        BiomeGenBase locatBiome = this.field_70170_p.func_72807_a((int)this.field_70165_t, (int)this.field_70161_v);
        boolean inCold = this.isBiomeCold(locatBiome);
        boolean inHot = this.isBiomeHot(locatBiome);
        if (this.getSheared()) {
            return inCold;
        }
        return inHot;
    }

    private boolean isBiomeHot(BiomeGenBase locatBiome) {
        return this.isBiomeInList(HOT_BIOMES, locatBiome);
    }

    private boolean isBiomeCold(BiomeGenBase locatBiome) {
        return this.isBiomeInList(COLD_BIOMES, locatBiome);
    }

    private boolean isBiomeInList(BiomeGenBase[] biomeList, BiomeGenBase locatBiome) {
        for (int i = 0; i < biomeList.length; ++i) {
            if (!biomeList[i].equals(locatBiome)) continue;
            return true;
        }
        return false;
    }

    public EntityMammoth Imprinting(double posXparm, double posYparm, double posZparm) {
        EntityPlayer nearest = this.field_70170_p.func_72977_a(posXparm, posYparm, posZparm, 50.0);
        if (nearest == null) {
            return this;
        }
        this.func_70910_a(nearest.field_71092_bJ);
        this.func_70903_f(true);
        return this;
    }

    public int getSwingTick() {
        return this.swingTick;
    }
}

