/*
 * Decompiled with CFR 0.152.
 */
package net.fossilsarch.common.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import net.fossilsarch.common.io.ByteArrayTag;
import net.fossilsarch.common.io.CompoundTag;
import net.fossilsarch.common.io.NBTInputStream;
import net.fossilsarch.common.io.ShortTag;
import net.fossilsarch.mod_Fossil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenWeaponShopA
implements IWorldGenerator {
    private File SchFile;
    private FileInputStream SchInp;
    private NBTInputStream SchSource;
    private ArrayList ModelTagList = new ArrayList();
    private int WidthX;
    private int Layers;
    private int WidthZ;
    private byte[] BlockArray;
    private byte[] MDArray;
    private int ShopCount = 0;
    private static final int ShopLimit = 6250;

    public WorldGenWeaponShopA() {
        Class<?> clsTmp = this.getClass();
        URL urlTmp = clsTmp.getResource("/FossilStructers/");
        String tmp = urlTmp.getFile();
        File dirTmp = new File(tmp);
        this.SchFile = new File(dirTmp, "WeaponShopA.schematic");
        mod_Fossil.DebugMessage("Model route:" + this.SchFile.getPath());
        if (this.SchFile.exists()) {
            try {
                this.SchInp = new FileInputStream(this.SchFile);
                this.SchSource = new NBTInputStream(this.SchInp);
                this.ModelTagList.add((CompoundTag)this.SchSource.readTag());
                this.SchSource.close();
            }
            catch (Throwable t) {
                return;
            }
            mod_Fossil.DebugMessage("WeaponShopA model loaded");
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        chunkX *= 16;
        chunkZ *= 16;
        int posY = 50;
        if (this.ModelTagList.isEmpty()) {
            return;
        }
        CompoundTag Tg = (CompoundTag)this.ModelTagList.get(random.nextInt(this.ModelTagList.size()));
        this.WidthX = ((ShortTag)Tg.getValue().get("Width")).getValue().shortValue();
        this.Layers = ((ShortTag)Tg.getValue().get("Height")).getValue().shortValue();
        this.WidthZ = ((ShortTag)Tg.getValue().get("Length")).getValue().shortValue();
        this.BlockArray = ((ByteArrayTag)Tg.getValue().get("Blocks")).getValue();
        this.MDArray = ((ByteArrayTag)Tg.getValue().get("Data")).getValue();
        if (this.ShopCount != 0) {
            --this.ShopCount;
            return;
        }
        this.ShopCount = 6250;
        boolean WaterLayerCount = false;
        int Tall = 7;
        int WidthX = 12;
        int WidthZ = 11;
        boolean AirBlockCount = false;
        for (int XScanning = chunkX; XScanning <= chunkX + WidthX; ++XScanning) {
            for (int ZScanning = chunkZ; ZScanning <= chunkZ + WidthZ; ++ZScanning) {
                Material material = world.func_72803_f(XScanning, posY, ZScanning);
                if (material.func_76220_a()) continue;
                return;
            }
        }
        for (int ScanY = 0; ScanY < this.Layers; ++ScanY) {
            for (int ScanZ = 0; ScanZ < WidthZ; ++ScanZ) {
                for (int ScanX = 0; ScanX < WidthX; ++ScanX) {
                    int MixedIndex = ScanY * WidthX * WidthZ + ScanZ * WidthX + ScanX;
                    short TmpBlock = this.BlockArray[MixedIndex];
                    short TmpMD = this.MDArray[MixedIndex];
                    if (TmpBlock == Block.field_72069_aq.field_71990_ca) {
                        TmpBlock = 0;
                    }
                    world.func_72832_d(chunkX - WidthX / 2 + ScanX, posY + ScanY, chunkZ - WidthZ / 2 + ScanZ, (int)TmpBlock, (int)TmpMD, 2);
                    if (TmpBlock != Block.field_72077_au.field_71990_ca) continue;
                    this.SetupTileEntitys(world, random, chunkX - WidthX / 2 + ScanX, posY + ScanY, chunkZ - WidthZ / 2 + ScanZ);
                }
            }
        }
        mod_Fossil.DebugMessage("Placing Weapon Shop-A at " + chunkX + ',' + posY + ',' + chunkZ);
    }

    public ItemStack GetRandomContent(Random rand) {
        int Chance = rand.nextInt(1000);
        if (Chance <= 10) {
            return new ItemStack(Item.field_77718_z);
        }
        if (Chance < 20) {
            return new ItemStack(mod_Fossil.Diamondjavelin, rand.nextInt(63) + 1);
        }
        if (Chance < 35) {
            return new ItemStack(Item.field_77672_G);
        }
        if (Chance < 50) {
            return new ItemStack(mod_Fossil.Goldjavelin, rand.nextInt(63) + 1);
        }
        if (Chance < 70) {
            return new ItemStack(Item.field_77716_q);
        }
        if (Chance < 90) {
            return new ItemStack(mod_Fossil.Ironjavelin, rand.nextInt(63) + 1);
        }
        if (Chance < 105) {
            return new ItemStack(Item.field_77711_v);
        }
        if (Chance < 120) {
            return new ItemStack(mod_Fossil.Stonejavelin, rand.nextInt(63) + 1);
        }
        if (Chance < 130) {
            return new ItemStack(Item.field_77715_r);
        }
        if (Chance < 140) {
            return new ItemStack(mod_Fossil.Woodjavelin, rand.nextInt(63) + 1);
        }
        if (Chance < 240) {
            return new ItemStack((Item)Item.field_77707_k);
        }
        if (Chance < 750) {
            return new ItemStack(Item.field_77704_l, rand.nextInt(63) + 1);
        }
        return null;
    }

    public void SetupTileEntitys(World world, Random rand, int CordX, int CordY, int CordZ) {
        TileEntity Target = world.func_72796_p(CordX, CordY, CordZ);
        if (Target == null) {
            return;
        }
        if (Target instanceof TileEntityFurnace) {
            return;
        }
        if (Target instanceof TileEntityChest) {
            TileEntityChest Chest = (TileEntityChest)Target;
            ItemStack Tmp = null;
            int Count = rand.nextInt(27);
            for (int i = 1; i <= Count; ++i) {
                Tmp = this.GetRandomContent(rand);
                if (Tmp == null) continue;
                Chest.func_70299_a(rand.nextInt(Chest.func_70302_i_()), Tmp);
            }
        } else {
            return;
        }
    }
}

