/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public abstract class NecroEntityBase {
    public String mobName;
    public bjo texture;
    public ye headItem;
    public ye torsoItem;
    public ye armItem;
    public ye legItem;
    public Object[] headRecipe;
    public Object[] torsoRecipe;
    public Object[] armRecipe;
    public Object[] legRecipe;
    public boolean hasHead;
    public boolean hasTorso;
    public boolean hasArms;
    public boolean hasLegs;
    public static int organID;
    public yc organs;
    public int textureWidth;
    public int textureHeight;
    protected boolean isNecromancyInstalled;
    public BodyPart[] head;
    public BodyPart[] torso;
    public BodyPart[] armLeft;
    public BodyPart[] armRight;
    public BodyPart[] legs;

    public NecroEntityBase(String mobName) {
        this.mobName = mobName;
        this.hasHead = true;
        this.hasTorso = true;
        this.hasArms = true;
        this.hasLegs = true;
        this.textureWidth = 64;
        this.textureHeight = 32;
        try {
            Class.forName("com.sirolf2009.necromancy.Necromancy");
            this.organs = yc.g[organID];
            this.isNecromancyInstalled = true;
            this.initRecipes();
        }
        catch (ClassNotFoundException e) {
            System.err.println(mobName + " could not be registered, the necromancy mod is not installed");
            this.isNecromancyInstalled = false;
        }
    }

    public void initRecipes() {
    }

    public void initDefaultRecipes(Object ... items) {
        Object headItem = null;
        Object torsoItem = null;
        Object armItem = null;
        Object legItem = null;
        if (items.length == 1) {
            armItem = legItem = items[0];
            torsoItem = legItem;
            headItem = legItem;
        } else {
            headItem = items[0];
            torsoItem = items[1];
            armItem = items[2];
            legItem = items[3];
        }
        this.headRecipe = new Object[]{"SSSS", "SBFS", "SEES", Character.valueOf('S'), new ye(this.organs, 1, 4), Character.valueOf('E'), yc.bw, Character.valueOf('F'), headItem, Character.valueOf('B'), new ye(this.organs, 1, 0)};
        this.torsoRecipe = new Object[]{" LL ", "BHUB", "LEEL", "BLLB", Character.valueOf('L'), new ye(this.organs, 1, 4), Character.valueOf('E'), torsoItem, Character.valueOf('H'), new ye(this.organs, 1, 1), Character.valueOf('U'), new ye(this.organs, 1, 3), Character.valueOf('B'), yc.aZ};
        this.armRecipe = new Object[]{"LLLL", "BMEB", "LLLL", Character.valueOf('L'), new ye(this.organs, 1, 4), Character.valueOf('E'), armItem, Character.valueOf('M'), new ye(this.organs, 1, 2), Character.valueOf('B'), yc.aZ};
        this.legRecipe = new Object[]{"LBBL", "LMML", "LEEL", "LBBL", Character.valueOf('L'), new ye(this.organs, 1, 4), Character.valueOf('E'), legItem, Character.valueOf('M'), new ye(this.organs, 1, 2), Character.valueOf('B'), yc.aZ};
    }

    public BodyPart[] initHead(bbo model) {
        return null;
    }

    public BodyPart[] initTorso(bbo model) {
        return null;
    }

    public BodyPart[] initLegs(bbo model) {
        return null;
    }

    public BodyPart[] initArmLeft(bbo model) {
        return null;
    }

    public BodyPart[] initArmRight(bbo model) {
        return null;
    }

    public NecroEntityBase updateParts(bbo model) {
        this.head = this.initHead(model);
        this.torso = this.initTorso(model);
        this.armLeft = this.initArmLeft(model);
        this.armRight = this.initArmRight(model);
        this.legs = this.initLegs(model);
        return this;
    }

    public void setAttributes(of minion, BodyPartLocation location) {
    }

    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn entity, BodyPart[] part, BodyPartLocation location) {
    }

    @SideOnly(value=Side.CLIENT)
    public void preRender(nn entity, BodyPart[] parts, BodyPartLocation location, bbo model) {
    }

    @SideOnly(value=Side.CLIENT)
    public void postRender(nn entity, BodyPart[] parts, BodyPartLocation location, bbo model) {
    }

    @Deprecated
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn entity, BodyPart[] part, String location) {
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public void preRender(nn entity, BodyPart[] parts, String location, bbo model) {
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public void postRender(nn entity, BodyPart[] parts, String location, bbo model) {
    }
}

