/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityBase;

public abstract class NecroEntityBiped
extends NecroEntityBase {
    public NecroEntityBiped(String mobName) {
        super(mobName);
        this.mobName = mobName;
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart head = new BodyPart(this, model, 0, 0);
        head.a(-4.0f, -4.0f, -4.0f, 8, 8, 8, 0.0f);
        head.b(this.textureWidth, this.textureHeight);
        BodyPart headWear = new BodyPart(this, model, 32, 0);
        headWear.a(-4.0f, -4.0f, -4.0f, 8, 8, 8, 0.5f);
        headWear.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{head, headWear};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, -4.0f, 2.0f};
        float[] armLeftPos = new float[]{-4.0f, 0.0f, 2.0f};
        float[] armRightPos = new float[]{8.0f, 0.0f, 2.0f};
        BodyPart torso = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 16, 16);
        torso.a(0.0f, 0.0f, 0.0f, 8, 12, 4, 0.0f);
        torso.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{torso};
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        BodyPart armLeft = new BodyPart(this, model, 40, 16);
        armLeft.a(0.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
        armLeft.b(this.textureWidth, this.textureHeight);
        armLeft.i = true;
        return new BodyPart[]{armLeft};
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        BodyPart armRight = new BodyPart(this, model, 40, 16);
        armRight.a(0.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
        armRight.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{armRight};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, -2.0f, -2.0f};
        BodyPart legLeft = new BodyPart(this, torsoPos, model, 0, 16);
        legLeft.a(-4.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f);
        legLeft.a(0.0f, 12.0f, 0.0f);
        BodyPart legRight = new BodyPart(this, torsoPos, model, 0, 16);
        legRight.a(0.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f);
        legRight.a(0.0f, 12.0f, 0.0f);
        legLeft.b(this.textureWidth, this.textureHeight);
        legRight.b(this.textureWidth, this.textureHeight);
        legLeft.i = true;
        return new BodyPart[]{legLeft, legRight};
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn par7Entity, BodyPart[] bodypart, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            bodypart[0].g = par4 / 57.295776f;
            bodypart[0].f = par5 / 57.295776f;
            bodypart[1].g = par4 / 57.295776f;
            bodypart[1].f = par5 / 57.295776f;
        }
        if (location == BodyPartLocation.ArmLeft) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.5f;
            bodypart[0].h = 0.0f;
        }
        if (location == BodyPartLocation.ArmRight) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f + (float)Math.PI)) * 2.0f * par2 * 0.5f;
            bodypart[0].h = 0.0f;
        }
        if (location == BodyPartLocation.Legs) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f)) * 1.4f * par2;
            bodypart[1].f = ls.b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
            bodypart[0].g = 0.0f;
            bodypart[1].g = 0.0f;
        }
    }
}

