/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityBase;
import org.lwjgl.opengl.GL11;

public abstract class NecroEntityQuadruped
extends NecroEntityBase {
    public int size = 12;

    public NecroEntityQuadruped(String mobName, int size) {
        super(mobName);
        this.mobName = mobName;
        this.size = size;
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart head = new BodyPart(this, model, 0, 0);
        head.a(-4.0f, -4.0f, -4.0f, 8, 8, 8, 0.0f);
        head.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{head};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, 12 - this.size, -14.0f};
        float[] armLeftPos = new float[]{-1.0f, 12.0f, -10.0f};
        float[] armRightPos = new float[]{5.0f, 12.0f, -10.0f};
        BodyPart torso = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 28, 8);
        torso.a(-1.0f, -12.0f, -12.0f, 10, 16, 8, 0.0f);
        torso.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{torso};
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        BodyPart armLeft = new BodyPart(this, model, 0, 16);
        armLeft.a(0.0f, 0.0f, -1.0f, 4, this.size, 4, 0.0f);
        armLeft.b(this.textureWidth, this.textureHeight);
        armLeft.i = true;
        return new BodyPart[]{armLeft};
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        BodyPart armRight = new BodyPart(this, model, 0, 16);
        armRight.a(0.0f, 0.0f, -1.0f, 4, this.size, 4, 0.0f);
        armRight.b(this.textureWidth, this.textureHeight);
        return new BodyPart[]{armRight};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, 4.0f, 0.0f};
        BodyPart legLeft = new BodyPart(this, torsoPos, model, 0, 16);
        legLeft.a(-2.0f, 0.0f, -2.0f, 4, this.size, 4, 0.0f);
        legLeft.a(-3.0f, 22.0f - (float)this.size, 3.0f);
        BodyPart legRight = new BodyPart(this, torsoPos, model, 0, 16);
        legRight.a(-2.0f, 0.0f, -2.0f, 4, this.size, 4, 0.0f);
        legRight.a(3.0f, 22.0f - (float)this.size, 3.0f);
        legLeft.b(this.textureWidth, this.textureHeight);
        legRight.b(this.textureWidth, this.textureHeight);
        legLeft.i = true;
        return new BodyPart[]{legLeft, legRight};
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn par7Entity, BodyPart[] bodypart, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            bodypart[0].f = par5 / 57.295776f;
            bodypart[0].g = par5 / 57.295776f;
        }
        if (location == BodyPartLocation.Torso) {
            bodypart[0].f = 1.5707964f;
        }
        if (location == BodyPartLocation.ArmLeft) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
            bodypart[0].h = 0.0f;
        }
        if (location == BodyPartLocation.ArmRight) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f)) * 1.4f * par2;
            bodypart[0].h = 0.0f;
        }
        if (location == BodyPartLocation.Legs) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f)) * 1.4f * par2;
            bodypart[1].f = ls.b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
            bodypart[0].g = 0.0f;
            bodypart[1].g = 0.0f;
        }
    }

    @Override
    public void preRender(nn entity, BodyPart[] parts, BodyPartLocation location, bbo model) {
        if (entity.v().a(16) == 1 && location == BodyPartLocation.Torso) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)1.0f);
        }
    }
}

