/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy;

import com.sirolf2009.necroapi.NecroEntityBase;
import com.sirolf2009.necromancy.block.BlockNecromancy;
import com.sirolf2009.necromancy.core.handler.EventHandler;
import com.sirolf2009.necromancy.core.handler.PacketHandler;
import com.sirolf2009.necromancy.core.proxy.CommonProxy;
import com.sirolf2009.necromancy.creativetab.CreativeTabNecro;
import com.sirolf2009.necromancy.entity.EntityNecromancy;
import com.sirolf2009.necromancy.generation.WorldGenerator;
import com.sirolf2009.necromancy.generation.villagecomponent.ComponentVillageCemetery;
import com.sirolf2009.necromancy.item.ItemNecroSkull;
import com.sirolf2009.necromancy.item.ItemNecromancy;
import com.sirolf2009.necromancy.lib.ConfigurationNecromancy;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Logger;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.ARBShaderObjects;

@Mod(modid="necromancy", name="Necromancy", version="1.4c")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, channels={"NecromancyMod"}, packetHandler=PacketHandler.class)
public class Necromancy {
    public static final ww tabNecromancy = new CreativeTabNecro(ww.getNextID(), "Necromancy", 1).a("necro_gui.png");
    public static final ww tabNecromancyBodyParts = new CreativeTabNecro(ww.getNextID(), "BodyParts", 2).a("necro_gui.png");
    public int scentProgram;
    public static List<String> specialFolk = new ArrayList<String>();
    public static int maxSpawn = -1;
    public static Logger loggerNecromancy;
    public static PacketHandler PacketHandler;
    public static EventHandler EventHandler;
    @SidedProxy(clientSide="com.sirolf2009.necromancy.core.proxy.ClientProxy", serverSide="com.sirolf2009.necromancy.core.proxy.CommonProxy")
    public static CommonProxy Proxy;
    @Mod.Instance(value="necromancy")
    public static Necromancy Instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        loggerNecromancy = Logger.getLogger("necromancy");
        loggerNecromancy.setParent(FMLLog.getLogger());
        ConfigurationNecromancy.initProperties(event);
        NecroEntityBase.organID = ConfigurationNecromancy.OrgansID;
        MinecraftForge.EVENT_BUS.register((Object)EventHandler);
        try {
            URL url = new URL("https://dl.dropboxusercontent.com/u/50553915/necromancy/specialFolk.txt");
            Scanner s2 = new Scanner(url.openStream());
            while (s2.hasNext()) {
                specialFolk.add(s2.nextLine());
            }
            s2.close();
        }
        catch (IOException e) {
            System.err.println("not connected to the internet, special scythes are de-activated");
        }
        if (ConfigurationNecromancy.InitDuringPreInit) {
            this.init();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!ConfigurationNecromancy.InitDuringPreInit) {
            this.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ItemNecroSkull.initSkulls();
        Proxy.refreshTextures();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        EventHandler.initCommands(event);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (new File("server.properties").exists()) {
            hq manager = new hq(new File("server.properties"), null);
            maxSpawn = manager.a("max_minion_spawn", -1);
        }
    }

    private void init() {
        LanguageRegistry.instance().addStringLocalization("itemGroup.Necromancy", "en_US", "Necromancy");
        LanguageRegistry.instance().addStringLocalization("itemGroup.BodyParts", "en_US", "Bodyparts");
        ItemNecromancy.initItems();
        EntityNecromancy.initEntities();
        BlockNecromancy.initBlocks();
        Proxy.init();
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)PacketHandler);
        ArrayList<Class<PacketHandler>> villageComponentsList = new ArrayList<Class<PacketHandler>>();
        villageComponentsList.add(PacketHandler.class);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerator());
        air.a(ComponentVillageCemetery.class, (String)"necromancy:CemetaryComponent");
    }

    private int createShader(String filename, int shaderType) throws Exception {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)this.readFileAsString(filename));
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + ARBShaderObjects.glGetInfoLogARB((int)shader, (int)ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35716)));
            }
            return shader;
        }
        catch (Exception exc) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            throw exc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFileAsString(String filename) throws Exception {
        StringBuilder source;
        block27: {
            source = new StringBuilder();
            FileInputStream in = new FileInputStream(this.getClass().getClassLoader().getResource(filename).toURI().getPath());
            Exception exception = null;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
                Exception innerExc = null;
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        source.append(line).append('\n');
                    }
                }
                catch (Exception exc) {
                    exception = exc;
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (Exception exc) {
                        if (innerExc == null) {
                            innerExc = exc;
                        }
                        exc.printStackTrace();
                    }
                }
                if (innerExc != null) {
                    throw innerExc;
                }
            }
            catch (Exception exc) {
                exception = exc;
                return exception;
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    if (exception == null) {
                        exception = exc;
                    }
                    exc.printStackTrace();
                }
                if (exception == null) break block27;
                throw exception;
            }
        }
        return source.toString();
    }

    static {
        PacketHandler = new PacketHandler();
        EventHandler = new EventHandler();
    }
}

