/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.NecroEntityBase;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntityChicken
extends NecroEntityBase {
    public NecroEntityChicken() {
        super("Chicken");
        this.headItem = ItemBodyPart.getItemStackFromName("Chicken Head", 1);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Chicken Torso", 1);
        this.armItem = ItemBodyPart.getItemStackFromName("Chicken Arm", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Chicken Legs", 1);
        this.texture = new bjo("textures/entity/chicken.png");
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(yc.bm);
    }

    @Override
    public BodyPart[] initHead(bbo model) {
        BodyPart head = new BodyPart(this, model, 0, 0);
        head.a(-2.0f, -2.0f, -2.0f, 4, 6, 3, 0.0f);
        BodyPart bill = new BodyPart(this, model, 14, 0);
        bill.a(-2.0f, 0.0f, -4.0f, 4, 2, 2, 0.0f);
        BodyPart chin = new BodyPart(this, model, 14, 4);
        chin.a(-1.0f, 2.0f, -3.0f, 2, 2, 2, 0.0f);
        return new BodyPart[]{head, bill, chin};
    }

    @Override
    public BodyPart[] initTorso(bbo model) {
        float[] headPos = new float[]{4.0f, 4.0f, -2.0f};
        float[] armLeftPos = new float[]{-3.0f, 6.0f, 2.0f};
        float[] armRightPos = new float[]{7.0f, 6.0f, 2.0f};
        BodyPart torso = new BodyPart(this, armLeftPos, armRightPos, headPos, model, 0, 9);
        torso.a(1.0f, -2.0f, -12.0f, 6, 8, 6, 0.0f);
        return new BodyPart[]{torso};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-3.0f, 8.0f, 0.0f};
        BodyPart rightLeg = new BodyPart(this, torsoPos, model, 26, 0);
        rightLeg.a(-1.5f, -1.0f, -1.0f, 3, 5, 3);
        rightLeg.a(0.0f, 19.0f, 0.0f);
        BodyPart leftLeg = new BodyPart(this, torsoPos, model, 26, 0);
        leftLeg.a(0.5f, -1.0f, -1.0f, 3, 5, 3);
        leftLeg.a(-0.0f, 19.0f, 0.0f);
        return new BodyPart[]{leftLeg, rightLeg};
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        BodyPart leftWing = new BodyPart(this, model, 24, 13);
        leftWing.a(3.0f, 0.0f, -3.0f, 1, 4, 6);
        return new BodyPart[]{leftWing};
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        BodyPart rightWing = new BodyPart(this, model, 24, 13);
        rightWing.a(0.0f, 0.0f, -3.0f, 1, 4, 6);
        return new BodyPart[]{rightWing};
    }

    @Override
    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6, nn par7Entity, BodyPart[] bodypart, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            bodypart[0].g = par4 / 57.295776f;
            bodypart[0].f = par5 / 57.295776f;
            bodypart[1].g = par4 / 57.295776f;
            bodypart[1].f = par5 / 57.295776f;
            bodypart[2].g = par4 / 57.295776f;
            bodypart[2].f = par5 / 57.295776f;
        }
        if (location == BodyPartLocation.Legs) {
            bodypart[0].f = ls.b((float)(par1 * 0.6662f)) * 1.4f * par2;
            bodypart[1].f = ls.b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
            bodypart[0].g = 0.0f;
            bodypart[1].g = 0.0f;
        }
        if (location == BodyPartLocation.Torso) {
            bodypart[0].f = 1.5707964f;
        }
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(0.5);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(2.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.ArmLeft) {
            this.armLeft[0].attributes.b(tp.a).a(0.5);
            this.armLeft[0].attributes.b(tp.b).a(0.0);
            this.armLeft[0].attributes.b(tp.c).a(0.0);
            this.armLeft[0].attributes.b(tp.d).a(0.0);
            this.armLeft[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.ArmRight) {
            this.armRight[0].attributes.b(tp.a).a(0.5);
            this.armRight[0].attributes.b(tp.b).a(0.0);
            this.armRight[0].attributes.b(tp.c).a(0.0);
            this.armRight[0].attributes.b(tp.d).a(0.0);
            this.armRight[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(0.5);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.25);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

