/*
 * Decompiled with CFR 0.152.
 */
package com.sirolf2009.necromancy.entity.necroapi;

import com.sirolf2009.necroapi.BodyPart;
import com.sirolf2009.necroapi.BodyPartLocation;
import com.sirolf2009.necroapi.ISkull;
import com.sirolf2009.necroapi.NecroEntityBiped;
import com.sirolf2009.necromancy.item.ItemBodyPart;

public class NecroEntitySkeleton
extends NecroEntityBiped
implements ISkull {
    public NecroEntitySkeleton() {
        super("Skeleton");
        this.headItem = new ye(yc.bS);
        this.torsoItem = ItemBodyPart.getItemStackFromName("Skeleton Torso", 1);
        this.armItem = ItemBodyPart.getItemStackFromName("Skeleton Arm", 1);
        this.legItem = ItemBodyPart.getItemStackFromName("Skeleton Legs", 1);
        this.texture = new bjo("textures/entity/skeleton/skeleton.png");
    }

    @Override
    public void initRecipes() {
        this.initDefaultRecipes(yc.aZ);
    }

    @Override
    public BodyPart[] initArmLeft(bbo model) {
        BodyPart armLeft = new BodyPart(this, model, 40, 16);
        armLeft.a(2.0f, 0.0f, -1.0f, 2, 12, 2, 0.0f);
        armLeft.i = true;
        return new BodyPart[]{armLeft};
    }

    @Override
    public BodyPart[] initArmRight(bbo model) {
        BodyPart armRight = new BodyPart(this, model, 40, 16);
        armRight.a(0.0f, 0.0f, -1.0f, 2, 12, 2, 0.0f);
        return new BodyPart[]{armRight};
    }

    @Override
    public BodyPart[] initLegs(bbo model) {
        float[] torsoPos = new float[]{-4.0f, -2.0f, -2.0f};
        BodyPart legLeft = new BodyPart(this, torsoPos, model, 0, 16);
        legLeft.a(-3.0f, -2.0f, -1.0f, 2, 12, 2, 0.0f);
        legLeft.a(0.0f, 12.0f, 0.0f);
        BodyPart legRight = new BodyPart(this, torsoPos, model, 0, 16);
        legRight.a(1.0f, -2.0f, -1.0f, 2, 12, 2, 0.0f);
        legRight.a(0.0f, 12.0f, 0.0f);
        legLeft.i = true;
        return new BodyPart[]{legLeft, legRight};
    }

    @Override
    public String getSkullModelTexture() {
        return "/mob/skeleton.png";
    }

    @Override
    public String getSkullIconTexture() {
        return "skull_skeleton";
    }

    @Override
    public void setAttributes(of minion, BodyPartLocation location) {
        if (location == BodyPartLocation.Head) {
            this.head[0].attributes.b(tp.a).a(2.0);
            this.head[0].attributes.b(tp.b).a(16.0);
            this.head[0].attributes.b(tp.c).a(0.0);
            this.head[0].attributes.b(tp.d).a(0.0);
            this.head[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.Torso) {
            this.torso[0].attributes.b(tp.a).a(12.0);
            this.torso[0].attributes.b(tp.b).a(0.0);
            this.torso[0].attributes.b(tp.c).a(0.0);
            this.torso[0].attributes.b(tp.d).a(0.0);
            this.torso[0].attributes.b(tp.e).a(0.0);
        } else if (location == BodyPartLocation.ArmLeft) {
            this.armLeft[0].attributes.b(tp.a).a(2.0);
            this.armLeft[0].attributes.b(tp.b).a(0.0);
            this.armLeft[0].attributes.b(tp.c).a(0.0);
            this.armLeft[0].attributes.b(tp.d).a(0.0);
            this.armLeft[0].attributes.b(tp.e).a(1.0);
        } else if (location == BodyPartLocation.ArmRight) {
            this.armRight[0].attributes.b(tp.a).a(2.0);
            this.armRight[0].attributes.b(tp.b).a(0.0);
            this.armRight[0].attributes.b(tp.c).a(0.0);
            this.armRight[0].attributes.b(tp.d).a(0.0);
            this.armRight[0].attributes.b(tp.e).a(1.0);
        } else if (location == BodyPartLocation.Legs) {
            this.legs[0].attributes.b(tp.a).a(2.0);
            this.legs[0].attributes.b(tp.b).a(0.0);
            this.legs[0].attributes.b(tp.c).a(0.0);
            this.legs[0].attributes.b(tp.d).a(0.25);
            this.legs[0].attributes.b(tp.e).a(0.0);
        }
    }
}

