/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.StatCollector;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeConfig;
import shukaro.artifice.ArtificeItems;
import shukaro.artifice.compat.ArtificeRegistry;
import shukaro.artifice.recipe.EnumUpgrades;
import shukaro.artifice.util.FormatCodes;
import shukaro.artifice.util.RomanUtil;

public class ArtificeTooltips {
    public static final String commentCode = FormatCodes.DarkGrey.code + FormatCodes.Italic.code;

    public static String localizeTooltip(String name, Boolean flavor) {
        return flavor != false ? commentCode + StatCollector.func_74838_a((String)("tooltip.artifice." + name + ".flavor")) : StatCollector.func_74838_a((String)("tooltip.artifice." + name));
    }

    public static void initTooltips() {
        ArtificeTooltips.initBlockTooltips();
        ArtificeTooltips.initItemTooltips();
    }

    private static void initItemTooltips() {
        if (ArtificeConfig.enableWorldGen.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("dye.blue", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("dye.blue", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("dye.black", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("dye.black", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 2, ArtificeTooltips.localizeTooltip("dye.brown", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 2, ArtificeTooltips.localizeTooltip("dye.brown", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 3, ArtificeTooltips.localizeTooltip("dye.white", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemDye.field_77779_bT, 3, ArtificeTooltips.localizeTooltip("dye.white", true));
        }
        if (ArtificeConfig.enableSledges.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeWood.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeWood.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 50%");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeWood.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeStone.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeStone.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 40%");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeStone.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeIron.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeIron.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 30%");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeIron.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeGold.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeGold.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 25%");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeGold.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeDiamond.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeDiamond.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sledge.loss", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 20%");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSledgeDiamond.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sledge", true));
        }
        if (ArtificeConfig.enableSickles.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleWood.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleWood.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 1");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleWood.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle.wood", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleStone.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleStone.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 2");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleStone.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle.stone", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleIron.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleIron.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 3");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleIron.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle.iron", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleGold.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleGold.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 4");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleGold.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle.gold", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleDiamond.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleDiamond.field_77779_bT, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("sickle.radius", false) + FormatCodes.Reset.code + FormatCodes.Aqua.code + " 5");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSickleDiamond.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("sickle.diamond", true));
        }
        if (ArtificeConfig.enableSteel.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSteelIngot.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("steel.ingot", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSteelIngot.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("steel.ingot", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSteelIngot.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("steel.dust", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemSteelIngot.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("steel.dust", true));
        }
        if (ArtificeConfig.enableBoxes.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeItems.itemBox.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("box", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemBox.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("box", true));
        }
        if (ArtificeConfig.enableUpgrades.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("upgrade.type.toolweapon", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 0, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77349_p.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.SharpeningKitS.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77338_j.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 0, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77338_j.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.SharpeningKitE.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77349_p.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("upgrade.sharpener", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("upgrade.type.universal", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 1, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77347_r.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.Reinforcement.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77347_r.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("upgrade.reinforcement", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 2, ArtificeTooltips.localizeTooltip("upgrade.type.bow", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 2, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77344_u.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.ReinforcedLimbs.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77344_u.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 2, ArtificeTooltips.localizeTooltip("upgrade.reinforcedlimbs", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 3, ArtificeTooltips.localizeTooltip("upgrade.type.bow", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 3, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77345_t.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.PlaitedString.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77345_t.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 3, ArtificeTooltips.localizeTooltip("upgrade.plaited", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 4, ArtificeTooltips.localizeTooltip("upgrade.type.weapon", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 4, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77337_m.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.Counterweight.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77337_m.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 4, ArtificeTooltips.localizeTooltip("upgrade.counterweight", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 5, ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 5, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_92091_k.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.ArmorSpikes.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_92091_k.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 5, ArtificeTooltips.localizeTooltip("upgrade.spikes", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 6, ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 6, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77332_c.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.LaminatedPadding.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77332_c.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 6, ArtificeTooltips.localizeTooltip("upgrade.lamination", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 7, ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 7, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77328_g.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.QuiltedCover.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77328_g.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 7, ArtificeTooltips.localizeTooltip("upgrade.cover", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 8, ArtificeTooltips.localizeTooltip("upgrade.type.boot", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 8, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77330_e.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.ElasticSoles.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77330_e.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 8, ArtificeTooltips.localizeTooltip("upgrade.soles", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 9, ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 9, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77329_d.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.Firedamp.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77329_d.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 9, ArtificeTooltips.localizeTooltip("upgrade.firedamp", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 10, ArtificeTooltips.localizeTooltip("upgrade.type.armor", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 10, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77327_f.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.ElasticLayering.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77327_f.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 10, ArtificeTooltips.localizeTooltip("upgrade.layering", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 11, ArtificeTooltips.localizeTooltip("upgrade.type.helmet", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 11, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77340_h.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.ScubaTank.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77340_h.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 11, ArtificeTooltips.localizeTooltip("upgrade.tank", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 12, ArtificeTooltips.localizeTooltip("upgrade.type.helmet", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 12, FormatCodes.Yellow.code + StatCollector.func_74838_a((String)Enchantment.field_77341_i.func_77320_a()) + " (" + (ArtificeConfig.limitUpgrades.getBoolean(true) ? RomanUtil.convertToRoman(EnumUpgrades.DiveKit.maxLevel) : RomanUtil.convertToRoman(Enchantment.field_77341_i.func_77325_b())) + ")");
            ArtificeRegistry.registerTooltip(ArtificeItems.itemUpgrade.field_77779_bT, 12, ArtificeTooltips.localizeTooltip("upgrade.divekit", true));
        }
    }

    private static void initBlockTooltips() {
        if (ArtificeConfig.enableWorldGen.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("lotus", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("lotus.close", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("lotus", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockLotus.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("lotus.close", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockLotus.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("lily", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("bluebell", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("bluebell", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("orchid", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("orchid", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("iris", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFlora.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("iris", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected.snug", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected.snug", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 4, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 4, ArtificeTooltips.localizeTooltip("connected.carving", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 4, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 4, ArtificeTooltips.localizeTooltip("connected.carving", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltSlab.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltSlab.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("connected.snug", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleSlab.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleSlab.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("connected.snug", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltSlab.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltSlab.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected.carving", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleSlab.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleSlab.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("connected.carving", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("volcanic", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("basalt.smooth", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("basalt.cobble", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("basalt.brick", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasalt.field_71990_ca, 5, ArtificeTooltips.localizeTooltip("basalt.chiseled", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("metamorphic", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("marble.smooth", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("marble.cobble", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("marble.brick", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarble.field_71990_ca, 5, ArtificeTooltips.localizeTooltip("marble.chiseled", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltBrickStairs.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("basalt.brick.stairs", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleBrickStairs.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("marble.brick.stairs", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltCobbleStairs.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("basalt.cobble.stairs", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleCobbleStairs.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("marble.cobble.stairs", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltSlab.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("basalt.brick.slab", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleSlab.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("marble.brick.slab", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockBasaltSlab.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("basalt.cobble.slab", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockMarbleSlab.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("marble.cobble.slab", true));
        }
        if (ArtificeConfig.enableFrames.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockDetector.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("detector", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockDetector.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("detector", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("frame.basic", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("frame.basic", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("frame.reinforced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("frame.reinforced", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("frame.industrial", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("frame.industrial", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("frame.advanced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockFrame.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("frame.advanced", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("glasswall.basic", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(0));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("glasswall.basic", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("glasswall.reinforced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 1, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(1));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("glasswall.reinforced", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("glasswall.industrial", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 2, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(2));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("glasswall.industrial", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("glasswall.advanced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 3, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockGlassWall.getResistance(3));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockGlassWall.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("glasswall.advanced", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("blastwall.basic", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(0));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("blastwall.basic", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("blastwall.reinforced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 1, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(1));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("blastwall.reinforced", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("blastwall.industrial", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 2, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(2));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("blastwall.industrial", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("blastwall.advanced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 3, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("resistance", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + (int)ArtificeBlocks.blockReinforced.getResistance(3));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockReinforced.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("blastwall.advanced", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("scaffold.basic", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 0, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(0));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("scaffold.basic", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("scaffold.reinforced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 1, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(1));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 1, ArtificeTooltips.localizeTooltip("scaffold.reinforced", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("scaffold.industrial", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 2, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(2));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 2, ArtificeTooltips.localizeTooltip("scaffold.industrial", true));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("scaffold.advanced", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 3, FormatCodes.Italic.code + ArtificeTooltips.localizeTooltip("overhang", false) + " " + FormatCodes.Reset.code + FormatCodes.Aqua.code + ArtificeBlocks.blockScaffold.getOverhang(3));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockScaffold.field_71990_ca, 3, ArtificeTooltips.localizeTooltip("scaffold.advanced", true));
        }
        if (ArtificeConfig.enableSteel.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockSteel.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("steel.ingot", false));
            ArtificeRegistry.registerTooltip(ArtificeBlocks.blockSteel.field_71990_ca, 0, ArtificeTooltips.localizeTooltip("steel.ingot", true));
        }
        if (ArtificeConfig.enableCoins.getBoolean(true)) {
            ArtificeRegistry.registerTooltip(ArtificeItems.itemNugget.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("nugget.copper", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemNugget.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("nugget.silver", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemNugget.field_77779_bT, 2, ArtificeTooltips.localizeTooltip("nugget.platinum", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("coin.copper", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 0, ArtificeTooltips.localizeTooltip("coin.copper", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("coin.silver", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 1, ArtificeTooltips.localizeTooltip("coin.silver", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 2, ArtificeTooltips.localizeTooltip("coin.gold", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 2, ArtificeTooltips.localizeTooltip("coin.gold", true));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 3, ArtificeTooltips.localizeTooltip("coin.platinum", false));
            ArtificeRegistry.registerTooltip(ArtificeItems.itemCoin.field_77779_bT, 3, ArtificeTooltips.localizeTooltip("coin.platinum", true));
        }
    }
}

