/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.compat.thaumcraft;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.ArtificeItems;

@Mod(modid="ArtificeCompat|Thaumcraft", name="Artifice Compat: Thaumcraft", version="1.6.4R1.1.3", dependencies="after:Artifice;after:Thaumcraft")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Thaumcraft {
    private static LinkedHashMap<String, ? extends Object> aspects = null;
    private static Method registerItem = null;
    private static Method registerEntity = null;
    private static Class<?> AspectList = null;
    private static Constructor<?> newAspectList = null;
    private static Method addAspect = null;

    @Mod.EventHandler
    public static void load(FMLInitializationEvent e0) {
        if (!Loader.isModLoaded((String)"Thaumcraft")) {
            ArtificeCore.logger.log(Level.INFO, "Thaumcraft not installed, skipping compat");
            return;
        }
        try {
            Class<?> Aspect = Class.forName("thaumcraft.api.aspects.Aspect");
            aspects = (LinkedHashMap)Aspect.getDeclaredField("aspects").get(null);
            Class<?> ThaumcraftApi = Class.forName("thaumcraft.api.ThaumcraftApi");
            AspectList = Class.forName("thaumcraft.api.aspects.AspectList");
            registerItem = ThaumcraftApi.getDeclaredMethod("registerObjectTag", Integer.TYPE, Integer.TYPE, AspectList);
            registerEntity = ThaumcraftApi.getDeclaredMethod("registerEntityTag", String.class, AspectList, NBTBase[].class);
            addAspect = AspectList.getDeclaredMethod("add", Aspect, Integer.TYPE);
            newAspectList = AspectList.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            Thaumcraft.doAspects();
            ArtificeCore.logger.log(Level.INFO, "Thaumcraft Compat Initialized");
        }
        catch (Throwable ex) {
            ArtificeCore.logger.log(Level.WARNING, "Couldn't initialize Thaumcraft compat");
            ex.printStackTrace();
        }
    }

    private static void parseAspects(ItemStack item, String toadd, boolean craftedAspects) throws Throwable {
        String[] list = toadd.split(",");
        Object aspectList = craftedAspects ? newAspectList.newInstance(item.field_77993_c, item.func_77960_j()) : AspectList.newInstance();
        int i = list.length;
        while (i-- > 0) {
            String[] temp = list[i].trim().split(" ");
            temp[1] = temp[1].toLowerCase();
            if (aspects.containsKey(temp[1])) {
                addAspect.invoke(aspectList, aspects.get(temp[1]), Integer.parseInt(temp[0], 10));
                continue;
            }
            FMLLog.severe((String)"%s aspect missing.", (Object[])new Object[]{temp[1]});
        }
        registerItem.invoke(null, item.field_77993_c, item.func_77960_j(), aspectList);
    }

    private static void parseAspects(String entity, String toadd) throws Throwable {
        String[] list = toadd.split(",");
        Object aspectList = AspectList.newInstance();
        int i = list.length;
        while (i-- > 0) {
            String[] temp = list[i].trim().split(" ");
            temp[1] = temp[1].toLowerCase();
            if (!aspects.containsKey(temp[1])) continue;
            addAspect.invoke(aspectList, aspects.get(temp[1]), Integer.parseInt(temp[0], 10));
        }
        registerEntity.invoke(null, entity, aspectList, null);
    }

    private static void parseAspects(Item item, String toadd) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(item, 1, 0), toadd, false);
    }

    private static void parseAspects(Item item, int meta, String toadd) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(item, 1, meta), toadd, false);
    }

    private static void parseAspects(Block item, int meta, String toadd) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(item, 1, meta), toadd, false);
    }

    private static void parseAspects(Block item, String toadd) throws Throwable {
        Thaumcraft.parseAspects(item, 0, toadd);
    }

    private static void parseAspects(Block item, int meta, String toadd, boolean craftedAspects) throws Throwable {
        Thaumcraft.parseAspects(new ItemStack(item, 1, meta), toadd, craftedAspects);
    }

    private static void parseAspects(Block item, String toadd, boolean craftedAspects) throws Throwable {
        Thaumcraft.parseAspects(item, 0, toadd, craftedAspects);
    }

    private static void doAspects() throws Throwable {
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFrame, 0, "1 Arbor, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFrame, 1, "1 Arbor, 1 Metallum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFrame, 2, "2 Metallum, 2 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFrame, 3, "2 Metallum, 2 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFlora, 0, "1 Sensus, 1 Herba");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFlora, 1, "1 Sensus, 1 Herba");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFlora, 2, "1 Sensus, 1 Herba");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockFlora, 3, "1 Sensus, 1 Herba");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockLotus, "1 Sensus, 1 Herba, 1 Aqua");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasalt, 0, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasalt, 1, "1 Saxum, 1 Perditio");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasalt, 2, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasalt, 3, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasalt, 4, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasalt, 5, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarble, 0, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarble, 1, "1 Saxum, 1 Perditio");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarble, 2, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarble, 3, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarble, 4, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarble, 5, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasaltBrickStairs, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasaltCobbleStairs, "1 Saxum, 1 Perditio");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarbleBrickStairs, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarbleCobbleStairs, "1 Saxum, 1 Perditio");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasaltSlab, 0, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasaltSlab, 1, "1 Saxum, 1 Perditio");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasaltSlab, 2, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockBasaltSlab, 3, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarbleSlab, 0, "1 Saxum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarbleSlab, 1, "1 Saxum, 1 Perditio");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarbleSlab, 2, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockMarbleSlab, 3, "1 Saxum, 1 Ordo");
        Thaumcraft.parseAspects(ArtificeBlocks.blockDetector, "2 Sensus, 2 Machina, 2 Metallum, 2 Arbor");
        Thaumcraft.parseAspects(ArtificeItems.itemSteelIngot, 0, "6 Metallum");
        Thaumcraft.parseAspects(ArtificeItems.itemSteelIngot, 1, "3 Metallum, 3 Ignis");
        Thaumcraft.parseAspects(ArtificeBlocks.blockSteel, "18 Metallum");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockReinforced, 0, "4 Saxum, 1 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockReinforced, 1, "4 Saxum, 2 Ordo, 1 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockReinforced, 2, "4 Saxum, 2 Ignis, 2 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockReinforced, 3, "4 Metallum, 2 Ordo, 2 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockGlassWall, 0, "3 Saxum, 1 Vitreus, 1 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockGlassWall, 1, "3 Saxum, 1 Vitreus, 2 Ordo, 1 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockGlassWall, 2, "3 Saxum, 1 Vitreus, 2 Ignis, 2 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockGlassWall, 3, "4 Metallum, 1 Vitreus, 2 Ordo, 2 Tutamen");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockScaffold, 0, "2 Motus, 1 Arbor, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockScaffold, 1, "2 Motus, 1 Arbor, 1 Metallum, 1 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockScaffold, 2, "2 Motus, 2 Metallum, 2 Ordo");
        Thaumcraft.parseAspects((Block)ArtificeBlocks.blockScaffold, 3, "2 Motus, 2 Metallum, 2 Ordo");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSledgeWood, "4 Instrumentum, 2 Perditio, 2 Arbor");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSledgeStone, "4 Instrumentum, 2 Perditio, 2 Saxum");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSledgeIron, "4 Instrumentum, 2 Perditio, 2 Metallum");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSledgeGold, "4 Instrumentum, 2 Perditio, 2 Lucrum");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSledgeDiamond, "4 Instrumentum, 2 Perditio, 2 Vitreus");
        Thaumcraft.parseAspects(ArtificeItems.itemBox, "3 Arbor, 2 Vacuos");
        Thaumcraft.parseAspects(ArtificeItems.itemDye, 0, "1 Sensus, 1 Permutatio");
        Thaumcraft.parseAspects(ArtificeItems.itemDye, 1, "1 Sensus, 1 Permutatio");
        Thaumcraft.parseAspects(ArtificeItems.itemDye, 2, "1 Sensus, 1 Permutatio");
        Thaumcraft.parseAspects(ArtificeItems.itemDye, 3, "1 Sensus, 1 Permutatio");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSickleWood, "4 Instrumentum, 2 Meto, 2 Arbor");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSickleStone, "4 Instrumentum, 2 Meto, 2 Saxum");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSickleIron, "4 Instrumentum, 2 Meto, 2 Metallum");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSickleGold, "4 Instrumentum, 2 Meto, 2 Lucrum");
        Thaumcraft.parseAspects((Item)ArtificeItems.itemSickleDiamond, "4 Instrumentum, 2 Meto, 2 Vitreus");
        Thaumcraft.parseAspects(ArtificeItems.itemNugget, 0, "1 Metallum, 1 Victus");
        Thaumcraft.parseAspects(ArtificeItems.itemNugget, 0, "1 Metallum, 1 Sensus");
        Thaumcraft.parseAspects(ArtificeItems.itemNugget, 0, "1 Metallum, 1 Vitreus");
        Thaumcraft.parseAspects(ArtificeItems.itemCoin, 0, "1 Lucrum, 1 Victus");
        Thaumcraft.parseAspects(ArtificeItems.itemCoin, 1, "1 Lucrum, 1 Sensus");
        Thaumcraft.parseAspects(ArtificeItems.itemCoin, 2, "2 Lucrum");
        Thaumcraft.parseAspects(ArtificeItems.itemCoin, 3, "1 Lucrum, 1 Vitreus");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 0, "1 Fabrico, 1 Ignis, 1 Telum");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 1, "1 Fabrico, 2 Ordo, 1 Cognitio");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 2, "1 Fabrico, 1 Potentia, 1 Arbor");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 3, "1 Fabrico, 2 Ordo, 1 Pannus");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 4, "1 Fabrico, 4 Saxum");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 5, "1 Fabrico, 1 Metallum, 1 Telum");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 6, "1 Fabrico, 1 Bestia, 1 Tutamen");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 7, "1 Fabrico, 1 Pannus, 1 Tutamen");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 8, "1 Fabrico, 2 Limus");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 9, "1 Fabrico, 1 Limus, 2 Aqua");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 10, "1 Fabrico, 1 Limus, 1 Tutamen");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 11, "1 Fabrico, 2 Aqua, 2 Aer");
        Thaumcraft.parseAspects(ArtificeItems.itemUpgrade, 12, "1 Fabrico, 2 Aqua, 1 Motus");
    }
}

