/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.render;

import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.render.connectedtexture.ConnectedTextures;
import shukaro.artifice.util.BlockCoord;
import shukaro.artifice.util.ChunkCoord;

public class TextureHandler {
    public static void updateTexture(BlockCoord c) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && c.getBlock((World)world) != null && !c.getBlock((World)world).isAirBlock((World)world, c.x, c.y, c.z)) {
            if (!ArtificeCore.textureCache.containsKey(new ChunkCoord(c))) {
                ArtificeCore.textureCache.put(new ChunkCoord(c), new ConcurrentHashMap());
            }
            Block block = c.getBlock((World)world);
            int meta = c.getMeta((World)world);
            boolean updated = false;
            int[] indices = new int[6];
            for (int i = 0; i < 6; ++i) {
                ConnectedTextures t = TextureHandler.getConnectedTexture(block.func_71858_a(i, meta));
                if (t == null) continue;
                if (ArtificeCore.textureCache.get(new ChunkCoord(c)).get(c) == null) {
                    updated = true;
                } else if (ArtificeCore.textureCache.get(new ChunkCoord(c)).get(c)[i] != t.renderer.getTextureIndex((IBlockAccess)world, c.x, c.y, c.z, i)) {
                    updated = true;
                }
                indices[i] = t.renderer.getTextureIndex((IBlockAccess)world, c.x, c.y, c.z, i);
            }
            if (updated && ArtificeCore.textureCache.containsKey(new ChunkCoord(c))) {
                ArtificeCore.textureCache.get(new ChunkCoord(c)).put(c, indices);
                world.func_72902_n(c.x, c.y, c.z);
            }
        }
    }

    public static ConnectedTextures getConnectedTexture(Icon icon) {
        if (icon != null && icon.func_94215_i() != null) {
            String s = icon.func_94215_i();
            for (ConnectedTextures t : ConnectedTextures.values()) {
                if (!s.startsWith("Artifice".toLowerCase(Locale.ENGLISH) + ":" + t.name.replace('_', '/'))) continue;
                return t;
            }
        }
        return null;
    }
}

