/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.util;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ComparableItemStack {
    public int itemID = -1;
    public int metadata = -1;
    public int stackSize = -1;
    public int oreID = -1;

    public ComparableItemStack(ItemStack stack) {
        if (stack != null) {
            this.itemID = stack.field_77993_c;
            this.metadata = stack.func_77960_j();
            this.stackSize = stack.field_77994_a;
            this.oreID = OreDictionary.getOreID((ItemStack)stack);
        }
    }

    public ComparableItemStack(int itemID, int damage, int stackSize) {
        this.itemID = itemID;
        this.metadata = damage;
        this.stackSize = stackSize;
        this.oreID = OreDictionary.getOreID((ItemStack)this.toItemStack());
    }

    public ComparableItemStack(ComparableItemStack stack) {
        this.itemID = stack.itemID;
        this.metadata = stack.metadata;
        this.stackSize = stack.stackSize;
        this.oreID = stack.oreID;
    }

    public ComparableItemStack(String oreName) {
        if (!OreDictionary.getOres((String)oreName).isEmpty()) {
            ItemStack ore = (ItemStack)OreDictionary.getOres((String)oreName).get(0);
            this.itemID = ore.field_77993_c;
            this.metadata = ore.func_77960_j();
            this.stackSize = 1;
            this.oreID = OreDictionary.getOreID((String)oreName);
        }
    }

    public boolean isItemEqual(ComparableItemStack other) {
        return other != null && (this.oreID != -1 && this.oreID == other.oreID || this.itemID == other.itemID && this.metadata == other.metadata);
    }

    public boolean isStackEqual(ComparableItemStack other) {
        return this.isItemEqual(other) && this.stackSize == other.stackSize;
    }

    public boolean isStackValid() {
        return this.getItem() != null;
    }

    public Item getItem() {
        return this.itemID < 0 || this.itemID >= 32000 ? null : Item.field_77698_e[this.itemID];
    }

    public ItemStack toItemStack() {
        return this.itemID < 0 || this.itemID >= 32000 ? null : new ItemStack(this.itemID, this.stackSize, this.metadata);
    }

    public ComparableItemStack clone() {
        return new ComparableItemStack(this);
    }

    public int hashCode() {
        return this.oreID != -1 ? this.oreID : this.metadata | this.itemID << 16;
    }

    public boolean equals(Object o) {
        return o instanceof ComparableItemStack && this.isItemEqual((ComparableItemStack)o);
    }
}

