/*
 * Decompiled with CFR 0.152.
 */
package shukaro.artifice.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import shukaro.artifice.ArtificeBlocks;
import shukaro.artifice.ArtificeCore;
import shukaro.artifice.util.ChunkCoord;

public class WorldGenFlowers {
    private World world;
    private Random rand;

    public WorldGenFlowers(World world, Random rand) {
        this.world = world;
        this.rand = rand;
    }

    public boolean generate(int chunkX, int chunkZ) {
        int type = this.rand.nextInt(ArtificeCore.flora.length - 1);
        int xMin = chunkX << 4;
        int zMin = chunkZ << 4;
        int startX = xMin + this.rand.nextInt(16);
        int startZ = zMin + this.rand.nextInt(16);
        if (this.rand.nextInt(10) > 6) {
            return false;
        }
        BiomeGenBase biome = this.world.func_72807_a(startX, startZ);
        boolean biomeRight = false;
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            biomeRight = true;
        } else if ((BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HILLS)) && (type == 0 || type == 2)) {
            biomeRight = true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) && (type == 0 || type == 3)) {
            biomeRight = true;
        } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) && type == 1) {
            biomeRight = true;
        }
        if (!biomeRight) {
            return false;
        }
        int tries = this.rand.nextInt(16) + 8;
        ChunkCoord c = new ChunkCoord(chunkX, chunkZ);
        for (int l = 0; l < tries; ++l) {
            int x = startX + this.rand.nextInt(8) - this.rand.nextInt(8);
            int z = startZ + this.rand.nextInt(8) - this.rand.nextInt(8);
            int y = this.world.func_72976_f(x, z);
            if (!c.contains(x, z) || !this.world.func_72799_c(x, y, z) && this.world.func_72798_a(x, y, z) != Block.field_72037_aS.field_71990_ca || !ArtificeBlocks.blockFlora.func_71854_d(this.world, x, y, z) || this.rand.nextInt(10) > 5) continue;
            if (type == 3) {
                if (this.world.func_72820_D() > 12000L) {
                    this.world.func_72832_d(x, y, z, ArtificeBlocks.blockFlora.field_71990_ca, 4, 0);
                    continue;
                }
                this.world.func_72832_d(x, y, z, ArtificeBlocks.blockFlora.field_71990_ca, 3, 0);
                continue;
            }
            this.world.func_72832_d(x, y, z, ArtificeBlocks.blockFlora.field_71990_ca, type, 0);
        }
        return true;
    }
}

