/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.crate;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import resonant.lib.prefab.item.ItemBlockTooltip;
import resonant.lib.utility.LanguageUtility;
import resonantinduction.archaic.crate.TileCrate;

public class ItemBlockCrate
extends ItemBlockTooltip {
    public ItemBlockCrate(int id) {
        super(id);
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a() + "." + itemStack.func_77960_j();
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, list, par4);
        ItemStack containingStack = ItemBlockCrate.getContainingItemStack(itemStack);
        if (containingStack != null) {
            list.add(containingStack.func_82833_r());
            list.add(LanguageUtility.getLocal((String)"crate.tooltip.amount") + " " + containingStack.field_77994_a);
        }
    }

    public int getItemStackLimit(ItemStack stack) {
        ItemStack containingStack = ItemBlockCrate.getContainingItemStack(stack);
        if (containingStack != null) {
            return 1;
        }
        return this.field_77777_bU;
    }

    public void func_77663_a(ItemStack itemStack, World par2World, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack containingStack = ItemBlockCrate.getContainingItemStack(itemStack);
            if (containingStack != null && !player.field_71075_bZ.field_75098_d) {
                player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 5, (int)((float)containingStack.field_77994_a / (float)TileCrate.getSlotCount(itemStack.func_77960_j())) * 5));
            }
        }
    }

    public static void setContainingItemStack(ItemStack itemStack, ItemStack containingStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (containingStack != null) {
            NBTTagCompound itemTagCompound = new NBTTagCompound();
            containingStack.field_77994_a = Math.abs(containingStack.field_77994_a);
            containingStack.func_77955_b(itemTagCompound);
            itemStack.func_77978_p().func_74782_a("Item", (NBTBase)itemTagCompound);
            itemStack.func_77978_p().func_74768_a("Count", containingStack.field_77994_a);
        } else {
            itemStack.func_77978_p().func_74782_a("Item", (NBTBase)new NBTTagCompound());
            itemStack.func_77978_p().func_74768_a("Count", 0);
        }
    }

    public static ItemStack getContainingItemStack(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
            return null;
        }
        NBTTagCompound itemTagCompound = itemStack.func_77978_p().func_74775_l("Item");
        ItemStack containingStack = ItemStack.func_77949_a((NBTTagCompound)itemTagCompound);
        if (containingStack != null) {
            containingStack.field_77994_a = itemStack.func_77978_p().func_74762_e("Count");
        }
        return containingStack;
    }

    public int func_77647_b(int metadata) {
        return metadata;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            ItemStack containingItem = ItemBlockCrate.getContainingItemStack(stack);
            if (world.func_72796_p(x, y, z) != null && containingItem != null && containingItem.field_77994_a > 0) {
                TileCrate tileEntity = (TileCrate)world.func_72796_p(x, y, z);
                int count = containingItem.field_77994_a;
                for (int slot = 0; slot < tileEntity.getInventory().func_70302_i_(); ++slot) {
                    int stackSize = Math.min(64, count);
                    tileEntity.getInventory().func_70299_a(slot, new ItemStack(containingItem.field_77993_c, stackSize, containingItem.func_77960_j()));
                    if ((count -= stackSize) > 0) continue;
                    containingItem = null;
                    break;
                }
                tileEntity.buildSampleStack();
            }
        }
        return true;
    }
}

