/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.crate;

import com.google.common.io.ByteArrayDataInput;
import java.io.DataInput;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import resonant.api.IExtendedStorage;
import resonant.api.IFilterable;
import resonant.api.IRemovable;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.tile.TileExternalInventory;
import resonantinduction.archaic.Archaic;
import resonantinduction.archaic.crate.BlockCrate;
import resonantinduction.archaic.crate.InventoryCrate;
import resonantinduction.archaic.crate.ItemBlockCrate;
import resonantinduction.core.ResonantInduction;

public class TileCrate
extends TileExternalInventory
implements IPacketReceiver,
IExtendedStorage,
IFilterable,
IRemovable.ISneakPickup {
    public static final int maxSize = 2;
    public long prevClickTime = -1000L;
    public boolean oreFilterEnabled = false;
    private ItemStack sampleStack;
    private ItemStack filterStack;
    private long updateTick = 1L;
    private boolean doUpdate = false;

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            this.func_70310_b(new NBTTagCompound());
            if (this.ticks % this.updateTick == 0L) {
                this.updateTick = 5 + this.field_70331_k.field_73012_v.nextInt(50);
                this.doUpdate = true;
            }
            if (this.doUpdate) {
                this.doUpdate = false;
                PacketHandler.sendPacketToClients((Packet)this.func_70319_e(), (World)this.field_70331_k);
            }
        }
    }

    public static int getSlotCount(int metadata) {
        if (metadata >= 2) {
            return 256;
        }
        if (metadata >= 1) {
            return 64;
        }
        return 32;
    }

    public InventoryCrate getInventory() {
        if (this.inventory == null) {
            this.inventory = new InventoryCrate((TileEntity)this);
        }
        return (InventoryCrate)this.inventory;
    }

    public ItemStack getSampleStack() {
        if (this.sampleStack == null) {
            this.buildSampleStack();
        }
        return this.sampleStack;
    }

    public void buildSampleStack() {
        this.buildSampleStack(true);
    }

    public void buildSampleStack(boolean buildInv) {
        if (this.field_70331_k == null || !this.field_70331_k.field_72995_K) {
            ItemStack newSampleStack = null;
            boolean rebuildBase = false;
            for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
                ItemStack slotStack = this.getInventory().getContainedItems()[slot];
                if (slotStack == null || Item.field_77698_e[slotStack.field_77993_c] == null || slotStack.field_77994_a <= 0) continue;
                if (newSampleStack == null) {
                    newSampleStack = slotStack.func_77946_l();
                } else {
                    newSampleStack.field_77994_a += slotStack.field_77994_a;
                }
                if (slotStack.field_77994_a <= slotStack.func_77976_d()) continue;
                rebuildBase = true;
            }
            this.sampleStack = newSampleStack == null || newSampleStack.field_77993_c == 0 || newSampleStack.field_77994_a <= 0 ? (this.getFilter() != null ? this.getFilter().func_77946_l() : null) : newSampleStack.func_77946_l();
            if (buildInv && this.sampleStack != null && (rebuildBase || this.getInventory().getContainedItems().length > this.func_70302_i_())) {
                this.getInventory().buildInventory(this.sampleStack);
            }
        }
    }

    public ItemStack addStackToStorage(ItemStack stack) {
        return BlockCrate.addStackToCrate(this, stack);
    }

    public void addToStack(ItemStack stack, int amount) {
        if (stack != null) {
            ItemStack newStack = stack.func_77946_l();
            newStack.field_77994_a = amount;
            this.addToStack(newStack);
        }
    }

    public void addToStack(ItemStack stack) {
        if (stack != null && stack.field_77994_a > 0) {
            if (this.getSampleStack() == null) {
                this.sampleStack = stack;
                this.getInventory().buildInventory(this.getSampleStack());
            } else if (this.getSampleStack().func_77969_a(stack) || this.oreFilterEnabled && OreDictionary.getOreID((ItemStack)this.getSampleStack()) == OreDictionary.getOreID((ItemStack)stack)) {
                this.getSampleStack().field_77994_a += stack.field_77994_a;
                this.getInventory().buildInventory(this.getSampleStack());
            }
        }
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.sampleStack != null) {
            if (this.sampleStack.field_77994_a <= amount) {
                ItemStack var3 = this.sampleStack;
                this.sampleStack = null;
                this.func_70296_d();
                this.getInventory().buildInventory(this.getSampleStack());
                return var3;
            }
            ItemStack var3 = this.sampleStack.func_77979_a(amount);
            if (this.sampleStack.field_77994_a == 0) {
                this.sampleStack = null;
            }
            this.getInventory().buildInventory(this.getSampleStack());
            this.func_70296_d();
            return var3;
        }
        return null;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_70331_k != null && !this.field_70331_k.field_72995_K) {
            this.doUpdate = true;
        }
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return this.getSampleStack() == null || stack != null && (stack.func_77969_a(this.getSampleStack()) || this.oreFilterEnabled && OreDictionary.getOreID((ItemStack)this.getSampleStack()) == OreDictionary.getOreID((ItemStack)stack));
    }

    public int getSlotCount() {
        if (this.field_70331_k == null) {
            return TileCrate.getSlotCount(2);
        }
        return TileCrate.getSlotCount(this.func_70322_n());
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        if (this.field_70331_k.field_72995_K) {
            try {
                if (data.readBoolean()) {
                    this.sampleStack = ItemStack.func_77949_a((NBTTagCompound)PacketHandler.readNBTTagCompound((DataInput)data));
                    this.sampleStack.field_77994_a = data.readInt();
                } else {
                    this.sampleStack = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Packet func_70319_e() {
        this.buildSampleStack();
        ItemStack stack = this.getSampleStack();
        if (stack != null) {
            return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{true, stack.func_77955_b(new NBTTagCompound()), stack.field_77994_a});
        }
        return ResonantInduction.PACKET_TILE.getPacket((TileEntity)this, new Object[]{false});
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        ItemStack stack = null;
        int count = nbt.func_74762_e("Count");
        if (nbt.func_74764_b("itemID")) {
            stack = new ItemStack(nbt.func_74762_e("itemID"), count, nbt.func_74762_e("itemMeta"));
        } else {
            stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("stack"));
            if (stack != null) {
                stack.field_77994_a = count;
            }
        }
        if (stack != null && stack.field_77993_c != 0 && stack.field_77994_a > 0) {
            this.sampleStack = stack;
            this.getInventory().buildInventory(this.sampleStack);
        }
        this.oreFilterEnabled = nbt.func_74767_n("oreFilter");
        if (nbt.func_74764_b("filter")) {
            this.filterStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("filter"));
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.buildSampleStack(false);
        ItemStack stack = this.getSampleStack();
        if (stack != null) {
            nbt.func_74768_a("Count", stack.field_77994_a);
            nbt.func_74766_a("stack", stack.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74757_a("oreFilter", this.oreFilterEnabled);
        if (this.filterStack != null) {
            nbt.func_74766_a("filter", this.filterStack.func_77955_b(new NBTTagCompound()));
        }
    }

    public ItemStack getFilter() {
        return this.filterStack;
    }

    public void setFilter(ItemStack filter) {
        this.filterStack = filter;
        this.func_70296_d();
    }

    public List<ItemStack> getRemovedItems(EntityPlayer entity) {
        ItemStack sampleStack = this.getSampleStack();
        ItemStack drop = new ItemStack(Archaic.blockCrate, 1, this.func_70322_n());
        if (sampleStack != null && sampleStack.field_77994_a > 0) {
            ItemBlockCrate.setContainingItemStack(drop, sampleStack);
        }
        return Arrays.asList(drop);
    }
}

