/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.filter;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import resonant.api.IFilterable;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.content.module.TileRender;
import resonant.lib.network.Synced;
import resonant.lib.prefab.vector.Cuboid;
import resonant.lib.render.RenderItemOverlayUtility;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.prefab.imprint.ItemImprint;
import resonantinduction.core.prefab.imprint.TileFilterable;
import resonantinduction.core.resource.ResourceGenerator;
import resonantinduction.core.resource.fluid.BlockFluidMixture;
import universalelectricity.api.vector.Vector3;

public class TileFilter
extends TileFilterable
implements IFilterable {
    private int renderIndex = 0;

    public TileFilter() {
        super(Material.field_76243_f);
        this.maxSlots = 1;
        this.isOpaqueCube = false;
        this.normalRender = false;
    }

    public Iterable<Cuboid> getCollisionBoxes(Cuboid intersect, Entity entity) {
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityItem && this.isFiltering(((EntityItem)entity).func_92059_d())) {
            return null;
        }
        return super.getCollisionBoxes(intersect, entity);
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.ticks % 60L == 0L) {
            List filteredStacks;
            if (this.getFilter() != null && (filteredStacks = ItemImprint.getFilterList((ItemStack)this.getFilter())).size() > 0) {
                this.renderIndex = (this.renderIndex + 1) % filteredStacks.size();
            }
            Vector3 position = new Vector3((TileEntity)this);
            Vector3 checkAbove = position.clone().translate(ForgeDirection.UP);
            Vector3 checkBelow = position.clone().translate(ForgeDirection.DOWN);
            Block bAbove = Block.field_71973_m[checkAbove.getBlockID((IBlockAccess)this.field_70331_k)];
            if (bAbove instanceof BlockFluidMixture && (this.field_70331_k.func_72799_c(checkBelow.intX(), checkBelow.intY(), checkBelow.intZ()) || checkBelow.getTileEntity((IBlockAccess)this.field_70331_k) instanceof IFluidHandler)) {
                this.field_70331_k.func_72869_a("dripWater", (double)this.field_70329_l + 0.5, (double)this.field_70330_m, (double)this.field_70327_n + 0.5, 0.0, 0.0, 0.0);
                BlockFluidMixture fluidBlock = (BlockFluidMixture)bAbove;
                int amount = fluidBlock.getQuantaValue((IBlockAccess)this.field_70331_k, checkAbove.intX(), checkAbove.intY(), checkAbove.intZ());
                int leakAmount = 2;
                for (RecipeResource resoure : MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.MIXER.name(), new Object[]{"dirtyDust" + LanguageUtility.capitalizeFirst((String)ResourceGenerator.mixtureToMaterial((String)fluidBlock.getFluid().getName()))})) {
                    InventoryUtility.dropItemStack((World)this.field_70331_k, (Vector3)checkAbove.clone().add(0.5), (ItemStack)resoure.getItemStack().func_77946_l(), (int)0, (float)0.0f);
                }
                int remaining = amount - leakAmount;
                fluidBlock.setQuanta(this.field_70331_k, checkAbove.intX(), checkAbove.intY(), checkAbove.intZ(), remaining);
                checkBelow.setBlock(this.field_70331_k, Block.field_71942_A.field_71990_ca);
            }
        }
    }

    @Synced.SyncedOutput
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
    }

    @Synced.SyncedInput
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return new TileRender(){

            public boolean renderDynamic(Vector3 position, boolean isItem, float frame) {
                List filteredStacks;
                if (isItem) {
                    return false;
                }
                if (TileFilter.this.getFilter() != null && (filteredStacks = ItemImprint.getFilterList((ItemStack)TileFilter.this.getFilter())).size() > 0) {
                    ItemStack renderStack = (ItemStack)filteredStacks.get(TileFilter.this.renderIndex);
                    RenderItemOverlayUtility.renderItemOnSides((TileEntity)TileFilter.this, (ItemStack)renderStack, (double)position.x, (double)position.y, (double)position.z);
                }
                return false;
            }
        };
    }

    public boolean shouldSideBeRendered(IBlockAccess access, int x, int y, int z, int side) {
        return access.func_72798_a(x, y, z) == this.block.field_71990_ca ? false : super.shouldSideBeRendered(access, x, y, z, side);
    }

    public Packet func_70319_e() {
        return ResonantInduction.PACKET_ANNOTATION.getPacket((Object)this);
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return slot == 0 && stack.func_77973_b() instanceof ItemImprint;
    }

    public void setFilter(ItemStack filter) {
        this.func_70299_a(0, filter);
        this.markUpdate();
    }

    public ItemStack getFilter() {
        return this.func_70301_a(0);
    }
}

