/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.firebox;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import resonant.lib.prefab.block.BlockTile;
import resonantinduction.archaic.firebox.TileHotPlate;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;

public class BlockHotPlate
extends BlockTile {
    private Icon topElectric;

    public BlockHotPlate(int id) {
        super(id, Material.field_76246_e);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.2f, 1.0f);
        this.func_71907_b(true);
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconReg) {
        super.func_94332_a(iconReg);
        this.topElectric = iconReg.func_94245_a("resonantinduction:electricHotPlate");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return meta == 1 ? this.topElectric : this.field_94336_cN;
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileHotPlate) {
            TileHotPlate tile = (TileHotPlate)tileEntity;
            this.extractItem((IInventory)tile, 0, player);
        }
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileHotPlate) {
            TileHotPlate tile = (TileHotPlate)tileEntity;
            if (!world.field_72995_K) {
                Vector2 hitVector = new Vector2((double)hitX, (double)hitZ);
                double regionLength = 0.5;
                block0: for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        Vector2 check = new Vector2((double)j, (double)k).scale(0.5);
                        if (!(check.distance(hitVector) < 0.5)) continue;
                        int slotID = j * 2 + k;
                        this.interactCurrentItem((IInventory)tile, slotID, player);
                        break block0;
                    }
                }
                tile.func_70296_d();
            }
            return true;
        }
        return false;
    }

    public void func_71862_a(World world, int x, int y, int z, Random random) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileHotPlate) {
            TileHotPlate tile = (TileHotPlate)tileEntity;
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    int i = j * 2 + k;
                    if (tile.func_70301_a(i) == null || tile.getSmeltTime(i) <= 0) continue;
                    int maxSmelt = 200 * tile.func_70301_a((int)i).field_77994_a;
                    int maxParticles = (int)((double)(maxSmelt - tile.getSmeltTime(i)) / (double)maxSmelt * 30.0);
                    for (int spawn = 0; spawn < maxParticles; ++spawn) {
                        Vector3 particlePosition = new Vector3((double)x, (double)y, (double)z).translate((double)(i / 2) / 2.0 + 0.25, 0.2, (double)(i % 2) / 2.0 + 0.25);
                        particlePosition.translate((IVector3)new Vector3(((double)random.nextFloat() - 0.5) * 0.2, ((double)random.nextFloat() - 0.5) * 0.2, ((double)random.nextFloat() - 0.5) * 0.2));
                        world.func_72869_a("smoke", particlePosition.x, particlePosition.y, particlePosition.z, 0.0, 0.0, 0.0);
                    }
                    Vector3 particlePosition = new Vector3((double)x, (double)y, (double)z).translate((double)(i / 2) / 2.0 + 0.25, 0.2, (double)(i % 2) / 2.0 + 0.25);
                    world.func_72869_a("flame", particlePosition.x, particlePosition.y, particlePosition.z, 0.0, 0.01, 0.0);
                }
            }
        }
    }

    public void func_71869_a(World world, int x, int y, int z, Entity par5Entity) {
        TileHotPlate tile;
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileHotPlate && (tile = (TileHotPlate)tileEntity).isSmelting()) {
            par5Entity.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
    }

    public TileEntity func_72274_a(World world) {
        return new TileHotPlate();
    }
}

