/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.fluid.grate;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import resonant.api.IRotatable;
import resonant.lib.config.Config;
import resonant.lib.utility.FluidUtility;
import resonantinduction.core.grid.fluid.FluidPressureNode;
import resonantinduction.core.grid.fluid.IPressureNodeProvider;
import resonantinduction.core.grid.fluid.TilePressureNode;
import universalelectricity.api.vector.Vector3;

public class TileGrate
extends TilePressureNode
implements IRotatable {
    @Config(comment="The multiplier for the influence of the grate. Dependent on pressure.")
    private static double grateEffectMultiplier = 5.0;
    @Config(comment="The speed in which the grate drains blocks. Dependent on grate block influence.")
    private static double grateDrainSpeedMultiplier = 0.01;
    @SideOnly(value=Side.CLIENT)
    private static Icon iconFront;
    @SideOnly(value=Side.CLIENT)
    private static Icon iconSide;
    private GratePathfinder gratePath;
    private boolean fillOver = true;

    public TileGrate() {
        super(Material.field_76246_e);
        this.isOpaqueCube = false;
        this.normalRender = true;
        this.rotationMask = Byte.parseByte("111111", 2);
        this.node = new FluidPressureNode((IPressureNodeProvider)this);
        this.node.maxFlowRate = this.getPressureTank().getCapacity();
    }

    public Icon getIcon(IBlockAccess world, int side) {
        return side == this.getDirection().ordinal() ? iconFront : iconSide;
    }

    public Icon getIcon(int side, int metadata) {
        return side == 1 ? iconFront : iconSide;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IconRegister iconRegister) {
        iconFront = iconRegister.func_94245_a("resonantinduction:grate_front");
        iconSide = iconRegister.func_94245_a("resonantinduction:grate");
    }

    protected boolean configure(EntityPlayer player, int side, Vector3 hit) {
        if (!player.func_70093_af()) {
            if (!this.world().field_72995_K) {
                this.fillOver = !this.fillOver;
                player.func_71035_c("Grate now set to " + (this.fillOver ? "" : "not ") + "fill higher than itself.");
                this.gratePath = null;
            }
            return true;
        }
        return super.configure(player, side, hit);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.fillOver = nbt.func_74767_n("fillOver");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("fillOver", this.fillOver);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.getPressureTank().getInfo()};
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getDirection() != from;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getDirection() != from;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.world().field_72995_K && this.ticks % 10L == 0L) {
            int maxDrain;
            int pressure = this.node.getPressure(this.getDirection());
            int blockEffect = (int)Math.abs((double)pressure * grateEffectMultiplier);
            this.getPressureTank().setCapacity((int)Math.max((double)(blockEffect * 1000) * grateDrainSpeedMultiplier, 1000.0));
            if (pressure > 0) {
                if (this.getPressureTank().getFluidAmount() >= 1000) {
                    if (this.gratePath == null) {
                        this.gratePath = new GratePathfinder(true);
                        this.gratePath.startFill(new Vector3((TileEntity)this), this.getPressureTank().getFluid().getFluid().getID());
                    }
                    int filledInWorld = this.gratePath.tryFill(this.getPressureTank().getFluidAmount(), blockEffect);
                    this.getPressureTank().drain(filledInWorld, true);
                }
            } else if (pressure < 0 && (maxDrain = this.getPressureTank().getCapacity() - this.getPressureTank().getFluidAmount()) > 0) {
                if (this.gratePath == null) {
                    this.gratePath = new GratePathfinder(false);
                    if (!this.gratePath.startDrain(new Vector3((TileEntity)this))) {
                        this.resetPath();
                    }
                }
                if (this.gratePath != null && this.gratePath.tryPopulateDrainMap(blockEffect)) {
                    this.getPressureTank().fill(this.gratePath.tryDrain(maxDrain, true), true);
                }
            }
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.getPressureTank().fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.getPressureTank().drain(maxDrain, doDrain);
    }

    public void resetPath() {
        this.gratePath = null;
    }

    public class GratePathfinder {
        public Fluid fluidType;
        Vector3 start;
        HashMap<Vector3, Vector3> navigationMap = new HashMap();
        PriorityQueue<ComparableVector> workingNodes;
        PriorityQueue<ComparableVector> drainNodes = new PriorityQueue(1024, Collections.reverseOrder());

        public GratePathfinder(boolean checkVertical) {
            this.workingNodes = checkVertical ? new PriorityQueue() : new PriorityQueue(1024, new Comparator(){

                public int compare(Object a, Object b) {
                    ComparableVector wa = (ComparableVector)a;
                    ComparableVector wb = (ComparableVector)b;
                    return wa.iterations - wb.iterations;
                }
            });
        }

        public boolean isConnected(Vector3 check) {
            if (check.equals((Object)this.start)) {
                return true;
            }
            do {
                if ((check = this.navigationMap.get(check)) == null) {
                    return false;
                }
                if (!check.equals((Object)this.start)) continue;
                return true;
            } while (FluidUtility.getFluidFromBlock((World)TileGrate.this.field_70331_k, (Vector3)check) != null && this.fluidType.getID() == FluidUtility.getFluidFromBlock((World)TileGrate.this.field_70331_k, (Vector3)check).getID());
            return false;
        }

        public void startFill(Vector3 start, int fluidID) {
            this.fluidType = FluidRegistry.getFluid((int)fluidID);
            this.start = start;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                if (dir != TileGrate.this.getDirection()) continue;
                Vector3 check = start.clone().translate(dir);
                this.navigationMap.put(check, start);
                this.workingNodes.add(new ComparableVector(check, 0));
            }
        }

        public int tryFill(int amount, int tries) {
            int filled = 0;
            if (amount >= 1000) {
                for (int i = 0; i < tries; ++i) {
                    ComparableVector next = this.workingNodes.poll();
                    if (next == null) {
                        TileGrate.this.resetPath();
                        return 0;
                    }
                    if (!this.isConnected(next.position)) {
                        TileGrate.this.resetPath();
                        return 0;
                    }
                    int didFill = FluidUtility.fillBlock((World)TileGrate.this.field_70331_k, (Vector3)next.position, (FluidStack)new FluidStack(this.fluidType, amount), (boolean)true);
                    filled += didFill;
                    if (FluidUtility.getFluidAmountFromBlock((World)TileGrate.this.field_70331_k, (Vector3)next.position) > 0 || didFill > 0) {
                        this.addNextFill(next);
                    }
                    if (filled < amount) continue;
                    return filled;
                }
            }
            return filled;
        }

        public void addNextFill(ComparableVector next) {
            for (int i = 0; i < 6; ++i) {
                Vector3 newPosition = next.position.clone().translate(ForgeDirection.getOrientation((int)i));
                if (this.navigationMap.containsKey(newPosition) || !TileGrate.this.fillOver && newPosition.intY() > TileGrate.this.y()) continue;
                this.navigationMap.put(newPosition, next.position);
                this.workingNodes.add(new ComparableVector(newPosition, next.iterations + 1));
            }
        }

        public boolean startDrain(Vector3 start) {
            this.fluidType = null;
            this.start = start;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                if (dir != TileGrate.this.getDirection()) continue;
                Vector3 check = start.clone().translate(dir);
                this.navigationMap.put(check, start);
                this.workingNodes.add(new ComparableVector(check, 0));
                this.fluidType = FluidUtility.getFluidFromBlock((World)TileGrate.this.field_70331_k, (Vector3)check);
            }
            return this.fluidType != null;
        }

        public boolean tryPopulateDrainMap(int tries) {
            for (int i = 0; i < tries; ++i) {
                ComparableVector check = this.workingNodes.poll();
                if (check == null) {
                    return true;
                }
                Fluid checkFluid = FluidUtility.getFluidFromBlock((World)TileGrate.this.field_70331_k, (Vector3)check.position);
                if (checkFluid == null || this.fluidType.getID() != checkFluid.getID()) continue;
                this.addNextDrain(check);
                int checkAmount = FluidUtility.getFluidAmountFromBlock((World)TileGrate.this.field_70331_k, (Vector3)check.position);
                if (checkAmount <= 0) continue;
                this.drainNodes.add(check);
            }
            return this.drainNodes.size() > 0;
        }

        public void addNextDrain(ComparableVector next) {
            for (int i = 0; i < 6; ++i) {
                Vector3 check = next.position.clone().translate(ForgeDirection.getOrientation((int)i));
                Fluid checkFluid = FluidUtility.getFluidFromBlock((World)TileGrate.this.field_70331_k, (Vector3)check);
                if (checkFluid == null || this.fluidType.getID() != checkFluid.getID() || this.navigationMap.containsKey(check)) continue;
                this.navigationMap.put(check, next.position);
                this.workingNodes.add(new ComparableVector(check, next.iterations + 1));
            }
        }

        public FluidStack tryDrain(int targetAmount, boolean doDrain) {
            int drainedAmount = 0;
            while (!this.drainNodes.isEmpty()) {
                ComparableVector fluidCoord = this.drainNodes.peek();
                if (!this.isConnected(fluidCoord.position)) {
                    TileGrate.this.resetPath();
                    return new FluidStack(this.fluidType, drainedAmount);
                }
                if (FluidUtility.getFluidFromBlock((World)TileGrate.this.field_70331_k, (Vector3)fluidCoord.position) == null || this.fluidType.getID() != FluidUtility.getFluidFromBlock((World)TileGrate.this.field_70331_k, (Vector3)fluidCoord.position).getID()) {
                    this.drainNodes.poll();
                    continue;
                }
                int checkAmount = FluidUtility.getFluidAmountFromBlock((World)TileGrate.this.field_70331_k, (Vector3)fluidCoord.position);
                if (drainedAmount + checkAmount > targetAmount) break;
                if (checkAmount == 0) {
                    this.drainNodes.poll();
                    continue;
                }
                FluidStack fluidStack = FluidUtility.drainBlock((World)TileGrate.this.field_70331_k, (Vector3)fluidCoord.position, (boolean)doDrain);
                this.drainNodes.poll();
                if (fluidStack == null || (drainedAmount += fluidStack.amount) < targetAmount) continue;
                break;
            }
            TileGrate.this.resetPath();
            if (drainedAmount > 0) {
                return new FluidStack(this.fluidType, drainedAmount);
            }
            return null;
        }
    }

    public static class ComparableVector
    implements Comparable {
        public Vector3 position;
        public int iterations;

        public ComparableVector(Vector3 position, int iterations) {
            this.position = position;
            this.iterations = iterations;
        }

        public int compareTo(Object obj) {
            ComparableVector wr = (ComparableVector)obj;
            if (this.position.y == wr.position.y) {
                return this.iterations - wr.iterations;
            }
            return this.position.intY() - wr.position.intY();
        }
    }
}

