/*
 * Decompiled with CFR 0.152.
 */
package resonantinduction.archaic.fluid.gutter;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import resonant.api.recipe.MachineRecipes;
import resonant.api.recipe.RecipeResource;
import resonant.lib.content.module.TileRender;
import resonant.lib.grid.TickingGrid;
import resonant.lib.prefab.vector.Cuboid;
import resonant.lib.render.FluidRenderUtility;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.FluidUtility;
import resonant.lib.utility.WorldUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import resonantinduction.archaic.fluid.grate.TileGrate;
import resonantinduction.archaic.fluid.gutter.FluidGravityNode;
import resonantinduction.core.ResonantInduction;
import resonantinduction.core.grid.fluid.FluidPressureNode;
import resonantinduction.core.grid.fluid.IPressureNodeProvider;
import resonantinduction.core.grid.fluid.TilePressureNode;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class TileGutter
extends TilePressureNode {
    public TileGutter() {
        super(Material.field_76246_e);
        this.textureName = "material_wood_surface";
        this.isOpaqueCube = false;
        this.normalRender = false;
        this.bounds = new Cuboid(0.0, 0.0, 0.0, 1.0, 0.99, 1.0);
        this.node = new FluidGravityNode((IPressureNodeProvider)this){

            public void doRecache() {
                this.connections.clear();
                byte previousConnections = TileGutter.this.renderSides;
                TileGutter.this.renderSides = 0;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = this.position().translate(dir).getTileEntity((IBlockAccess)this.world());
                    if (!(tile instanceof IFluidHandler)) continue;
                    if (tile instanceof IPressureNodeProvider) {
                        FluidPressureNode check = (FluidPressureNode)((IPressureNodeProvider)tile).getNode(FluidPressureNode.class, dir.getOpposite());
                        if (check == null || !this.canConnect(dir, check) || !check.canConnect(dir.getOpposite(), (Object)this)) continue;
                        this.connections.put(check, dir);
                        if (!(tile instanceof TileGutter)) continue;
                        TileGutter.this.renderSides = WorldUtility.setEnableSide((byte)TileGutter.this.renderSides, (ForgeDirection)dir, (boolean)true);
                        continue;
                    }
                    this.connections.put(tile, dir);
                    if (!(tile instanceof TileGrate)) continue;
                    TileGutter.this.renderSides = WorldUtility.setEnableSide((byte)TileGutter.this.renderSides, (ForgeDirection)dir, (boolean)true);
                }
                if (previousConnections != TileGutter.this.renderSides) {
                    TileGutter.this.sendRenderUpdate();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70316_g() {
        VectorWorld drainPos;
        FluidStack drain;
        super.func_70316_g();
        if (!this.world().field_72995_K && this.ticks % 20L == 0L && (drain = FluidUtility.drainBlock((World)this.field_70331_k, (Vector3)(drainPos = this.position().translate(0.0, 1.0, 0.0)), (boolean)false)) != null) {
            ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
            Set set = ((TickingGrid)this.node.getGrid()).getNodes();
            synchronized (set) {
                for (Object check : ((TickingGrid)this.node.getGrid()).getNodes()) {
                    if (!(check instanceof FluidPressureNode) || !(((FluidPressureNode)check).parent instanceof TileGutter)) continue;
                    tanks.add(((IPressureNodeProvider)((FluidPressureNode)check).parent).getPressureTank());
                }
            }
            if (FluidUtility.fillAllTanks(tanks, (FluidStack)drain, (boolean)false) >= drain.amount) {
                FluidUtility.fillAllTanks(tanks, (FluidStack)drain, (boolean)true);
                FluidUtility.drainBlock((World)this.field_70331_k, (Vector3)drainPos, (boolean)true);
                set = ((TickingGrid)this.node.getGrid()).getNodes();
                synchronized (set) {
                    for (Object check : ((TickingGrid)this.node.getGrid()).getNodes()) {
                        if (!(check instanceof FluidPressureNode)) continue;
                        ((IPressureNodeProvider)((FluidPressureNode)check).parent).onFluidChanged();
                    }
                }
            }
        }
    }

    public Iterable<Cuboid> getCollisionBoxes() {
        ArrayList<Cuboid> list = new ArrayList<Cuboid>();
        float thickness = 0.1f;
        if (!WorldUtility.isEnabledSide((byte)this.renderSides, (ForgeDirection)ForgeDirection.DOWN)) {
            list.add(new Cuboid(0.0, 0.0, 0.0, 1.0, (double)thickness, 1.0));
        }
        if (!WorldUtility.isEnabledSide((byte)this.renderSides, (ForgeDirection)ForgeDirection.WEST)) {
            list.add(new Cuboid(0.0, 0.0, 0.0, (double)thickness, 1.0, 1.0));
        }
        if (!WorldUtility.isEnabledSide((byte)this.renderSides, (ForgeDirection)ForgeDirection.NORTH)) {
            list.add(new Cuboid(0.0, 0.0, 0.0, 1.0, 1.0, (double)thickness));
        }
        if (!WorldUtility.isEnabledSide((byte)this.renderSides, (ForgeDirection)ForgeDirection.EAST)) {
            list.add(new Cuboid((double)(1.0f - thickness), 0.0, 0.0, 1.0, 1.0, 1.0));
        }
        if (!WorldUtility.isEnabledSide((byte)this.renderSides, (ForgeDirection)ForgeDirection.SOUTH)) {
            list.add(new Cuboid(0.0, 0.0, (double)(1.0f - thickness), 1.0, 1.0, 1.0));
        }
        return list;
    }

    public void collide(Entity entity) {
        if (this.getInternalTank().getFluidAmount() > 0) {
            for (int i = 2; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                int pressure = this.node.getPressure(dir);
                Vector3 position = this.position().translate(dir);
                TileEntity checkTile = position.getTileEntity((IBlockAccess)this.world());
                if (!(checkTile instanceof TileGutter)) continue;
                int deltaPressure = pressure - ((TileGutter)checkTile).node.getPressure(dir.getOpposite());
                entity.field_70159_w += 0.01 * (double)dir.offsetX * (double)deltaPressure;
                entity.field_70181_x += 0.01 * (double)dir.offsetY * (double)deltaPressure;
                entity.field_70179_y += 0.01 * (double)dir.offsetZ * (double)deltaPressure;
            }
            if (this.getInternalTank().getFluid().getFluid().getTemperature() >= 373) {
                entity.func_70015_d(5);
            } else {
                entity.func_70066_B();
            }
        }
        if (entity instanceof EntityItem) {
            entity.field_70145_X = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(EntityPlayer player, int side, Vector3 vector3) {
        if (player.func_71045_bC() != null) {
            ItemStack itemStack = player.func_71045_bC();
            RecipeResource[] outputs = MachineRecipes.INSTANCE.getOutput(ResonantInduction.RecipeType.MIXER.name(), new Object[]{itemStack});
            if (outputs.length > 0) {
                if (!this.world().field_72995_K) {
                    int drainAmount = 50 + this.world().field_73012_v.nextInt(50);
                    FluidStack drain = this.drain(ForgeDirection.UP, drainAmount, false);
                    if (drain != null && drain.amount > 0 && (double)this.world().field_73012_v.nextFloat() > 0.9) {
                        if ((double)this.world().field_73012_v.nextFloat() > 0.1) {
                            for (RecipeResource res : outputs) {
                                InventoryUtility.dropItemStack((World)this.world(), (Vector3)new Vector3((Entity)player), (ItemStack)res.getItemStack().func_77946_l(), (int)0);
                            }
                        }
                        --itemStack.field_77994_a;
                        if (itemStack.field_77994_a <= 0) {
                            itemStack = null;
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, itemStack);
                    }
                    this.drain(ForgeDirection.UP, drainAmount, true);
                    this.world().func_72908_a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, "liquid.water", 0.5f, 1.0f);
                }
                return true;
            }
        }
        if (!this.world().field_72995_K) {
            ArrayList<FluidTank> tanks = new ArrayList<FluidTank>();
            Set set = ((TickingGrid)this.node.getGrid()).getNodes();
            synchronized (set) {
                for (Object check : ((TickingGrid)this.node.getGrid()).getNodes()) {
                    if (!(check instanceof FluidPressureNode) || !(((FluidPressureNode)check).parent instanceof TileGutter)) continue;
                    tanks.add(((IPressureNodeProvider)((FluidPressureNode)check).parent).getPressureTank());
                }
            }
            if (FluidUtility.playerActivatedFluidItem(tanks, (EntityPlayer)player, (int)side)) {
                set = ((TickingGrid)this.node.getGrid()).getNodes();
                synchronized (set) {
                    for (Object check : ((TickingGrid)this.node.getGrid()).getNodes()) {
                        if (!(check instanceof FluidPressureNode)) continue;
                        ((IPressureNodeProvider)((FluidPressureNode)check).parent).onFluidChanged();
                    }
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void onFillRain() {
        if (!this.world().field_72995_K) {
            this.fill(ForgeDirection.UP, new FluidStack(FluidRegistry.WATER, 10), true);
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!resource.getFluid().isGaseous()) {
            return super.fill(from, resource, doFill);
        }
        return 0;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && !fluid.isGaseous();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.UP && !fluid.isGaseous();
    }

    @SideOnly(value=Side.CLIENT)
    protected TileRender newRenderer() {
        return new TileRender(){
            public final IModelCustom MODEL = AdvancedModelLoader.loadModel((String)"/assets/resonantinduction/models/gutter.tcn");
            public final ResourceLocation TEXTURE = new ResourceLocation("resonantinduction", "models/gutter.png");

            public boolean renderStatic(RenderBlocks renderer, Vector3 position) {
                return true;
            }

            public boolean renderDynamic(Vector3 position, boolean isItem, float frame) {
                FluidTank tank;
                double percentageFilled;
                GL11.glPushMatrix();
                GL11.glTranslated((double)(position.x + 0.5), (double)(position.y + 0.5), (double)(position.z + 0.5));
                FluidStack liquid = TileGutter.this.getInternalTank().getFluid();
                int capacity = TileGutter.this.getInternalTank().getCapacity();
                this.render(0, TileGutter.this.renderSides);
                if (TileGutter.this.world() != null && (percentageFilled = (double)(tank = TileGutter.this.getInternalTank()).getFluidAmount() / (double)tank.getCapacity()) > 0.1) {
                    GL11.glPushMatrix();
                    GL11.glScaled((double)0.99, (double)0.99, (double)0.99);
                    double ySouthEast = FluidUtility.getAveragePercentageFilledForSides(TileGutter.class, (double)percentageFilled, (World)TileGutter.this.world(), (Vector3)TileGutter.this.position(), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.EAST});
                    double yNorthEast = FluidUtility.getAveragePercentageFilledForSides(TileGutter.class, (double)percentageFilled, (World)TileGutter.this.world(), (Vector3)TileGutter.this.position(), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST});
                    double ySouthWest = FluidUtility.getAveragePercentageFilledForSides(TileGutter.class, (double)percentageFilled, (World)TileGutter.this.world(), (Vector3)TileGutter.this.position(), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST});
                    double yNorthWest = FluidUtility.getAveragePercentageFilledForSides(TileGutter.class, (double)percentageFilled, (World)TileGutter.this.world(), (Vector3)TileGutter.this.position(), (ForgeDirection[])new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.WEST});
                    FluidRenderUtility.renderFluidTesselation((IFluidTank)tank, (double)ySouthEast, (double)yNorthEast, (double)ySouthWest, (double)yNorthWest);
                    GL11.glPopMatrix();
                }
                GL11.glPopMatrix();
                return true;
            }

            public boolean renderItem(ItemStack itemStack) {
                GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
                this.render(itemStack.func_77960_j(), Byte.parseByte("001100", 2));
                return true;
            }

            public void render(int meta, byte sides) {
                RenderUtility.bind((ResourceLocation)this.TEXTURE);
                double thickness = 0.055;
                double height = 0.5;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) continue;
                    GL11.glPushMatrix();
                    RenderUtility.rotateBlockBasedOnDirection((ForgeDirection)dir);
                    if (WorldUtility.isEnabledSide((byte)sides, (ForgeDirection)ForgeDirection.DOWN)) {
                        GL11.glTranslatef((float)0.0f, (float)-0.075f, (float)0.0f);
                        GL11.glScalef((float)1.0f, (float)1.15f, (float)1.0f);
                    }
                    if (!WorldUtility.isEnabledSide((byte)sides, (ForgeDirection)dir)) {
                        this.MODEL.renderOnly(new String[]{"left"});
                    }
                    if (!WorldUtility.isEnabledSide((byte)sides, (ForgeDirection)dir) || !WorldUtility.isEnabledSide((byte)sides, (ForgeDirection)dir.getRotation(ForgeDirection.UP))) {
                        this.MODEL.renderOnly(new String[]{"backCornerL"});
                    }
                    GL11.glPopMatrix();
                }
                if (!WorldUtility.isEnabledSide((byte)sides, (ForgeDirection)ForgeDirection.DOWN)) {
                    this.MODEL.renderOnly(new String[]{"base"});
                }
            }
        };
    }
}

