/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import openblocks.client.renderer.HeightMapRenderer;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.container.ContainerProjector;
import openblocks.common.tileentity.TileEntityProjector;
import openmods.container.ContainerBase;
import openmods.gui.BaseGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.DummyComponent;
import openmods.gui.component.GuiComponentIconButton;
import openmods.gui.component.IComponentListener;
import openmods.gui.misc.Trackball;
import openmods.utils.MathUtils;
import openmods.utils.render.FakeIcon;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiProjector
extends BaseGuiContainer<ContainerProjector> {
    private static final ResourceLocation texture = new ResourceLocation("openblocks:textures/gui/projector.png");
    private static final int VIEW_HEIGHT = 138;
    private static final int VIEW_WIDTH = 160;
    private Trackball.TrackballWrapper trackball = new Trackball.TrackballWrapper(1, 150);
    private boolean isInitialized;
    private int scale = 90;
    private double mapHeight = 2.0;

    private IComponentListener createRotationListener(final int rotation) {
        return new IComponentListener(){

            public void componentMouseUp(BaseComponent component, int offsetX, int offsetY, int button) {
            }

            public void componentMouseMove(BaseComponent component, int offsetX, int offsetY) {
            }

            public void componentMouseDrag(BaseComponent component, int offsetX, int offsetY, int button, long time) {
            }

            public void componentMouseDown(BaseComponent component, int offsetX, int offsetY, int button) {
                ((ContainerProjector)GuiProjector.this.getContainer()).rotate(rotation);
            }

            public void componentKeyTyped(BaseComponent component, char par1, int par2) {
            }
        };
    }

    public GuiProjector(ContainerProjector container) {
        super((ContainerBase)container, 176, 234, "");
        GuiComponentIconButton buttonLeft = new GuiComponentIconButton(7, 130, 0xFFFFFF, FakeIcon.createSheetIcon((int)176, (int)0, (int)13, (int)13), texture);
        buttonLeft.addListener(this.createRotationListener(-1));
        GuiComponentIconButton buttonRight = new GuiComponentIconButton(152, 130, 0xFFFFFF, FakeIcon.createSheetIcon((int)189, (int)0, (int)-13, (int)13), texture);
        buttonRight.addListener(this.createRotationListener(1));
        this.root.addComponent((BaseComponent)buttonLeft);
        this.root.addComponent((BaseComponent)buttonRight);
    }

    protected BaseComponent createRoot() {
        return new DummyComponent(0, 0, this.field_74194_b, this.field_74195_c);
    }

    public void func_73873_v_() {
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        GL11.glEnable((int)2960);
        GL11.glStencilOp((int)7681, (int)7681, (int)7681);
        GL11.glStencilFunc((int)519, (int)1, (int)1);
        GL11.glDisable((int)2929);
        int left = (this.field_73880_f - this.field_74194_b) / 2;
        int top = (this.field_73881_g - this.field_74195_c) / 2;
        GuiProjector.func_73734_a((int)(left + 8), (int)(top + 8), (int)(left + 8 + 160), (int)(top + 8 + 138), (int)-16777216);
        GL11.glStencilOp((int)0, (int)0, (int)0);
        this.field_73882_e.field_71446_o.func_110577_a(texture);
        this.func_73729_b(left, top, 0, 0, this.field_74194_b, this.field_74195_c);
        GL11.glEnable((int)2929);
        GL11.glStencilOp((int)7680, (int)7680, (int)7680);
        GL11.glStencilFunc((int)517, (int)1, (int)1);
        super.func_73873_v_();
    }

    protected void func_74185_a(float partialTickTime, int mouseX, int mouseY) {
        World world;
        HeightMapData data;
        if (!this.isInitialized || Mouse.isButtonDown((int)2)) {
            this.trackball.setTransform(MathUtils.createEntityRotateMatrix((Entity)Minecraft.func_71410_x().field_71451_h));
            this.isInitialized = true;
        }
        this.mapHeight += (double)Mouse.getDWheel() / 1000.0;
        if (this.mapHeight > 10.0) {
            this.mapHeight = 10.0;
        }
        if (this.mapHeight < -5.0) {
            this.mapHeight = -5.0;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = (this.field_73880_f - this.field_74194_b) / 2;
        int top = (this.field_73881_g - this.field_74195_c) / 2;
        ContainerProjector container = (ContainerProjector)this.getContainer();
        Integer mapId = container.getMapId();
        if (mapId != null && (data = MapDataManager.getMapData(world = ((TileEntityProjector)((Object)container.getOwner())).func_70314_l(), mapId)).isValid()) {
            GL11.glStencilFunc((int)514, (int)1, (int)1);
            GL11.glPushMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int viewMiddleX = left + 8 + 80;
            int viewMiddleY = top + 8 + 69;
            GL11.glTranslatef((float)viewMiddleX, (float)viewMiddleY, (float)50.0f);
            GL11.glScalef((float)this.scale, (float)(-this.scale), (float)this.scale);
            this.trackball.update(mouseX - viewMiddleX, -(mouseY - viewMiddleY));
            GL11.glRotated((double)(90 * container.rotation()), (double)0.0, (double)1.0, (double)0.0);
            GL11.glTranslated((double)-0.5, (double)(-this.mapHeight), (double)-0.5);
            HeightMapRenderer.instance.render(mapId, data);
            GL11.glDisable((int)2896);
            this.drawLevels();
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)2960);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.field_71446_o.func_110577_a(texture);
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.field_74198_m, (double)this.field_74197_n, (double)0.0);
        this.func_73729_b(0, 0, 0, 0, this.field_74194_b, this.field_74195_c);
        this.root.render(this.field_73882_e, 0, 0, mouseX - this.field_74198_m, mouseY - this.field_74197_n);
        GL11.glPopMatrix();
    }

    private void drawLevels() {
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        GL11.glPolygonMode((int)1032, (int)6913);
        GL11.glBegin((int)7);
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        for (int i = 0; i <= 4; ++i) {
            GL11.glVertex3d((double)0.0, (double)i, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)i, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)i, (double)1.0);
            GL11.glVertex3d((double)1.0, (double)i, (double)0.0);
        }
        GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)this.mapHeight, (double)0.0);
        GL11.glVertex3d((double)0.0, (double)this.mapHeight, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)this.mapHeight, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)this.mapHeight, (double)0.0);
        GL11.glEnd();
        GL11.glEnable((int)3553);
        GL11.glPolygonMode((int)1032, (int)6914);
        GL11.glEnable((int)2884);
    }

    protected void func_74189_g(int mouseX, int mouseY) {
    }
}

