/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import java.util.Random;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLightningBolt;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import openblocks.client.model.ModelEgg;
import openblocks.common.tileentity.TileEntityGoldenEgg;
import org.lwjgl.opengl.GL11;

public class TileEntityGoldenEggRenderer
extends TileEntitySpecialRenderer {
    ModelEgg model = new ModelEgg();
    RenderLightningBolt lightningRenderer = new RenderLightningBolt();
    private static final ResourceLocation texture = new ResourceLocation("openblocks", "textures/models/egg.png");

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        GL11.glPushMatrix();
        TileEntityGoldenEgg egg = (TileEntityGoldenEgg)tileentity;
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.0f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        float rotationSpeed = ((float)(18 * egg.animationStageTicks) + f) / 400.0f + 1.0f;
        if (egg.field_70331_k != null && egg.getStage() > 0) {
            egg.rotation += rotationSpeed * f;
            GL11.glRotatef((float)(egg.rotation % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        float amount = ((float)egg.animationStageTicks + f) / 400.0f;
        float totalOffset = amount * 1.0f;
        if (egg.getStage() == 4) {
            GL11.glTranslatef((float)0.0f, (float)(-totalOffset), (float)0.0f);
        }
        this.func_110628_a(texture);
        Tessellator.field_78398_a.func_78380_c(128 + (int)(128.0f * amount));
        this.model.render((TileEntity)egg, f, 1.0f);
        GL11.glPopMatrix();
        if (egg.getStage() >= 4) {
            this.renderPhantom(egg, Tessellator.field_78398_a, f);
            TileEntityGoldenEggRenderer.renderStar(egg, Tessellator.field_78398_a, f);
        }
        GL11.glPopMatrix();
    }

    private static void renderBeam(TileEntityGoldenEgg egg, Tessellator tessellator, float partialTicks) {
        float par2 = 0.0f;
        float par4 = 0.0f;
        float par6 = 0.0f;
        float progress = ((float)egg.animationStageTicks + partialTicks) / 400.0f;
        if ((double)progress > 0.9) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDepthMask((boolean)false);
            for (int i = 45; i < 360; i += 90) {
                tessellator.func_78382_b();
                double size = 1.2 * (((double)progress - 0.8) / (double)0.2f);
                double off = 1.0 - size;
                tessellator.func_78370_a(255, 255, 255, (int)(64.0 * (size / 1.2)));
                double d18 = off;
                double d19 = off;
                double d20 = size;
                double d21 = off;
                double d22 = off;
                double d23 = size;
                double d24 = size;
                double d25 = size;
                double d26 = -(32.0 * size / 1.2);
                double d27 = 0.0;
                double d28 = 1.0;
                double d29 = -1.0;
                double d30 = 256.0;
                tessellator.func_78374_a((double)par2 + d18, (double)par4 + d26, (double)par6 + d19, d28, d30);
                tessellator.func_78374_a((double)par2 + d18, (double)par4 - d26, (double)par6 + d19, d28, d29);
                tessellator.func_78374_a((double)par2 + d20, (double)par4 - d26, (double)par6 + d21, d27, d29);
                tessellator.func_78374_a((double)par2 + d20, (double)par4 + d26, (double)par6 + d21, d27, d30);
                tessellator.func_78374_a((double)par2 + d24, (double)par4 + d26, (double)par6 + d25, d28, d30);
                tessellator.func_78374_a((double)par2 + d24, (double)par4 - d26, (double)par6 + d25, d28, d29);
                tessellator.func_78374_a((double)par2 + d22, (double)par4 - d26, (double)par6 + d23, d27, d29);
                tessellator.func_78374_a((double)par2 + d22, (double)par4 + d26, (double)par6 + d23, d27, d30);
                tessellator.func_78374_a((double)par2 + d20, (double)par4 + d26, (double)par6 + d21, d28, d30);
                tessellator.func_78374_a((double)par2 + d20, (double)par4 - d26, (double)par6 + d21, d28, d29);
                tessellator.func_78374_a((double)par2 + d24, (double)par4 - d26, (double)par6 + d25, d27, d29);
                tessellator.func_78374_a((double)par2 + d24, (double)par4 + d26, (double)par6 + d25, d27, d30);
                tessellator.func_78374_a((double)par2 + d22, (double)par4 + d26, (double)par6 + d23, d28, d30);
                tessellator.func_78374_a((double)par2 + d22, (double)par4 - d26, (double)par6 + d23, d28, d29);
                tessellator.func_78374_a((double)par2 + d18, (double)par4 - d26, (double)par6 + d19, d27, d29);
                tessellator.func_78374_a((double)par2 + d18, (double)par4 + d26, (double)par6 + d19, d27, d30);
                tessellator.func_78381_a();
            }
            GL11.glEnable((int)3553);
            GL11.glDepthMask((boolean)true);
            RenderHelper.func_74519_b();
            GL11.glPopMatrix();
        }
    }

    private void renderPhantom(TileEntityGoldenEgg egg, Tessellator tessellator, float partialTicks) {
        float SCALE = 1.5f;
        GL11.glPushMatrix();
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        float progress = ((float)egg.animationStageTicks + partialTicks) / 400.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.4f * progress * 2.0f));
        GL11.glRotatef((float)(egg.rotation % 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(-progress * 1.5f * (0.2f + progress * 0.8f)), (float)0.0f);
        tessellator.func_78380_c(255);
        this.model.render((TileEntity)egg, partialTicks, 1.5f * (0.2f + progress * 0.8f));
        GL11.glDisable((int)3042);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    private static void renderStar(TileEntityGoldenEgg egg, Tessellator tessellator, float partialTicks) {
        GL11.glPushMatrix();
        float f1 = ((float)egg.animationStageTicks + partialTicks) / 400.0f;
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)(-f1), (float)0.0f);
        GL11.glRotatef((float)(egg.rotation * -0.2f % 360.0f), (float)0.5f, (float)1.0f, (float)0.5f);
        float BEAM_START_DISTANCE = 2.0f;
        float BEAM_END_DISTANCE = 10.0f;
        float MAX_OPACITY = 192.0f;
        RenderHelper.func_74518_a();
        float f2 = 0.0f;
        if (f1 > 0.8f) {
            f2 = (f1 - 0.8f) / 0.2f;
        }
        Random random = new Random(432L);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)2884);
        GL11.glDepthMask((boolean)false);
        GL11.glPushMatrix();
        int i = 0;
        while ((float)i < (f1 + f1 * f1) / 2.0f * 60.0f) {
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(random.nextFloat() * 360.0f + f1 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(6);
            float f3 = random.nextFloat() * BEAM_END_DISTANCE + 5.0f + f2 * 10.0f;
            float f4 = random.nextFloat() * BEAM_START_DISTANCE + 1.0f + f2 * 2.0f;
            tessellator.func_78380_c(255);
            tessellator.func_78384_a(0xFFFFFF, (int)(MAX_OPACITY * (1.0f - f2)));
            tessellator.func_78377_a(0.0, 0.0, 0.0);
            tessellator.func_78384_a(16766720, 0);
            tessellator.func_78377_a(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4));
            tessellator.func_78377_a(0.866 * (double)f4, (double)f3, (double)(-0.5f * f4));
            tessellator.func_78377_a(0.0, (double)f3, (double)(1.0f * f4));
            tessellator.func_78377_a(-0.866 * (double)f4, (double)f3, (double)(-0.5f * f4));
            tessellator.func_78381_a();
            ++i;
        }
        GL11.glPopMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glShadeModel((int)7424);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }
}

