/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderFlat;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.event.ForgeSubscribe;
import openblocks.api.IStructureGenProvider;
import openblocks.api.IStructureNamer;
import openblocks.api.events.RegisterStructureGenProvider;
import openblocks.api.events.RegisterStructureIdentifierEvent;
import openmods.Log;

public class StructureRegistry {
    private List<IStructureNamer> names = Lists.newArrayList();
    private List<IStructureGenProvider> providers;
    public static final StructureRegistry instance = new StructureRegistry();

    @ForgeSubscribe
    public void registerIdentifier(RegisterStructureIdentifierEvent evt) {
        if (evt.namer != null) {
            this.names.add(evt.namer);
        }
    }

    private String identifyStructure(MapGenStructure structure) {
        for (IStructureNamer n : this.names) {
            String name = n.identify(structure);
            if (Strings.isNullOrEmpty((String)name)) continue;
            return name;
        }
        return structure.func_143025_a();
    }

    private static <T> void addMapGen(Collection<MapGenStructure> output, Class<T> klazz, T provider, String ... names) {
        try {
            MapGenStructure struct = (MapGenStructure)ReflectionHelper.getPrivateValue(klazz, provider, (String[])names);
            if (struct != null) {
                output.add(struct);
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            Log.warn((Throwable)e, (String)"Can't access fields %s from provider %s. Some structures may not be detected", (Object[])new Object[]{Arrays.toString(names), provider});
        }
    }

    @ForgeSubscribe
    public void registerProvider(RegisterStructureGenProvider evt) {
        if (evt.provider != null) {
            this.providers.add(evt.provider);
        }
    }

    private StructureRegistry() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new IStructureGenProvider(){

            @Override
            public boolean canUseOnProvider(IChunkProvider provider) {
                return provider instanceof ChunkProviderGenerate;
            }

            @Override
            public Collection<MapGenStructure> listProviders(IChunkProvider provider) {
                ChunkProviderGenerate cp = (ChunkProviderGenerate)provider;
                ArrayList result = Lists.newArrayList();
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"strongholdGenerator", "field_73225_u"});
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"villageGenerator", "field_73224_v"});
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"mineshaftGenerator", "field_73223_w"});
                StructureRegistry.addMapGen(result, ChunkProviderGenerate.class, cp, new String[]{"scatteredFeatureGenerator", "field_73233_x"});
                return result;
            }
        });
        builder.add((Object)new IStructureGenProvider(){

            @Override
            public boolean canUseOnProvider(IChunkProvider provider) {
                return provider instanceof ChunkProviderFlat;
            }

            @Override
            public Collection<MapGenStructure> listProviders(IChunkProvider provider) {
                ChunkProviderFlat cp = (ChunkProviderFlat)provider;
                ArrayList result = Lists.newArrayList();
                try {
                    List gen = (List)ReflectionHelper.getPrivateValue(ChunkProviderFlat.class, (Object)cp, (String[])new String[]{"structureGenerators", "field_82696_f"});
                    if (gen != null) {
                        result.addAll(gen);
                    }
                }
                catch (ReflectionHelper.UnableToAccessFieldException e) {
                    Log.warn((Throwable)e, (String)"Can't access map gen list from provider %s. Some structures may not be detected", (Object[])new Object[]{provider});
                }
                return result;
            }
        });
        builder.add((Object)new IStructureGenProvider(){

            @Override
            public boolean canUseOnProvider(IChunkProvider provider) {
                return provider instanceof ChunkProviderHell;
            }

            @Override
            public Collection<MapGenStructure> listProviders(IChunkProvider provider) {
                ChunkProviderHell cp = (ChunkProviderHell)provider;
                ArrayList result = Lists.newArrayList();
                StructureRegistry.addMapGen(result, ChunkProviderHell.class, cp, new String[]{"genNetherBridge", "field_73172_c"});
                return result;
            }
        });
        this.providers = builder.build();
    }

    public Map<String, ChunkPosition> getNearestStructures(WorldServer world, int x, int y, int z) {
        ChunkProviderServer provider = world.field_73059_b;
        try {
            IChunkProvider inner = (IChunkProvider)ReflectionHelper.getPrivateValue(ChunkProviderServer.class, (Object)provider, (String[])new String[]{"currentChunkProvider", "field_73246_d"});
            if (inner != null) {
                for (IStructureGenProvider p : this.providers) {
                    if (!p.canUseOnProvider(inner)) continue;
                    HashMap result = Maps.newHashMap();
                    for (MapGenStructure struct : p.listProviders(inner)) {
                        try {
                            String structType;
                            ChunkPosition structPos = struct.func_75050_a((World)world, x, y, z);
                            if (structPos == null || Strings.isNullOrEmpty((String)(structType = this.identifyStructure(struct)))) continue;
                            result.put(structType, structPos);
                        }
                        catch (IndexOutOfBoundsException e) {}
                    }
                    return result;
                }
            }
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            Log.warn((Throwable)e, (String)"Can't access chunk provider data. No structures will be detected", (Object[])new Object[0]);
        }
        return ImmutableMap.of();
    }
}

