/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityTrophy;
import openblocks.trophy.BlazeBehavior;
import openblocks.trophy.CaveSpiderBehavior;
import openblocks.trophy.CreeperBehavior;
import openblocks.trophy.EndermanBehavior;
import openblocks.trophy.ITrophyBehavior;
import openblocks.trophy.ItemDropBehavior;
import openblocks.trophy.MooshroomBehavior;
import openblocks.trophy.SkeletonBehavior;
import openblocks.trophy.SnowmanBehavior;
import openblocks.trophy.SquidBehavior;
import openmods.Log;
import openmods.utils.BlockUtils;
import openmods.utils.ItemUtils;
import openmods.utils.ReflectionHelper;

public class TrophyHandler {
    public static Map<Trophy, Entity> entityCache = Maps.newHashMap();

    public static Entity getEntityFromCache(Trophy trophy) {
        Entity entity = entityCache.get((Object)trophy);
        if (entity == null) {
            entity = trophy.createEntity();
            entityCache.put(trophy, entity);
        }
        return entity;
    }

    @ForgeSubscribe
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        String entityName;
        if (!event.entity.field_70170_p.field_72995_K && Math.random() < Config.trophyDropChance && (entityName = EntityList.func_75621_b((Entity)(entity = event.entity))) != null && !entityName.isEmpty()) {
            try {
                Trophy mobTrophy = Trophy.valueOf(entityName);
                BlockUtils.dropItemStackInWorld((World)entity.field_70170_p, (double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v, (ItemStack)mobTrophy.getItemStack());
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public static enum Trophy {
        Wolf,
        Chicken(new ItemDropBehavior(10000, Item.field_77764_aP.field_77779_bT, "mob.chicken.plop")),
        Cow(new ItemDropBehavior(20000, Item.field_77770_aF.field_77779_bT)),
        Creeper(new CreeperBehavior()),
        Skeleton(new SkeletonBehavior()),
        PigZombie(new ItemDropBehavior(20000, Item.field_77733_bq.field_77779_bT)),
        Bat(1.0, -0.3),
        Zombie,
        Witch(0.35),
        Villager,
        Ozelot{

            @Override
            protected Entity createEntity() {
                Entity entity = super.createEntity();
                try {
                    ((EntityOcelot)entity).func_70903_f(true);
                }
                catch (ClassCastException e) {
                    Log.warn((String)"Invalid cat entity class: %s", (Object[])new Object[]{entity.getClass()});
                }
                return entity;
            }
        }
        ,
        Sheep,
        Blaze(new BlazeBehavior()),
        Silverfish,
        Spider,
        CaveSpider(new CaveSpiderBehavior()),
        Slime(0.6){

            @Override
            protected Entity createEntity() {
                Entity entity = super.createEntity();
                try {
                    ReflectionHelper.call((Object)entity, (String[])new String[]{"func_70799_a", "setSlimeSize"}, (Object[])new Object[]{ReflectionHelper.primitive((int)1)});
                }
                catch (Exception e) {
                    Log.warn((Throwable)e, (String)"Can't update slime size", (Object[])new Object[0]);
                }
                return entity;
            }
        }
        ,
        Ghast(0.1, 0.2),
        Enderman(0.3, new EndermanBehavior()),
        LavaSlime(0.6),
        Squid(0.3, 0.5, new SquidBehavior()),
        MushroomCow(new MooshroomBehavior()),
        VillagerGolem(0.3),
        SnowMan(new SnowmanBehavior()),
        Pig(new ItemDropBehavior(20000, Item.field_77784_aq.field_77779_bT));

        private double scale = 0.4;
        private double verticalOffset = 0.0;
        private ITrophyBehavior behavior;
        public static final Trophy[] VALUES;

        private Trophy() {
        }

        private Trophy(ITrophyBehavior behavior) {
            this.behavior = behavior;
        }

        private Trophy(double scale) {
            this.scale = scale;
        }

        private Trophy(double scale, ITrophyBehavior behavior) {
            this.scale = scale;
            this.behavior = behavior;
        }

        private Trophy(double scale, double verticalOffset) {
            this(scale);
            this.verticalOffset = verticalOffset;
        }

        private Trophy(double scale, double verticalOffset, ITrophyBehavior behavior) {
            this(scale, verticalOffset);
            this.behavior = behavior;
        }

        public double getVerticalOffset() {
            return this.verticalOffset;
        }

        public double getScale() {
            return this.scale;
        }

        public Entity getEntity() {
            return TrophyHandler.getEntityFromCache(this);
        }

        public ItemStack getItemStack() {
            ItemStack stack = new ItemStack((Block)OpenBlocks.Blocks.trophy, 1, this.ordinal());
            NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
            tag.func_74778_a("entity", this.toString());
            return stack;
        }

        public void playSound(World world, double x, double y, double z) {
            Entity e = this.getEntity();
            e.field_70165_t = x;
            e.field_70163_u = y;
            e.field_70161_v = z;
            e.field_70170_p = world;
            if (e instanceof EntityLiving && world != null) {
                ((EntityLiving)e).func_70642_aH();
            }
        }

        public void executeActivateBehavior(TileEntityTrophy tile, EntityPlayer player) {
            if (this.behavior != null) {
                this.behavior.executeActivateBehavior(tile, player);
            }
        }

        public void executeTickBehavior(TileEntityTrophy tile) {
            if (this.behavior != null) {
                this.behavior.executeTickBehavior(tile);
            }
        }

        protected Entity createEntity() {
            return EntityList.func_75620_a((String)this.toString(), null);
        }

        static {
            VALUES = Trophy.values();
        }
    }
}

