/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.Stencil;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityCanvas;

public class BlockCanvas
extends OpenBlock {
    private int layer = 0;
    private int renderSide = 0;
    public Icon baseIcon;

    public BlockCanvas() {
        super(Config.blockCanvasId, Material.field_76248_c);
    }

    public BlockCanvas(int id, Material material) {
        super(id, material);
    }

    public void func_94332_a(IconRegister registry) {
        this.baseIcon = registry.func_94245_a("openblocks:canvas");
        for (Stencil stencil : Stencil.values()) {
            stencil.registerBlockIcons(registry);
        }
        super.func_94332_a(registry);
    }

    protected void getCustomTileEntityDrops(TileEntity te, List<ItemStack> result) {
        if (!(te instanceof TileEntityCanvas)) {
            return;
        }
        TileEntityCanvas tile = (TileEntityCanvas)te;
        int maskedBlockId = tile.paintedBlockId.getValue();
        Block maskedBlock = Block.field_71973_m[maskedBlockId];
        if (maskedBlock == null) {
            return;
        }
        int maskedMeta = tile.paintedBlockMeta.getValue();
        for (int i = 0; i < maskedBlock.func_71925_a(te.field_70331_k.field_73012_v); ++i) {
            int droppedId = maskedBlock.func_71885_a(maskedMeta, te.field_70331_k.field_73012_v, 0);
            Block dropped = Block.field_71973_m[droppedId];
            if (dropped == null) continue;
            result.add(new ItemStack(dropped, 1, maskedBlock.func_71899_b(maskedMeta)));
        }
    }

    protected boolean hasNormalDrops() {
        return false;
    }

    public boolean shouldRenderBlock() {
        return true;
    }

    public void setLayerForRender(int layer) {
        this.layer = layer;
    }

    public void setSideForRender(int side) {
        this.renderSide = side;
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        return side == this.renderSide && super.func_71877_c(world, x, y, z, side);
    }

    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class));
        return tile != null ? tile.getColorForRender(this.renderSide, this.layer) : -1;
    }

    public Icon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)BlockCanvas.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityCanvas.class));
        if (tile != null) {
            return tile.getTextureForRender(this.renderSide, this.layer);
        }
        return super.getUnrotatedTexture(direction, world, x, y, z);
    }

    public static void replaceBlock(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Material material = world.func_72803_f(x, y, z);
        if (material == Material.field_76264_q) {
            world.func_94575_c(x, y, z, OpenBlocks.Blocks.canvasGlass.field_71990_ca);
        } else {
            world.func_94575_c(x, y, z, OpenBlocks.Blocks.canvas.field_71990_ca);
        }
        TileEntityCanvas tile = (TileEntityCanvas)world.func_72796_p(x, y, z);
        tile.paintedBlockId.setValue(id);
        tile.paintedBlockMeta.setValue(meta);
    }
}

