/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.client.gui.GuiItemDropper;
import openblocks.common.container.ContainerItemDropper;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.IHasGui;
import openmods.api.INeighbourAwareTile;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.InventoryUtils;
import openmods.utils.OpenModsFakePlayer;

public class TileEntityItemDropper
extends OpenTileEntity
implements INeighbourAwareTile,
IInventoryProvider,
IExtendable,
IHasGui {
    static final int BUFFER_SIZE = 9;
    private boolean _redstoneSignal;
    private GenericInventory inventory = new GenericInventory("itemDropper", false, 9);

    public void setRedstoneSignal(boolean redstoneSignal) {
        if (redstoneSignal != this._redstoneSignal) {
            this._redstoneSignal = redstoneSignal;
            if (this._redstoneSignal && !InventoryUtils.inventoryIsEmpty((IInventory)this.inventory)) {
                this.dropItem();
            }
        }
    }

    private void dropItem() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        int l = this.inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a == 0) continue;
            ItemStack dropped = stack.func_77979_a(1);
            if (stack.field_77994_a <= 0) {
                this.inventory.func_70299_a(i, null);
            }
            OpenModsFakePlayer.getPlayerForWorld((World)this.field_70331_k).dropItemAt(dropped, this.field_70329_l, this.field_70330_m, this.field_70327_n, ForgeDirection.DOWN);
            return;
        }
    }

    public void onNeighbourChanged(int blockId) {
        if (!this.field_70331_k.field_72995_K) {
            this.setRedstoneSignal(this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerItemDropper((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiItemDropper(new ContainerItemDropper((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }
}

