/*
 * Decompiled with CFR 0.152.
 */
package com.voidzm.novamenu.gui;

import com.voidzm.novamenu.asm.NovamenuPlugin;
import com.voidzm.novamenu.gui.GuiButtonTransparent;
import com.voidzm.novamenu.gui.GuiNovamenuCreateWorld;
import com.voidzm.novamenu.gui.GuiNovamenuMainMenu;
import com.voidzm.novamenu.gui.GuiNovamenuRenameWorld;
import com.voidzm.novamenu.gui.GuiNovamenuScreen;
import com.voidzm.novamenu.gui.GuiNovamenuWorldSlot;
import com.voidzm.novamenu.gui.GuiNovamenuYesNo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumGameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveFormatComparator;
import net.minecraft.world.storage.WorldInfo;

public class GuiNovamenuSelectWorld
extends GuiNovamenuScreen {
    private final DateFormat dateFormat = new SimpleDateFormat();
    private GuiNovamenuMainMenu parent;
    private String title;
    private boolean selected = false;
    private int selectedWorld;
    private List saveList;
    private GuiNovamenuWorldSlot worldSlotContainer;
    private String localizedWorldText;
    private String localizedConvertText;
    private String[] localizedGamemodeText = new String[3];
    private boolean deleting;
    private GuiButtonTransparent buttonDelete;
    private GuiButtonTransparent buttonSelect;
    private GuiButtonTransparent buttonRename;
    private GuiButtonTransparent buttonRecreate;

    public GuiNovamenuSelectWorld(GuiNovamenuMainMenu parentScreen) {
        this.parent = parentScreen;
        this.imageTick = parentScreen.imageTick;
    }

    public void func_73866_w_() {
        this.title = I18n.func_135053_a((String)"selectWorld.title");
        try {
            this.loadSaves();
        }
        catch (AnvilConverterException e) {
            e.printStackTrace();
            this.field_73882_e.func_71373_a((GuiScreen)new GuiErrorScreen("Unable to load worlds!", e.getMessage()));
            return;
        }
        this.localizedWorldText = I18n.func_135053_a((String)"selectWorld.world");
        this.localizedConvertText = I18n.func_135053_a((String)"selectWorld.conversion");
        this.localizedGamemodeText[EnumGameType.SURVIVAL.func_77148_a()] = I18n.func_135053_a((String)"gameMode.survival");
        this.localizedGamemodeText[EnumGameType.CREATIVE.func_77148_a()] = I18n.func_135053_a((String)"gameMode.creative");
        this.localizedGamemodeText[EnumGameType.ADVENTURE.func_77148_a()] = I18n.func_135053_a((String)"gameMode.adventure");
        this.worldSlotContainer = new GuiNovamenuWorldSlot(this);
        this.worldSlotContainer.registerScrollButtons(this.field_73887_h, 4, 5);
        this.initButtons();
    }

    private void loadSaves() throws AnvilConverterException {
        ISaveFormat format = this.field_73882_e.func_71359_d();
        this.saveList = format.func_75799_b();
        Collections.sort(this.saveList);
        this.selectedWorld = -1;
    }

    protected String getSaveFileName(int par1) {
        return ((SaveFormatComparator)this.saveList.get(par1)).func_75786_a();
    }

    protected String getSaveName(int par1) {
        String s = ((SaveFormatComparator)this.saveList.get(par1)).func_75788_b();
        if (s == null || MathHelper.func_76139_a((String)s)) {
            s = I18n.func_135053_a((String)"selectWorld.world") + " " + (par1 + 1);
        }
        return s;
    }

    public void initButtons() {
        this.buttons.clear();
        this.buttonSelect = new GuiButtonTransparent(this, this.field_73880_f / 2 - 154, this.field_73881_g - 60, 150, 16, 1, I18n.func_135053_a((String)"selectWorld.select"));
        this.buttons.add(this.buttonSelect);
        this.buttons.add(new GuiButtonTransparent(this, this.field_73880_f / 2 + 4, this.field_73881_g - 60, 150, 16, 3, I18n.func_135053_a((String)"selectWorld.create")));
        this.buttonRename = new GuiButtonTransparent(this, this.field_73880_f / 2 - 154, this.field_73881_g - 36, 72, 16, 6, I18n.func_135053_a((String)"selectWorld.rename"));
        this.buttons.add(this.buttonRename);
        this.buttonDelete = new GuiButtonTransparent(this, this.field_73880_f / 2 - 76, this.field_73881_g - 36, 72, 16, 2, I18n.func_135053_a((String)"selectWorld.delete"));
        this.buttons.add(this.buttonDelete);
        this.buttonRecreate = new GuiButtonTransparent(this, this.field_73880_f / 2, this.field_73881_g - 36, 80, 16, 7, I18n.func_135053_a((String)"selectWorld.recreate"));
        this.buttons.add(this.buttonRecreate);
        this.buttons.add(new GuiButtonTransparent(this, this.field_73880_f / 2 + 82, this.field_73881_g - 36, 72, 16, 0, I18n.func_135053_a((String)"gui.cancel")));
        this.buttonSelect.enabled = false;
        this.buttonDelete.enabled = false;
        this.buttonRename.enabled = false;
        this.buttonRecreate.enabled = false;
    }

    public void selectWorld(int par1) {
        this.field_73882_e.func_71373_a((GuiScreen)null);
        if (!this.selected) {
            String s1;
            this.selected = true;
            String s = this.getSaveFileName(par1);
            if (s == null) {
                s = "World" + par1;
            }
            if ((s1 = this.getSaveName(par1)) == null) {
                s1 = "World" + par1;
            }
            if (this.field_73882_e.func_71359_d().func_90033_f(s)) {
                this.field_73882_e.func_71371_a(s, s1, (WorldSettings)null);
            }
        }
    }

    public void func_73878_a(boolean par1, int par2) {
        if (this.deleting) {
            this.deleting = false;
            if (par1) {
                ISaveFormat isaveformat = this.field_73882_e.func_71359_d();
                isaveformat.func_75800_d();
                isaveformat.func_75802_e(this.getSaveFileName(par2));
                try {
                    this.loadSaves();
                }
                catch (AnvilConverterException anvilconverterexception) {
                    anvilconverterexception.printStackTrace();
                }
            }
            this.field_73882_e.func_71373_a((GuiScreen)this);
        }
    }

    @Override
    public void drawScreenForeground(int mouseX, int mouseY, float tick) {
        GuiNovamenuSelectWorld.func_73734_a((int)0, (int)0, (int)this.field_73880_f, (int)48, (int)-1157627904);
        GuiNovamenuSelectWorld.func_73734_a((int)0, (int)48, (int)this.field_73880_f, (int)49, (int)-587202560);
        GuiNovamenuSelectWorld.func_73734_a((int)0, (int)49, (int)this.field_73880_f, (int)(this.field_73881_g - 81), (int)-2013265920);
        GuiNovamenuSelectWorld.func_73734_a((int)0, (int)(this.field_73881_g - 81), (int)this.field_73880_f, (int)(this.field_73881_g - 80), (int)-587202560);
        GuiNovamenuSelectWorld.func_73734_a((int)0, (int)(this.field_73881_g - 80), (int)this.field_73880_f, (int)this.field_73881_g, (int)-1157627904);
        this.worldSlotContainer.drawScreen(mouseX, mouseY, tick);
        this.func_73732_a(this.field_73886_k, this.title, this.field_73880_f / 2, 20, 0xFFFFFF);
        super.drawScreenForeground(mouseX, mouseY, tick);
    }

    public static GuiNovamenuYesNo getDeleteWorldScreen(GuiNovamenuScreen par0GuiScreen, String par1Str, int par2) {
        String s1 = I18n.func_135053_a((String)"selectWorld.deleteQuestion");
        String s2 = "'" + par1Str + "' " + I18n.func_135053_a((String)"selectWorld.deleteWarning");
        String s3 = I18n.func_135053_a((String)"selectWorld.deleteButton");
        String s4 = I18n.func_135053_a((String)"gui.cancel");
        GuiNovamenuYesNo confirmDelete = new GuiNovamenuYesNo(par0GuiScreen, s1, s2, s3, s4, par2);
        return confirmDelete;
    }

    public static List getSize(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.saveList;
    }

    public static int onElementSelected(GuiNovamenuSelectWorld par0GuiSelectWorld, int par1) {
        par0GuiSelectWorld.selectedWorld = par1;
        return par0GuiSelectWorld.selectedWorld;
    }

    public static int getSelectedWorld(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.selectedWorld;
    }

    public static GuiButtonTransparent getSelectButton(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.buttonSelect;
    }

    public static GuiButtonTransparent getRenameButton(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.buttonDelete;
    }

    public static GuiButtonTransparent getDeleteButton(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.buttonRename;
    }

    public static GuiButtonTransparent func_82312_f(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.buttonRecreate;
    }

    public static String func_82313_g(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.localizedWorldText;
    }

    public static DateFormat func_82315_h(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.dateFormat;
    }

    public static String func_82311_i(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.localizedConvertText;
    }

    public static String[] func_82314_j(GuiNovamenuSelectWorld par0GuiSelectWorld) {
        return par0GuiSelectWorld.localizedGamemodeText;
    }

    public FontRenderer fontRenderer() {
        return this.field_73886_k;
    }

    @Override
    public void buttonEvent(int id) {
        switch (id) {
            case 0: {
                this.parent.imageTick = this.imageTick;
                this.field_73882_e.func_71373_a((GuiScreen)this.parent);
                break;
            }
            case 1: {
                this.selectWorld(this.selectedWorld);
                break;
            }
            case 2: {
                String s = this.getSaveName(this.selectedWorld);
                if (s == null) break;
                this.deleting = true;
                GuiNovamenuYesNo confirmDelete = GuiNovamenuSelectWorld.getDeleteWorldScreen(this, s, this.selectedWorld);
                this.field_73882_e.func_71373_a((GuiScreen)confirmDelete);
                break;
            }
            case 3: {
                if (NovamenuPlugin.getConfiguration().useCustomCreateWorldMenu) {
                    this.field_73882_e.func_71373_a((GuiScreen)new GuiNovamenuCreateWorld(this));
                    break;
                }
                this.field_73882_e.func_71373_a((GuiScreen)new GuiCreateWorld((GuiScreen)this));
                break;
            }
            case 6: {
                this.field_73882_e.func_71373_a((GuiScreen)new GuiNovamenuRenameWorld(this, this.getSaveFileName(this.selectedWorld)));
                break;
            }
            case 7: {
                if (NovamenuPlugin.getConfiguration().useCustomCreateWorldMenu) {
                    GuiNovamenuCreateWorld guicreateworld = new GuiNovamenuCreateWorld(this);
                    ISaveHandler isavehandler = this.field_73882_e.func_71359_d().func_75804_a(this.getSaveFileName(this.selectedWorld), false);
                    WorldInfo worldinfo = isavehandler.func_75757_d();
                    isavehandler.func_75759_a();
                    guicreateworld.func_82286_a(worldinfo);
                    this.field_73882_e.func_71373_a((GuiScreen)guicreateworld);
                    break;
                }
                GuiCreateWorld guicreateworld = new GuiCreateWorld((GuiScreen)this);
                ISaveHandler isavehandler = this.field_73882_e.func_71359_d().func_75804_a(this.getSaveFileName(this.selectedWorld), false);
                WorldInfo worldinfo = isavehandler.func_75757_d();
                isavehandler.func_75759_a();
                guicreateworld.func_82286_a(worldinfo);
                this.field_73882_e.func_71373_a((GuiScreen)guicreateworld);
            }
        }
    }
}

