/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cofh.network.Payload;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.device.BlockDevice;

public class TileTinkerBench
extends TileInventory
implements IEnergyHandler {
    EnergyStorage energyStorage;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileTinkerBench.class, (String)"cofh.thermalexpansion.Workbench");
    }

    public TileTinkerBench() {
        this.inventory = new ItemStack[18];
        this.energyStorage = new EnergyStorage(12000, 640);
    }

    public boolean canUpdate() {
        return false;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.PLACE_HOLDER.ordinal();
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public void handleTilePacket(Payload payload) {
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.energyStorage.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.energyStorage.writeToNBT(nbt);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        return from.ordinal() != 1;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }
}

