/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.lamp;

import cofh.block.ITileInfo;
import cofh.network.ITilePacketHandler;
import cofh.network.Payload;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.TileTEBase;

public class TileLamp
extends TileTEBase
implements ITilePacketHandler,
ITileInfo {
    public boolean modified;
    byte mode;
    int lightValue;
    int color = 0xFFFFFF;
    int renderColor = -1431655681;
    public boolean isPowered;
    public byte inputPower;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileLamp.class, (String)"cofh.thermalexpansion.Lamp");
    }

    public boolean canUpdate() {
        return false;
    }

    public String getName() {
        return "tile.thermalexpansion.lamp.name";
    }

    public int getType() {
        return 0;
    }

    public int getLightValue() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return this.lightValue;
        }
        switch (this.mode) {
            case 0: {
                return this.isPowered ? 15 : 0;
            }
            case 1: {
                return this.isPowered ? 0 : 15;
            }
            case 2: {
                return this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            case 3: {
                return 15 - this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public void onNeighborBlockChange() {
        boolean wasPowered = this.isPowered;
        byte oldPower = this.inputPower;
        this.isPowered = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.inputPower = (byte)this.field_70331_k.func_94577_B(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (wasPowered != this.isPowered || oldPower != this.inputPower) {
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public boolean onWrench(EntityPlayer player, int bSide) {
        this.mode = (byte)(this.mode + 1);
        this.mode = (byte)(this.mode % 6);
        this.sendUpdatePacket(Side.CLIENT);
        player.func_71035_c(StringHelper.localize((String)("message.thermalexpansion.lamp" + this.mode)));
        return true;
    }

    public int getColorMultiplier() {
        return this.renderColor;
    }

    public boolean resetColor() {
        if (!this.modified) {
            return false;
        }
        this.modified = false;
        this.color = 0xFFFFFF;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setColor(int color) {
        this.modified = true;
        this.color = color;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addBool(this.modified);
        payload.addInt(this.color);
        payload.addByte(this.mode);
        payload.addByte(this.getLightValue());
        payload.addBool(this.isPowered);
        payload.addByte(this.inputPower);
        return payload;
    }

    public void handleTilePacket(Payload payload) {
        this.modified = payload.getBool();
        this.color = payload.getInt();
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.mode = payload.getByte();
            this.lightValue = payload.getByte();
            int colorMod = 10 + this.getLightValue() / 3;
            int red = (this.color >> 16 & 0xFF) * colorMod / 15;
            int green = (this.color >> 8 & 0xFF) * colorMod / 15;
            int blue = (this.color & 0xFF) * colorMod / 15;
            this.renderColor = (red << 24) + (green << 16) + (blue << 8) + 255;
            this.isPowered = payload.getBool();
            this.inputPower = payload.getByte();
        }
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.modified = nbt.func_74767_n("Modified");
        this.mode = nbt.func_74771_c("Mode");
        this.color = nbt.func_74762_e("Color");
        this.isPowered = nbt.func_74767_n("Powered");
        this.inputPower = nbt.func_74771_c("Signal");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74757_a("Modified", this.modified);
        nbt.func_74774_a("Mode", this.mode);
        nbt.func_74768_a("Color", this.color);
        nbt.func_74757_a("Powered", this.isPowered);
        nbt.func_74774_a("Signal", this.inputPower);
    }

    public void getTileInfo(List<String> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        if (debug) {
            return;
        }
        info.add(StringHelper.localize((String)("message.thermalexpansion.lamp" + this.mode)));
    }
}

