/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.api.energy.IEnergyContainerItem;
import cofh.util.EnergyHelper;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;

public class TileCharger
extends TileMachineEnergized {
    public static final int TYPE = BlockMachine.Types.CHARGER.ordinal();
    int outputTracker;

    public static void initialize() {
        TileCharger.sideData[TileCharger.TYPE] = new TileMachineBase.SideConfig();
        TileCharger.sideData[TileCharger.TYPE].numGroup = 3;
        TileCharger.sideData[TileCharger.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}};
        TileCharger.sideData[TileCharger.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileCharger.sideData[TileCharger.TYPE].allowExtraction = new boolean[]{false, false, true};
        TileCharger.sideData[TileCharger.TYPE].sideTex = new int[]{0, 1, 4};
        TileCharger.energyData[TileCharger.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(1, 10000, 400000);
        TileCharger.guiIds[TileCharger.TYPE] = ThermalExpansion.proxy.registerGui("Charger", "machine", true);
        GameRegistry.registerTileEntity(TileCharger.class, (String)"cofh.thermalexpansion.Charger");
    }

    public TileCharger() {
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[2];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public boolean hasChargeSlot() {
        return false;
    }

    @Override
    protected boolean canStart() {
        return this.inventory[1] == null && EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0]) && this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    protected void processFinish() {
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.inventory[0], (int)1);
        this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
    }

    @Override
    protected void transferProducts() {
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.transferItem(1, 1, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            int energy = Math.min(this.energyStorage.getEnergyStored(), this.getEnergyPerTick());
            if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
                IEnergyContainerItem theItem = (IEnergyContainerItem)this.inventory[0].func_77973_b();
                this.energyStorage.extractEnergy(theItem.receiveEnergy(this.inventory[0], energy, false), false);
                if (theItem.getEnergyStored(this.inventory[0]) >= theItem.getMaxEnergyStored(this.inventory[0]) || this.energyStorage.getEnergyStored() > 0 && energy <= 0) {
                    this.processFinish();
                    this.transferProducts();
                    if (!this.redstoneControlOrDisable() || !this.canStart()) {
                        this.isActive = false;
                        this.wasActive = true;
                        this.tracker.markTime(this.field_70331_k);
                    }
                }
            } else if (this.energyStorage.getEnergyStored() <= 0 || this.inventory[1] == null) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.timeCheck()) {
                this.transferProducts();
            }
            if (this.canStart()) {
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
    }

    @Override
    public int getEnergyPerTick() {
        if (!this.isActive || this.inventory[0] == null) {
            return 0;
        }
        int power = 0;
        power = this.energyStorage.getEnergyStored() > this.energyConfig.maxPowerLevel ? this.energyConfig.maxPower : (this.energyStorage.getEnergyStored() < this.energyConfig.energyRamp ? this.energyConfig.minPower : this.energyStorage.getEnergyStored() / this.energyConfig.energyRamp);
        return Math.min(power, ((IEnergyContainerItem)this.inventory[0].func_77973_b()).receiveEnergy(this.inventory[0], power, true));
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTracker = nbt.func_74762_e("Tracker");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Tracker", this.outputTracker);
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (super.func_102007_a(slot, stack, side)) {
            return stack == null ? false : stack.func_77973_b() instanceof IEnergyContainerItem;
        }
        return false;
    }
}

