/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.strongbox;

import cofh.api.tileentity.IReconfigurableFacing;
import cofh.api.tileentity.ISecureTile;
import cofh.network.ITilePacketHandler;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.strongbox.BlockStrongbox;
import thermalexpansion.core.TEProps;
import thermalexpansion.gui.container.ContainerStrongbox;

public class TileStrongbox
extends TileInventory
implements ISecureTile,
IReconfigurableFacing,
ISidedInventory,
ITilePacketHandler {
    protected static int guiId;
    protected static final int[] INV_SIZE;
    protected static final int[][] SLOTS;
    public static boolean enableSecurity;
    String owner = "[None]";
    private ISecureTile.AccessMode access = ISecureTile.AccessMode.PUBLIC;
    public byte type;
    public byte facing = (byte)3;
    public double prevLidAngle;
    public double lidAngle;
    public int numUsingPlayers;
    public boolean canAccess = true;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileStrongbox.class, (String)"cofh.thermalexpansion.Strongbox");
        guiId = ThermalExpansion.proxy.registerGui("Strongbox", null, true);
    }

    public static void configure() {
        String comment = "Enable this to allow for Strongboxes to be secure inventories. (Default: true)";
        enableSecurity = ThermalExpansion.config.get("block.security", "Strongbox.Secure", enableSecurity, comment);
    }

    public TileStrongbox() {
    }

    public TileStrongbox(int metadata) {
        this.type = (byte)metadata;
        this.inventory = new ItemStack[INV_SIZE[this.type]];
    }

    public String getName() {
        return "tile.thermalexpansion.strongbox." + BlockStrongbox.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public double getRadianLidAngle(float f) {
        double a = MathHelper.interpolate((double)this.prevLidAngle, (double)this.lidAngle, (double)f);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * Math.PI * -0.5;
    }

    public void getNumPlayers() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.numUsingPlayers != 0 && (this.field_70331_k.func_82737_E() + (long)this.field_70329_l + (long)this.field_70330_m + (long)this.field_70327_n) % 200L == 0L) {
            this.numUsingPlayers = 0;
            float dist = 5.0f;
            List nearbyEntities = this.field_70331_k.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72332_a().func_72299_a((double)((float)this.field_70329_l - dist), (double)((float)this.field_70330_m - dist), (double)((float)this.field_70327_n - dist), (double)((float)(this.field_70329_l + 1) + dist), (double)((float)(this.field_70330_m + 1) + dist), (double)((float)(this.field_70327_n + 1) + dist)));
            for (EntityPlayer player : nearbyEntities) {
                TileStrongbox box;
                if (!(player.field_71070_bA instanceof ContainerStrongbox) || (box = ((ContainerStrongbox)player.field_71070_bA).getTile()) != this) continue;
                ++this.numUsingPlayers;
            }
        }
    }

    public void func_70316_g() {
        this.getNumPlayers();
        if (this.numUsingPlayers > 0 && !this.field_70331_k.field_72995_K && this.field_70331_k.func_82737_E() % 200L == 0L) {
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID(), 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        this.lidAngle = MathHelper.approachLinear((double)this.lidAngle, (double)(this.numUsingPlayers > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.prevLidAngle >= 0.5 && this.lidAngle < 0.5) {
            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.chestclosed", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
        } else if (this.prevLidAngle == 0.0 && this.lidAngle > 0.0) {
            this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "random.chestopen", 0.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean func_70315_b(int i, int j) {
        if (i == 1) {
            this.numUsingPlayers = j;
            return true;
        }
        return false;
    }

    public boolean onWrench(EntityPlayer player, int hitSide) {
        return this.rotateBlock();
    }

    public boolean openGui(EntityPlayer player) {
        if (this.canPlayerAccess(player.field_71092_bJ)) {
            player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        if (ServerHelper.isServerWorld((World)this.field_70331_k)) {
            player.func_71035_c(StringHelper.localize((String)"message.cofh.secure1") + " " + this.owner + "! " + StringHelper.localize((String)"message.cofh.secure2"));
        }
        return true;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addByte(this.type);
        payload.addByte((byte)this.access.ordinal());
        payload.addByte(this.facing);
        payload.addString(this.owner);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.type = payload.getByte();
        this.access = ISecureTile.AccessMode.values()[payload.getByte()];
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.facing = payload.getByte();
            this.owner = payload.getString();
            if (this.inventory.length <= 0) {
                this.inventory = new ItemStack[INV_SIZE[this.type]];
            }
        } else {
            payload.getByte();
            payload.getString();
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
    }

    public void receiveGuiNetworkData(int i, int j) {
        this.canAccess = j != 0;
    }

    public void sendGuiNetworkData(Container container, ICrafting player) {
        int access = 0;
        if (this.canPlayerAccess(((EntityPlayer)player).field_71092_bJ)) {
            access = 1;
        }
        player.func_71112_a(container, 0, access);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        this.type = nbt.func_74771_c("Type");
        this.facing = nbt.func_74771_c("Facing");
        this.access = ISecureTile.AccessMode.values()[nbt.func_74771_c("Access")];
        this.owner = nbt.func_74779_i("Owner");
        this.inventory = new ItemStack[INV_SIZE[this.type]];
        if (!enableSecurity) {
            this.access = ISecureTile.AccessMode.PUBLIC;
        }
        super.func_70307_a(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Type", this.type);
        nbt.func_74774_a("Facing", this.facing);
        nbt.func_74774_a("Access", (byte)this.access.ordinal());
        nbt.func_74778_a("Owner", this.owner);
    }

    @Override
    public void func_70295_k_() {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 1, this.numUsingPlayers);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
    }

    @Override
    public void func_70305_f() {
        if (this.func_70311_o() != null && this.func_70311_o() instanceof BlockStrongbox) {
            --this.numUsingPlayers;
            this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, 1, this.numUsingPlayers);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
        }
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    public boolean rotateBlock() {
        this.facing = BlockHelper.SIDE_LEFT[this.facing];
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public boolean setFacing(int side) {
        if (side < 2 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    public int[] func_94128_d(int side) {
        return this.access.isPublic() ? SLOTS[this.type] : TEProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.access.isPublic();
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return this.access.isPublic();
    }

    public boolean setAccess(ISecureTile.AccessMode access) {
        this.access = access;
        this.sendUpdatePacket(Side.SERVER);
        return true;
    }

    public ISecureTile.AccessMode getAccess() {
        return this.access;
    }

    public boolean setOwnerName(String name) {
        if (this.owner.equals("[None]")) {
            this.owner = name;
            return true;
        }
        return false;
    }

    public String getOwnerName() {
        return this.owner;
    }

    static {
        INV_SIZE = new int[]{1, 18, 36, 54, 72};
        SLOTS = new int[5][];
        enableSecurity = true;
        for (int i = 0; i < 5; ++i) {
            TileStrongbox.SLOTS[i] = new int[INV_SIZE[i]];
            for (int j = 0; j < INV_SIZE[i]; ++j) {
                TileStrongbox.SLOTS[i][j] = j;
            }
        }
        TileStrongbox.configure();
    }
}

