/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.fluid;

import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.fluid.BlockFluidInteractive;
import thermalexpansion.fluid.TEFluids;

public class BlockFluidPyrotheum
extends BlockFluidInteractive {
    public static boolean enableSourceFall = true;

    public BlockFluidPyrotheum(int id) {
        super(id, TEFluids.fluidPyrotheum, Material.field_76256_h, "pyrotheum");
        this.setQuantaPerBlock(5);
        this.setTickRate(25);
        this.func_71848_c(1000.0f);
        this.func_71868_h(1);
        this.setParticleColor(1.0f, 0.7f, 0.15f);
        this.addInteraction(Block.field_71978_w, Block.field_71981_t);
        this.addInteraction((Block)Block.field_71980_u, Block.field_71979_v);
        this.addInteraction(Block.field_71939_E, Block.field_71946_M);
        this.addInteraction(Block.field_71943_B, Block.field_71981_t);
        this.addInteraction((Block)Block.field_71942_A, Block.field_71981_t);
        this.addInteraction(Block.field_72041_aW, Block.field_111032_cD);
        this.addInteraction(Block.field_72036_aT, Block.field_71981_t);
        this.addInteraction(Block.field_72037_aS, null);
        for (int i = 0; i < 8; ++i) {
            this.addInteraction(Block.field_72057_aH.field_71990_ca, i, Block.field_71995_bx.field_71990_ca, i);
        }
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (!TEFluids.effectPyrotheum) {
            return;
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (!(entity instanceof EntityPlayer) && entity instanceof EntityCreeper) {
            world.func_72876_a(entity, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 6.0f, entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
            entity.func_70106_y();
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return TEFluids.fluidPyrotheum.getLuminosity();
    }

    public void func_71861_g(World world, int x, int y, int z) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, ForgeDirection face) {
        return TEFluids.effectPyrotheum ? 800 : 0;
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return 0;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, int metadata, ForgeDirection face) {
        return TEFluids.effectPyrotheum && face.ordinal() > ForgeDirection.UP.ordinal() && world.func_72798_a(x, y - 1, z) != this.field_71990_ca;
    }

    public boolean isFireSource(World world, int x, int y, int z, int metadata, ForgeDirection side) {
        return TEFluids.effectPyrotheum;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (TEFluids.effectPyrotheum) {
            this.checkForInteraction(world, x, y, z);
        }
        if (world.func_72805_g(x, y, z) == 0) {
            int bId = world.func_72798_a(x, y + this.densityDir, z);
            int bMeta = world.func_72805_g(x, y + this.densityDir, z);
            if (bId == this.field_71990_ca && bMeta != 0 || bId != 0 && Block.field_71973_m[bId].isFlammable((IBlockAccess)world, x, y + this.densityDir, z, bMeta, ForgeDirection.UP)) {
                world.func_72832_d(x, y + this.densityDir, z, this.field_71990_ca, 0, 3);
                world.func_94571_i(x, y, z);
                return;
            }
        }
        super.func_71847_b(world, x, y, z, rand);
    }

    protected void checkForInteraction(World world, int x, int y, int z) {
        if (world.func_72798_a(x, y, z) != this.field_71990_ca) {
            return;
        }
        int x2 = x;
        int y2 = y;
        int z2 = z;
        int result = -1;
        for (int i = 0; i < 6; ++i) {
            x2 = x + BlockHelper.SIDE_COORD_MOD[i][0];
            y2 = y + BlockHelper.SIDE_COORD_MOD[i][1];
            z2 = z + BlockHelper.SIDE_COORD_MOD[i][2];
            this.interactWithBlock(world, x2, y2, z2);
            this.interactWithBlock(world, x2 += BlockHelper.SIDE_COORD_MOD[i][0], y2, z2 += BlockHelper.SIDE_COORD_MOD[i][2]);
        }
        this.interactWithBlock(world, x - 1, y, z - 1);
        this.interactWithBlock(world, x - 1, y, z + 1);
        this.interactWithBlock(world, x + 1, y, z - 1);
        this.interactWithBlock(world, x + 1, y, z + 1);
    }

    protected void interactWithBlock(World world, int x, int y, int z) {
        int bId = world.func_72798_a(x, y, z);
        if (bId == 0 || bId == this.field_71990_ca) {
            return;
        }
        int bMeta = world.func_72805_g(x, y, z);
        int result = -1;
        if (this.hasInteraction(bId, bMeta)) {
            result = this.getInteraction(bId, bMeta);
            world.func_72832_d(x, y, z, ItemHelper.getIDFromHashCode((int)result), ItemHelper.getMetaFromHashCode((int)result), 3);
            this.triggerInteractionEffects(world, x, y, z);
        } else if (Block.field_71973_m[bId].isFlammable((IBlockAccess)world, x, y, z, bMeta, ForgeDirection.UP)) {
            world.func_94575_c(x, y, z, Block.field_72067_ar.field_71990_ca);
        } else if (world.isBlockSolidOnSide(x, y, z, ForgeDirection.UP) && world.func_72799_c(x, y + 1, z)) {
            world.func_72832_d(x, y + 1, z, Block.field_72067_ar.field_71990_ca, 0, 3);
        }
    }

    protected void triggerInteractionEffects(World world, int x, int y, int z) {
        if (CoreUtils.rand.nextInt(10) == 0) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        }
        for (int i = 0; i < 4; ++i) {
            world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

