/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.element;

import cofh.gui.GuiBase;
import cofh.gui.element.TabBase;
import cofh.util.StringHelper;
import java.util.List;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.tesseract.TileTesseract;

public class TabConfigTesseract
extends TabBase {
    public static final String[] TOOLTIPS = new String[]{StringHelper.localize((String)"info.thermalexpansion.modeSend"), StringHelper.localize((String)"info.thermalexpansion.modeRecv"), StringHelper.localize((String)"info.thermalexpansion.modeSendRecv"), StringHelper.localize((String)"info.thermalexpansion.modeBlocked")};
    TileTesseract myTile;
    String myPlayer;
    int headerColor = 14797103;
    int subheaderColor = 11186104;
    int textColor = 0;
    public static final String[] buttonNames = new String[]{"IconSendOnly", "IconRecvOnly", "IconSendRecv", "IconBlocked"};

    public TabConfigTesseract(GuiBase gui, TileTesseract theTile, String playerName) {
        super(gui);
        this.myPlayer = playerName;
        this.myTile = theTile;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.backgroundColor = 564812;
    }

    public void draw() {
        this.drawBackground();
        this.drawTabIcon("IconConfigTesseract");
        if (!this.isFullyOpened()) {
            return;
        }
        elementFontRenderer.func_78261_a(StringHelper.localize((String)"info.cofh.configuration"), this.posX + 20, this.posY + 6, this.headerColor);
        elementFontRenderer.func_78261_a(StringHelper.localize((String)"info.cofh.sending") + ":", this.posX + 8, this.posY + 42, this.subheaderColor);
        elementFontRenderer.func_78261_a(StringHelper.localize((String)"info.cofh.receiving") + ":", this.posX + 8, this.posY + 66, this.subheaderColor);
        this.gui.drawButton(buttonNames[this.myTile.modeItem], this.posX + 24, this.posY + 20, 1, 0);
        this.gui.drawButton(buttonNames[this.myTile.modeFluid], this.posX + 42, this.posY + 20, 1, 0);
        this.gui.drawButton(buttonNames[this.myTile.modeEnergy], this.posX + 60, this.posY + 20, 1, 0);
        String sending = "";
        String receiving = "";
        if (this.canReceiveAll()) {
            receiving = StringHelper.localize((String)"info.cofh.all");
        } else {
            if (this.myTile.canReceiveItems()) {
                receiving = receiving + StringHelper.localize((String)"info.cofh.items");
            }
            if (this.myTile.canReceiveFluid()) {
                if (this.myTile.canReceiveItems()) {
                    receiving = receiving + ", ";
                }
                receiving = receiving + StringHelper.localize((String)"info.cofh.fluid");
            }
            if (this.myTile.canReceiveEnergy()) {
                if (this.myTile.canReceiveItems() || this.myTile.canReceiveFluid()) {
                    receiving = receiving + ", ";
                }
                receiving = receiving + StringHelper.localize((String)"info.cofh.energy");
            }
            if (receiving.isEmpty()) {
                receiving = StringHelper.localize((String)"info.cofh.none");
            }
        }
        if (this.canSendAll()) {
            sending = StringHelper.localize((String)"info.cofh.all");
        } else {
            if (this.myTile.canSendItems()) {
                sending = sending + StringHelper.localize((String)"info.cofh.items");
            }
            if (this.myTile.canSendFluid()) {
                if (this.myTile.canSendItems()) {
                    sending = sending + ", ";
                }
                sending = sending + StringHelper.localize((String)"info.cofh.fluid");
            }
            if (this.myTile.canSendEnergy()) {
                if (this.myTile.canSendItems() || this.myTile.canSendFluid()) {
                    sending = sending + ", ";
                }
                sending = sending + StringHelper.localize((String)"info.cofh.energy");
            }
            if (sending.isEmpty()) {
                sending = StringHelper.localize((String)"info.cofh.none");
            }
        }
        elementFontRenderer.func_78276_b(sending, this.posX + 16, this.posY + 54, this.textColor);
        elementFontRenderer.func_78276_b(receiving, this.posX + 16, this.posY + 78, this.textColor);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean canReceiveAll() {
        return this.myTile.canReceiveItems() && this.myTile.canReceiveFluid() && this.myTile.canReceiveEnergy();
    }

    private boolean canSendAll() {
        return this.myTile.canSendItems() && this.myTile.canSendFluid() && this.myTile.canSendEnergy();
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(StringHelper.localize((String)"info.cofh.configuration"));
        }
        int x = this.gui.getMouseX() - this.currentShiftX;
        int y = this.gui.getMouseY() - this.currentShiftY;
        if (24 <= x && x < 40 && 20 <= y && y < 36) {
            list.add(StringHelper.localize((String)"info.thermalexpansion.modeItem") + ": " + TOOLTIPS[this.myTile.modeItem]);
        } else if (42 <= x && x < 58 && 20 <= y && y < 36) {
            list.add(StringHelper.localize((String)"info.thermalexpansion.modeFluid") + ": " + TOOLTIPS[this.myTile.modeFluid]);
        } else if (60 <= x && x < 76 && 20 <= y && y < 36) {
            list.add(StringHelper.localize((String)"info.thermalexpansion.modeEnergy") + ": " + TOOLTIPS[this.myTile.modeEnergy]);
        }
    }

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if ((x -= this.currentShiftX) < 18 || x > 82 || (y -= this.currentShiftY) < 16 || y > 40) {
            return false;
        }
        if (24 <= x && x < 40 && 20 <= y && y < 36) {
            if (mouseButton == 0) {
                this.myTile.incItemMode();
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.8f);
            } else if (mouseButton == 1) {
                this.myTile.decItemMode();
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.6f);
            }
            this.myTile.setTileInfo(this.myTile.frequency);
        } else if (42 <= x && x < 58 && 20 <= y && y < 36) {
            if (mouseButton == 0) {
                this.myTile.incFluidMode();
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.8f);
            } else if (mouseButton == 1) {
                this.myTile.decFluidMode();
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.6f);
            }
            this.myTile.setTileInfo(this.myTile.frequency);
        } else if (60 <= x && x < 76 && 20 <= y && y < 36) {
            if (mouseButton == 0) {
                this.myTile.incEnergyMode();
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.8f);
            } else if (mouseButton == 1) {
                this.myTile.decEnergyMode();
                elementSoundManager.func_77366_a("random.click", 1.0f, 0.6f);
            }
            this.myTile.setTileInfo(this.myTile.frequency);
        }
        return true;
    }

    protected void drawBackground() {
        super.drawBackground();
        if (!this.isFullyOpened()) {
            return;
        }
        float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
        float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
        float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
        GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
        this.gui.func_73729_b(this.posX + 18, this.posY + 16, 16, 20, 64, 24);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

