/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import cofh.block.BlockCoFHBase;
import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.tesseract.TileTesseract;
import thermalexpansion.core.TEProps;

@SideOnly(value=Side.CLIENT)
public class RenderTesseract
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static final RenderTesseract instance = new RenderTesseract();
    static Icon[] textureCenter = new Icon[2];
    static Icon[] textureFrame = new Icon[4];
    static CCModel modelCenter = CCModel.quadModel((int)24);
    static CCModel modelFrame = CCModel.quadModel((int)48);

    public static void initialize() {
        RenderTesseract.textureCenter[0] = IconRegistry.getIcon((String)"FluidEnder");
        RenderTesseract.textureCenter[1] = IconRegistry.getIcon((String)"SkyEnder");
        RenderTesseract.textureFrame[0] = IconRegistry.getIcon((String)"Tesseract");
        RenderTesseract.textureFrame[1] = IconRegistry.getIcon((String)"TesseractInner");
        RenderTesseract.textureFrame[2] = IconRegistry.getIcon((String)"TesseractActive");
        RenderTesseract.textureFrame[3] = IconRegistry.getIcon((String)"TesseractInnerActive");
    }

    public void renderCenter(int metadata, TileTesseract tile, double x, double y, double z) {
        if (tile != null && tile.isActive) {
            modelCenter.render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCenter[1]));
        } else {
            modelCenter.render(x, y, z, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureCenter[0]));
        }
    }

    public void renderFrame(int metadata, TileTesseract tile, double x, double y, double z) {
        Translation trans = RenderUtils.getRenderVector((double)x, (double)y, (double)z).translation();
        for (int i = 0; i < 6; ++i) {
            if (tile != null && tile.isActive && tile.redstoneControlOrDisable()) {
                modelFrame.render(i * 4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureFrame[2]), null);
                modelFrame.render(i * 4 + 24, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureFrame[3]), null);
                continue;
            }
            modelFrame.render(i * 4, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureFrame[0]), null);
            modelFrame.render(i * 4 + 24, 4, (Transformation)trans, (IUVTransformation)RenderUtils.getIconTransformation((Icon)textureFrame[1]), null);
        }
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.renderFrame(metadata, null, -0.5, -0.5, -0.5);
        this.renderCenter(metadata, null, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        GL11.glDisable((int)3042);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileTesseract)) {
            return false;
        }
        TileTesseract theTile = (TileTesseract)tile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (BlockCoFHBase.renderPass == 0) {
            this.renderFrame(0, theTile, x, y, z);
        } else {
            this.renderCenter(0, theTile, x, y, z);
        }
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdTesseract;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            offset = 0.0;
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        instance.renderFrame(0, null, offset, offset, offset);
        if (item.func_77960_j() == 129) {
            instance.renderCenter(0, null, offset, offset, offset);
        }
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        RenderHelper.setItemTextureSheet();
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    static {
        TEProps.renderIdTesseract = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        modelCenter.generateBlock(0, 0.15, 0.15, 0.15, 0.85, 0.85, 0.85).computeNormals();
        Cuboid6 box = new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        double inset = 0.1875;
        modelFrame = CCModel.quadModel((int)48).generateBlock(0, box);
        CCModel.generateBackface((CCModel)modelFrame, (int)0, (CCModel)modelFrame, (int)24, (int)24);
        modelFrame.computeNormals();
        for (int i = 24; i < 48; ++i) {
            RenderTesseract.modelFrame.verts[i].vec.add(RenderTesseract.modelFrame.normals[i].copy().multiply(inset));
        }
        modelFrame.computeLighting(LightModel.standardLightModel);
    }
}

